/*
 * Decompiled with CFR 0.152.
 */
package net.kldp.beat.action;

import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.kldp.beat.dispatcher.Dispatch;
import net.kldp.beat.dispatcher.ViewDispatcher;
import net.kldp.beat.map.ApplicationMap;
import net.kldp.beat.map.CookieMap;
import net.kldp.beat.map.HeaderMap;
import net.kldp.beat.map.ParameterMap;
import net.kldp.beat.map.RequestMap;
import net.kldp.beat.map.SessionMap;

public class ActionContext {
    private Map<String, Object> parameterMap;
    private Map<String, Object> requestMap;
    private Map<String, Object> sessionMap;
    private Map<String, Object> applicationMap;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private ServletContext context;
    private Dispatch dispatcher;
    private CookieMap cookieMap;
    private HeaderMap headerMap;

    public ActionContext(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ServletContext servletContext) throws ServletException {
        this.request = httpServletRequest;
        this.response = httpServletResponse;
        this.context = servletContext;
        this.dispatcher = ViewDispatcher.create(servletContext, httpServletRequest, httpServletResponse);
    }

    public Map<String, Object> getRequestMap() {
        if (this.requestMap == null) {
            this.requestMap = new RequestMap(this.request);
        }
        return this.requestMap;
    }

    public Map<String, Object> getApplicationMap() {
        if (this.applicationMap == null) {
            this.applicationMap = new ApplicationMap(this.context);
        }
        return this.applicationMap;
    }

    public Map<String, Object> getSessionMap() {
        if (this.sessionMap == null) {
            this.sessionMap = new SessionMap(this.request.getSession());
        }
        return this.sessionMap;
    }

    public Map<String, Object> getParameterMap() {
        if (this.parameterMap == null) {
            this.parameterMap = new ParameterMap(this.request);
        }
        return this.parameterMap;
    }

    public ServletContext getServletContext() {
        return this.context;
    }

    public HttpServletRequest getServletRequest() {
        return this.request;
    }

    public HttpServletResponse getServletResponse() {
        return this.response;
    }

    public Dispatch getDispatcher() {
        return this.dispatcher;
    }

    public void setParameterMap(Map<String, Object> map) {
        this.parameterMap = map;
    }

    public Map<String, Cookie> getCookieMap() {
        if (this.cookieMap == null) {
            this.cookieMap = new CookieMap(this.request.getCookies(), this.response);
        }
        return this.cookieMap;
    }

    public Map<String, String> getHeaderMap() {
        if (this.headerMap == null) {
            this.headerMap = new HeaderMap(this.request, this.response);
        }
        return this.headerMap;
    }
}

