/*
 * Decompiled with CFR 0.152.
 */
package net.kldp.beat.configuration;

import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import net.kldp.beat.configuration.ActionMapping;
import net.kldp.beat.configuration.ConfigParser;
import net.kldp.beat.exception.fatal.ConfigException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;

public class Config {
    private static final String SYSTEM_FILE = "/net/kldp/beat/configuration/beat.xml";
    private static final String USER_FILE = "/beat.xml";
    private static final String VERSION = "0.5";
    private static Log logger = LogFactory.getLog(Config.class);
    private static Class<?> cl;
    private static ConfigParser parser;

    public static String version() {
        return VERSION;
    }

    public static int bufferSize() {
        return Config.parser.bufferSize;
    }

    public static boolean devMode() {
        return Config.parser.devMode;
    }

    public static int maxSize() {
        return Config.parser.maxSize;
    }

    public static String saveDir() {
        if (Config.parser.saveDir.equals("")) {
            Config.parser.saveDir = Config.getDefaultTempDir();
        }
        return Config.parser.saveDir;
    }

    public static ActionMapping defaultMapping() {
        return Config.parser.defaultMapping;
    }

    public static ActionMapping getMapping(String string) {
        for (ActionMapping actionMapping : Config.parser.mappings) {
            if (!actionMapping.getMappingLocation().equals(string)) continue;
            return actionMapping;
        }
        return Config.parser.defaultMapping;
    }

    public static String viewType() {
        return Config.parser.viewType;
    }

    public static String viewSuffix() {
        if (Config.parser.viewType.equals("jsp")) {
            return "jsp";
        }
        if (Config.parser.viewType.equals("velocity")) {
            return "vm";
        }
        if (Config.parser.viewType.equals("freemaker")) {
            return "fm";
        }
        return "jsp";
    }

    private static boolean loadConfiguration(String string) throws ConfigException {
        URL uRL = cl.getResource(string);
        if (uRL != null) {
            try {
                parser = new ConfigParser(uRL.getPath());
                System.out.println(parser);
                return true;
            }
            catch (Exception exception) {
                logger.fatal((Object)exception);
                throw new ConfigException("can not parsing beat configuration file:" + string);
            }
        }
        return false;
    }

    public static void load(Class<?> clazz) throws ConfigException {
        cl = clazz;
        if (!Config.loadConfiguration(USER_FILE) && !Config.loadConfiguration(SYSTEM_FILE)) {
            throw new ConfigException("can not load beat configuration file");
        }
        parser.parse();
    }

    public static Properties loadProperties(String string) throws IOException {
        Properties properties = new Properties();
        properties.load(cl.getResourceAsStream(string));
        return properties;
    }

    private static String getDefaultTempDir() {
        return System.getProperty("java.io.tmpdir");
    }

    public static ApplicationContext getSpringContext() {
        return Config.parser.springContext;
    }

    public static String globalException() {
        return Config.parser.globalException;
    }
}

