/*
 * Decompiled with CFR 0.152.
 */
package net.kldp.beat.interceptor.pool;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import net.kldp.beat.interceptor.UserInterceptor;

public class UserInterceptorClassPool {
    private static Map<String, Class<? extends UserInterceptor>> interceptorClasses = new HashMap<String, Class<? extends UserInterceptor>>();

    public static Class<? extends UserInterceptor> get(String string) throws ClassNotFoundException {
        if (!interceptorClasses.containsKey(string)) {
            UserInterceptorClassPool.addInterceptor(string);
        }
        return interceptorClasses.get(string);
    }

    public static Class<? extends UserInterceptor> get(Annotation annotation) throws ClassNotFoundException {
        return UserInterceptorClassPool.get(annotation.getClass().getSimpleName());
    }

    private static void addInterceptor(String string) throws ClassNotFoundException {
        String string2 = "web.interceptor." + string + "Interceptor";
        Class<?> clazz = Class.forName(string2);
        if (!UserInterceptor.class.isAssignableFrom(clazz)) {
            throw new ClassNotFoundException("Interceptor is must implemented Interceptor interface");
        }
        try {
            clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new ClassNotFoundException("Interceptor is must implemented default constructor.");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ClassNotFoundException("Can not create new instance of Interceptor class.");
        }
        interceptorClasses.put(string, clazz);
    }
}

