/*
 * Decompiled with CFR 0.152.
 */
package net.kldp.beat.servlet;

import java.lang.annotation.Annotation;
import net.kldp.beat.annotation.Result;
import net.kldp.beat.configuration.ActionMapping;
import net.kldp.beat.configuration.Config;
import net.kldp.beat.exception.ServletPathParseException;
import net.kldp.beat.exception.UrlMappingException;
import net.kldp.beat.servlet.ActionClassFinder;
import net.kldp.beat.servlet.ServletPathParser;

public class ActionMapper {
    private ServletPathParser parser;
    private Object action;

    public ActionMapper(String string) {
        this.parser = new ServletPathParser(string, "action");
    }

    public Object getActionObject() throws UrlMappingException {
        try {
            if (this.action == null) {
                this.action = this.createAction();
            }
        }
        catch (Exception exception) {
            throw new UrlMappingException("can not found action class");
        }
        return this.action;
    }

    private Object createAction() throws ServletPathParseException, InstantiationException, IllegalAccessException, UrlMappingException, ClassNotFoundException {
        String string = this.parser.getTargetClassName();
        return ActionClassFinder.find(string).newInstance();
    }

    public String getDefaultView() {
        ActionMapping actionMapping = Config.getMapping(this.parser.getNamespace());
        return actionMapping.getViewLocation() + this.parser.getDefaultView(Config.viewSuffix());
    }

    public String getNamespace() {
        return this.parser.getNamespace();
    }

    public Result getDefaultResult() {
        final String[] stringArray = new String[]{};
        return new Result(){

            @Override
            public String name() {
                return "success";
            }

            @Override
            public String[] params() {
                return stringArray;
            }

            @Override
            public String type() {
                return "forward";
            }

            @Override
            public String value() {
                return ActionMapper.this.parser.getDefaultView(Config.viewSuffix());
            }

            @Override
            public Class<? extends Annotation> annotationType() {
                return Result.class;
            }

            @Override
            public String contentType() {
                return "text/html";
            }
        };
    }
}

