/*
 * Decompiled with CFR 0.152.
 */
package net.kldp.beat.system.interceptor;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.kldp.beat.action.ActionContext;
import net.kldp.beat.exception.fatal.InterceptorException;
import net.kldp.beat.interceptor.Interceptor;
import net.kldp.beat.interceptor.SystemInterceptor;
import net.kldp.beat.interceptor.UserInterceptor;
import net.kldp.beat.system.annotation.ApplicationMap;
import net.kldp.beat.system.annotation.CookieMap;
import net.kldp.beat.system.annotation.HeaderMap;
import net.kldp.beat.system.annotation.MultipartRequest;
import net.kldp.beat.system.annotation.Parameter;
import net.kldp.beat.system.annotation.ParameterMap;
import net.kldp.beat.system.annotation.RequestMap;
import net.kldp.beat.system.annotation.ServletContext;
import net.kldp.beat.system.annotation.ServletDispatcher;
import net.kldp.beat.system.annotation.ServletOutputStream;
import net.kldp.beat.system.annotation.ServletRequest;
import net.kldp.beat.system.annotation.ServletResponse;
import net.kldp.beat.system.annotation.SessionMap;
import net.kldp.beat.system.annotation.SpringApplicationContext;
import net.kldp.beat.system.interceptor.ApplicationMapInterceptor;
import net.kldp.beat.system.interceptor.CookieMapInterceptor;
import net.kldp.beat.system.interceptor.HeaderMapInterceptor;
import net.kldp.beat.system.interceptor.MultipartInterceptor;
import net.kldp.beat.system.interceptor.ParameterInterceptor;
import net.kldp.beat.system.interceptor.ParameterMapInterceptor;
import net.kldp.beat.system.interceptor.RequestMapInterceptor;
import net.kldp.beat.system.interceptor.ServletContextInterceptor;
import net.kldp.beat.system.interceptor.ServletDispatcherInterceptor;
import net.kldp.beat.system.interceptor.ServletOutputStreamInterceptor;
import net.kldp.beat.system.interceptor.ServletRequestInterceptor;
import net.kldp.beat.system.interceptor.ServletResponseInterceptor;
import net.kldp.beat.system.interceptor.SessionMapInterceptor;
import net.kldp.beat.system.interceptor.SpringApplicationContextInterceptor;

public abstract class InterceptorFactory
implements SystemInterceptor {
    private static HashMap<Class<? extends Annotation>, SystemInterceptor> interceptors = new HashMap();

    public static Interceptor getInterceptor(Annotation annotation) throws InterceptorException {
        return InterceptorFactory.getInterceptor(annotation.annotationType());
    }

    public static Interceptor getInterceptor(Class<? extends Annotation> clazz) throws InterceptorException {
        if (interceptors.containsKey(clazz)) {
            return interceptors.get(clazz);
        }
        return InterceptorFactory.createUserInterceptor(clazz);
    }

    private static Interceptor createUserInterceptor(Class<? extends Annotation> clazz) throws InterceptorException {
        String string = "web.interceptor." + clazz.getSimpleName() + "Interceptor";
        try {
            return (Interceptor)Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            throw new InterceptorException(exception);
        }
    }

    public static void intecept(UserInterceptor userInterceptor, ActionContext actionContext, Annotation annotation) throws InterceptorException {
        SystemInterceptor systemInterceptor = interceptors.get(annotation.annotationType());
        if (systemInterceptor != null) {
            systemInterceptor.intercept(userInterceptor, actionContext, annotation);
        }
    }

    public static void intecept(Object object, Map<SystemInterceptor, Annotation> map, ActionContext actionContext) throws InterceptorException {
        ArrayList<SystemInterceptor> arrayList = new ArrayList<SystemInterceptor>();
        SystemInterceptor systemInterceptor = null;
        for (SystemInterceptor systemInterceptor2 : map.keySet()) {
            if (systemInterceptor2 instanceof MultipartInterceptor) {
                systemInterceptor = systemInterceptor2;
                continue;
            }
            arrayList.add(systemInterceptor2);
        }
        if (systemInterceptor != null) {
            systemInterceptor.intercept(object, actionContext, map.get(systemInterceptor));
        }
        interceptors.get(Parameter.class).intercept(object, actionContext, new Parameter(){

            @Override
            public Class<? extends Annotation> annotationType() {
                return Parameter.class;
            }
        });
        for (SystemInterceptor systemInterceptor2 : arrayList) {
            systemInterceptor2.intercept(object, actionContext, map.get(systemInterceptor2));
        }
    }

    static {
        interceptors.put(ApplicationMap.class, new ApplicationMapInterceptor());
        interceptors.put(Parameter.class, new ParameterInterceptor());
        interceptors.put(ParameterMap.class, new ParameterMapInterceptor());
        interceptors.put(MultipartRequest.class, new MultipartInterceptor());
        interceptors.put(RequestMap.class, new RequestMapInterceptor());
        interceptors.put(ServletContext.class, new ServletContextInterceptor());
        interceptors.put(ServletDispatcher.class, new ServletDispatcherInterceptor());
        interceptors.put(ServletRequest.class, new ServletRequestInterceptor());
        interceptors.put(ServletResponse.class, new ServletResponseInterceptor());
        interceptors.put(ServletOutputStream.class, new ServletOutputStreamInterceptor());
        interceptors.put(HeaderMap.class, new HeaderMapInterceptor());
        interceptors.put(CookieMap.class, new CookieMapInterceptor());
        interceptors.put(SessionMap.class, new SessionMapInterceptor());
        interceptors.put(SpringApplicationContext.class, new SpringApplicationContextInterceptor());
    }
}

