package net.kldp.beat.interceptor;

import java.lang.annotation.Annotation;

import net.kldp.beat.exception.fatal.InterceptorException;

/**
 * 사용자 정의 인터셉터를 위한 인터페이스입니다.
 * 사용자 정의 인터셉터는 이 인터셉터를 구현하면 안됩니다.
 * 그 대신 서브 인터페이스인 BeforeInterceptor 또는 AfterInterceptor를
 * 구현해야 합니다. 
 * 
 */
public interface UserInterceptor extends Interceptor {
	boolean intercept(Object target, Annotation annotation) throws InterceptorException;
}