package net.kldp.beat.map;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

public class ParameterMap extends AbstractMap<String, Object> {

	private Map<String, Object> parameterMap = new HashMap<String, Object>();

	@SuppressWarnings("unchecked")
	public ParameterMap(HttpServletRequest request) {
		Enumeration keys = request.getParameterNames();
		while (keys.hasMoreElements()) {
			String key = (String) keys.nextElement();
			String[] value = request.getParameterValues(key);
			if (value.length == 1)
				parameterMap.put(key, value[0]);
			else
				parameterMap.put(key, value);
		}
	}

	@Override
	Object getAttribute(String key) {
		return parameterMap.get(key);
	}

	@Override
	Enumeration<String> getAttributeNames() {
		return Collections.enumeration(parameterMap.keySet());
	}

	@Override
	void removeAttribute(String key) {
		parameterMap.remove(key);
	}

	@Override
	void setAttribute(String key, Object value) {
		parameterMap.put(key, value);
	}
}