package net.kldp.beat.servlet;

import java.lang.annotation.Annotation;

import net.kldp.beat.annotation.Result;
import net.kldp.beat.configuration.ActionMapping;
import net.kldp.beat.configuration.Config;
import net.kldp.beat.exception.ServletPathParseException;
import net.kldp.beat.exception.UrlMappingException;

/**
 * URL에 따라 액션 클래스와 매핑합니다.
 * 
 */
public class ActionMapper {

	private ServletPathParser parser;
	private Object action;

	public ActionMapper(String servletPath) {
		this.parser = new ServletPathParser(servletPath, "action");
	}

	/**
	 * 액션 클래스의 인스턴스를 생성합니다.
	 * 
	 * @return
	 * @throws UrlMappingException
	 */
	public Object getActionObject() throws UrlMappingException {
		try {
			if (action == null)
				action = createAction();
		} catch (Exception e) {
			throw new UrlMappingException("can not found action class");
		}
		return action;
	}

	private Object createAction() throws ServletPathParseException,
			InstantiationException, IllegalAccessException,
			UrlMappingException, ClassNotFoundException {
		String target = parser.getTargetClassName();
		return ActionClassFinder.find(target).newInstance();
	}

	public String getDefaultView() {
		ActionMapping mapping = Config.getMapping(parser.getNamespace());
		return mapping.getViewLocation()
				+ parser.getDefaultView(Config.viewSuffix());
	}

	public String getNamespace() {
		return parser.getNamespace();
	}

	/**
	 * 사용자가 액션 클래스에 "success"를 정의하지 않았을 경우에 사용되는 Result입니다.
	 * 
	 * @return
	 */
	public Result getDefaultResult() {
		// 길이가 0 인 배열
		final String[] NULL_STRING_ARRAY = new String[0];
		return new Result() {
			public String name() {
				return "success";
			}

			public String[] params() {
				return (String[]) NULL_STRING_ARRAY;
			}

			public String type() {
				return "forward";
			}

			public String value() {
				return parser.getDefaultView(Config.viewSuffix());
			}

			public Class<? extends Annotation> annotationType() {
				return Result.class;
			}

			public String contentType() {
				return "text/html";
			}

		};
	}
}