package net.kldp.beat.servlet;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import net.kldp.beat.action.ActionContext;
import net.kldp.beat.action.ActionService;
import net.kldp.beat.configuration.Config;
import net.kldp.beat.configuration.DevMode;
import net.kldp.beat.exception.UrlMappingException;

/**
 * 모든 액션의 진입점 서블릿입니다. 모든 요청은 UTF-8로 처리됩니다.
 * 
 */
public class ActionServlet extends HttpServlet {

	private static final long serialVersionUID = 7123108057071289245L;

	public void destroy() {
		super.destroy();
	}

	@Override
	public void doPost(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
		doGet(request, response);
	}

	@Override
	protected void doGet(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		request.setCharacterEncoding("utf-8");
		ActionMapper mapper = new ActionMapper(request.getServletPath());
		try {
			Object action = mapper.getActionObject();
			ActionContext context = new ActionContext(request, response, getServletContext());
			ActionService service = new ActionService(context, action, mapper);
			service.doService();
		} catch (UrlMappingException e) {
			getServletContext().getRequestDispatcher(mapper.getDefaultView()).forward(request, response);
		} catch (ServletException e) {
			if(Config.globalException() != null || !Config.globalException().equals("")) {
				getServletContext().getRequestDispatcher(Config.globalException()).forward(request, response);
			} else {
				throw e;
			}
		}
	}

	public void init() throws ServletException {
		Config.load(getClass());
		DevMode.setDevMode(Config.devMode());
	}
}