package net.kldp.beat.system.interceptor;

import java.lang.annotation.Annotation;

import net.kldp.beat.action.ActionContext;
import net.kldp.beat.exception.fatal.InterceptorException;
import net.kldp.beat.interceptor.SystemInterceptor;
import net.kldp.beat.system.aware.SessionMapAware;

/**
 * 세션을 맵으로 주입합니다.
 *
 */
final class SessionMapInterceptor implements SystemInterceptor {

	@Override
	public void intercept(Object action, ActionContext context, Annotation annotation)
			throws InterceptorException {
		try {
			((SessionMapAware) action).setSession(context.getSessionMap());
		} catch (ClassCastException e) {
			throw new InterceptorException(e);
		}
	}
}