/**
 * Class Name	: Bmp2Png
 * Description	: BMP Ÿ ÷  PNG Ÿ ȯ
 * Date 				: 2002/11/27
 * Author			: Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * History			: 2002/11/27 first created.
 */
package com.conv2.imageGS.IMGFileIO;

import com.conv2.imageGS.ErrorMsg.*;
import com.conv2.imageGS.Exception.*;

import java.io.*;

/**
 * BMP Ÿ  PNG Ÿ  ȯѴ.<p>
 *  
 * @author conv2@nvision.gsnu.ac.kr
 * @version 1.0.0
 */
public class Bmp2Png
{
	private Bmp2Png() {}

   /**
     * BMP PNG ȯѴ. <p>
     * 
     * , ÷  Ѵ. 
     * 
	 * @param	bmp_fname	BMP  θ
     * @return    png_fname	ȯ PNG  θ 
     * @exception ImageGSException
     */	
	public static void run(String bmp_fname, String png_fname) throws ImageGSException
	{
		File fp_src = new File(bmp_fname);
		
		// bmp   ʴ´ٸ
		if(!fp_src.exists())
		{
			throw new ImageGSException("Bmp2Png.run() >> " + bmp_fname + " : " 
												 + ErrorMsg.ERRORTHISFILEISNOTEXIST);
		}

	
		IMGFileIO img = new IMGFileIO();
		img.readBMP(bmp_fname);
		
		PNGImage ps = new PNGImage(png_fname);
		ps.save(img.getRedChannel(), img.getGreenChannel(), img.getBlueChannel(), img.getHeight(), img.getWidth());
	}
}

