/**
 * Class Name	: BufferedImage2Channel
 * Description	: Java2D BufferedImage gray, RGB channel ȯ.
 * Date 				: 2002/10/31
 * Author			: Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * History			: 2002/10/31 first created.
 */

package com.conv2.imageGS.IMGFileIO;

import com.conv2.imageGS.Util.*;
import com.conv2.imageGS.ErrorMsg.*;
import com.conv2.imageGS.Exception.*;

import java.awt.image.*;

/**
 * Java2D BufferedImage gray, RGB channel ȯ.<p>
 * 
 * , BufferedImage TYPE_INT_RGB̾ Ѵ.<p>
 * 
 * @author Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * @version 1.0.0
 */
public class BufferedImage2Channel 
{
	private short[][] GrayChannel;
	private short[][] RedChannel;
	private short[][] GreenChannel;
	private short[][] BlueChannel;
	private int height = 0;
	private int width = 0;
	private BufferedImage bi;

	/**
	 * 
	 */
	public BufferedImage2Channel()
	{
		this.GrayChannel = null;
		this.RedChannel = null;
		this.GreenChannel = null;
		this.BlueChannel = null;
	}
	
	/**
	 * BufferedImage TYPE_RGB 쿡 gray channel ȯѴ.
	 * 
	 * @param	bi	BufferedImage type 
	 * @exception	ImageGSException bi  , bi Ÿ TYPE_INT_RGB ƴҶ
	 */
	public void gray(BufferedImage bi) throws ImageGSException
	{
		this.bi = bi;
		run();	
	}

	/**
	 * BufferedImage TYPE_RGB 쿡 Red, Green, Blue channel ȯѴ.
	 * 
	 * @param	bi	BufferedImage type 
	 * @exception	ImageGSException bi  , bi Ÿ TYPE_INT_RGB ƴҶ
	 */
	public void color(BufferedImage bi) throws ImageGSException
	{
		this.bi = bi;
		run();		
	}

	/**
	 * BufferedImage TYPE_RGB 쿡 gray, Red, Green, Blue channel ȯѴ.
	 * 
	 * @param	bi	BufferedImage type 
	 * @exception	ImageGSException bi  , bi Ÿ TYPE_INT_RGB ƴҶ
	 */
	public void all(BufferedImage bi) throws ImageGSException
	{
		this.bi = bi;
		run();	
	}
	
	/**
	 * ȯ  Red channel ȯѴ.
	 * 
	 * @return short type Red channel ȯ
     * @exception ImageGSException Red channel  ϶
	 */
	public short[][] getRedChannel() throws ImageGSException
	{
		if(RedChannel == null) 
			throw new ImageGSException (this.getClass().getName() + " >>  " 
				+ ErrorMsg.ERRORREDCHANNELISNULL );
			
		return RedChannel;
	}	

	/**
	 * ȯ  Green channel ȯѴ.
	 * 
	 * @return short type Green channel ȯ
     * @exception ImageGSException Green channel  ϶
	 */
	public short[][] getGreenChannel() throws ImageGSException
	{
		if(GreenChannel == null) 
			throw new ImageGSException (this.getClass().getName() + " >>  " 
				+ ErrorMsg.ERRORGREENCHANNELISNULL );
			
		return GreenChannel;
	}	
	
	/**
	 * ȯ  Blue channel ȯѴ.
	 * 
	 * @return short type Blue channel ȯ
     * @exception ImageGSException Blue channel  ϶
	 */
	public short[][] getBlueChannel() throws ImageGSException
	{
		if(BlueChannel == null) 
			throw new ImageGSException (this.getClass().getName() + " >>  " 
				+ ErrorMsg.ERRORBLUECHANNELISNULL );
			
		return BlueChannel;
	}		

	/**
	 * ȯ  Gray channel ȯѴ.
	 * 
	 * @return short type Gray channel ȯ
     * @exception ImageGSException Gray channel  ϶
	 */
	public short[][] getGrayChannel() throws ImageGSException
	{
		if(GrayChannel == null) 
			throw new ImageGSException (this.getClass().getName() + " >>  " 
				+ ErrorMsg.ERRORUNKNOWNSIZEOFGRAYIMG );
			
		return GrayChannel;
	}			
		
	/**
	 * BufferedImage Red, Green, Blue, Gray channel ȯϴ  κ
	 * ׷ gray, color, all      õǱ ...
	 */
	private void run() throws ImageGSException
	{
		int i, j;
		
		// null̸  Ȳ .
		if(bi == null)
		{
			throw new ImageGSException( this.getClass().getName() + " >> " 
													+ ErrorMsg.ERRORBUFFEREDIMAGEISNULL);		
		}
	
		// BufferedImage Ÿ TYPE_INT_RGB ƴϸ  Ȳ .	
		if(bi.getType() != java.awt.image.BufferedImage.TYPE_INT_RGB)
		{
			throw new ImageGSException( this.getClass().getName() + ">> "	
				+ ErrorMsg.ERRORTYPEOFBUFFEREDIMAGEISNOTTYPEINTRGB );
		}
		
		try 
		{		
			// ̿ ʺ Ѵ.
			height = bi.getHeight();
			width = bi.getWidth();
					
			//  ä ̶ ޸ ҴѴ.
			if(GrayChannel == null)  GrayChannel = InitMaskBuf.ShortInitMask(height, width);
			
			if(RedChannel == null) RedChannel = InitMaskBuf.ShortInitMask(height, width);
			if(GreenChannel == null) GreenChannel = InitMaskBuf.ShortInitMask(height, width);
			if(BlueChannel == null) BlueChannel = InitMaskBuf.ShortInitMask(height, width);				
	
			// ȯ 
			for(i=0; i<height; i++)
			{
				for(j=0; j<width; j++)
				{
		
					RedChannel[i][j] = this.getR(j,i);
					GreenChannel[i][j] = this.getG(j,i);
					BlueChannel[i][j] = this.getB(j,i);
					GrayChannel[i][j] = (short) ((float) this.getR(j, i) * 0.299
							+ (float) this.getG(j, i) * 0.587
							+ (float) this.getB(j, i) * 0.114);
				}
			} 	
		}
		catch (Exception e)
		{
			throw new ImageGSException( this.getClass().getName() + " >> " + e.getMessage() ); 
		}										
	}
	
	private short getR(int x, int y) 
	{
		return (short)(bi.getColorModel().getRed(bi.getRGB(x,y)));
	}

	private short getG(int x, int y) 
	{
		return (short)(bi.getColorModel().getGreen(bi.getRGB(x,y)));
	}

	private short getB(int x, int y) 
	{
		return (short)(bi.getColorModel().getBlue(bi.getRGB(x,y)));
	}		
}
