/**
 * Class Name	: IMGFileIO
 * Description	: image file handling class.
 * Date 				: 2003/10/20
 * Author			: Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * History			: 2001/07/28 first created.
 */

package com.conv2.imageGS.IMGFileIO;

import java.io.*;
import java.awt.image.*;

import com.conv2.imageGS.Util.*;
import com.conv2.imageGS.ErrorMsg.*;
import com.conv2.imageGS.Exception.*;
import com.conv2.imageGS.BinaryProc.*;

/**
 * ÷   ڵ鸵.<p>
 * 
 *    : JPEG, PNG, PPM, BMP, RAW, GIF (all, only color type).<p>
 * 
 * imageGS J2SE  δ , JIMI, JAI(Java advanced imaging) API  ʴ´.<br>
 * JAI Image I/O http://java.sun.com/products/java-media/jai/iio.html  ϶.<br>
 * ̿ پ    ڹ ҽ Ʈ Ʒ  Ʈ ϶.<br>
 * http://www.geocities.com/marcoschmidt.geo/java-image-coding.html<p>
 * 
 * [Ʈ ] <p>
 *
 * 2003/10/20 :   method ߰ <br>
 * 2003/05/12 : BufferedImage Ÿ ϴ method ߰ <br>
 * 2003/03/31 : GIF Handling κ ߰(,   ʽϴ.)  using JDK 1.4 ImageIO package<br>
 * 2002/11/28 : RAW Handling κ ߰ <br>
 * 2002/11/27 : BMP Handling κ ߰ <br>
 * 2002/11/23 :     method ߰ <br>
 * 2002/11/05 : method  ͼ  е  ù 빮ڸ ҹڷ  -> wrapper method ߰ <br>
 * 2002/10/30 : IMGFileIO ڵ <br>
 * 2002/10/25 : PNG Handling method ߰ using JDK 1.4 ImageIO package<br>
 * 2002/10/09 : getXXX() method ߰  ImageException Handling  <br>
 * 2002/10/07 : JPEG Handling method ߰, ImageException Handling  <br>
 * 2001/07/28 : PPM Handling method ߰<p>
 * 
 * [] <p>
 * 
 * GIF    ̴ LZW  ˰  Ư<br>
 * IBM UniSys   imageGS GIF   ʽϴ.<P>
 *  
 * @author Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * @version 1.3.8
 */
public class IMGFileIO 
{	
	/**
	 * ش ÷  height, getHeight() ̿   ִ.
	 */
	private int height = 0;

	/**
	 * ش ÷  width, getWidth() ̿   ִ.
	 */
	private int width = 0;
	
	/**
	 * ش ÷  Red channel, getRedChannel() ̿   ִ.
	 */
	private short[][] Red_ch;
	
	/**
	 * ش ÷  Green channel, getGreenChannel() ̿   ִ.
	 */	
	private short[][] Green_ch;

	/**
	 * ش ÷  Blue channel, getBlueChannel() ̿   ִ.
	 */
	private short[][] Blue_ch;
	
	/**
	 * ش ÷  Gray level image buf, getGrayChannel() ̿   ִ.
	 */
	private short[][] Gray_ch;
	
	/**
	 * ش ÷  BufferedImage, getBufferedImage() ̿   ִ. 
	 */
	private BufferedImage myBufferedImage = null;
	
	private String filename = null;

	
	/**
	 * 
	 */
	public IMGFileIO()	
	{
		this.Red_ch = null;
		this.Green_ch = null;
		this.Blue_ch = null;
		this.Gray_ch = null;	
		this.myBufferedImage = null;
	}
	
	/**
	 * Red channel ȯ
	 */
	public short [][] getRedChannel()throws ImageGSException
	{
		if(this.Red_ch == null)
		{
			throw new ImageGSException(this.getClass().getName() + " >> " + 
				ErrorMsg.ERRORREDCHANNELISNULL );	
		}
		
		return this.Red_ch;							
	}

	/**
	 * Green channel ȯ
	 */
	public short [][] getGreenChannel() throws ImageGSException
	{
		if(this.Green_ch == null)
		{
			throw new ImageGSException(this.getClass().getName() + " >> " + 
				ErrorMsg.ERRORGREENCHANNELISNULL );	
		}
		
		return this.Green_ch;							
	}

	/**
	 * Blue channel ȯ
	 */
	public short [][] getBlueChannel() throws ImageGSException
	{
		if(this.Blue_ch == null)
		{
			throw new ImageGSException(this.getClass().getName() + " >> " + 
				ErrorMsg.ERRORBLUECHANNELISNULL );	
		}
		
		return this.Blue_ch;							
	}
	
	/**
	 * Gray level image buf ȯ
	 */	
	public short [][] getGrayChannel()throws ImageGSException
	{
		if(this.Gray_ch == null)
		{
			throw new ImageGSException(this.getClass().getName() + " >> " + 
				ErrorMsg.ERRORUNKNOWNSIZEOFGRAYIMG );	
		}
		
		return this.Gray_ch;							
	}
	
	/**
	 * ش  ̸ ȯ
	 */
	public int getHeight()
	{
		return this.height;	
	}

	/**
	 * ش  ʺ ȯ
	 */
	public int getWidth()
	{
		return this.width;	
	}
	
	/**
	 * BuffredImage ȯ
	 */	
	public BufferedImage getBufferedImage() throws ImageGSException
	{
		if(this.myBufferedImage == null)
		{
			throw new ImageGSException(this.getClass().getName() + " >> " + 
				ErrorMsg.ERRORBUFFEREDIMAGEISNULL );	
		}
		return this.myBufferedImage;					
	}

	/**
	 *  ϸ ȯѴ.
	 */
	public String getReadFileName()
	{
		return this.filename;	
	}
	
	/**
	 * ش  оδ. (for BMP, PPM, JPEG, PNG, GIF)
	 */
	public void ReadFileName(String filename) throws ImageGSException
	{
		// raw  ó ȵǰ .
		int ExtName_start = filename.lastIndexOf("."); // Ȯڸ ۵Ǵ ġ
		String ExtName = filename.substring(ExtName_start+1);
		String LowerString = ExtName.toLowerCase();
		
		if( LowerString.equals("raw") )
		{
			throw new ImageGSException(
				this.getClass().getName()
				+ " >> "
				+ ErrorMsg.ERRORNOTSUPPORTFORMAT + " RAW! height and width are omiss! ");			
		}
		
		ReadFileName(filename, 0, 0);
	}
	
	/**
	 * ش  оδ. (for RAW)
	 */
	public void ReadFileName(String filename, int height, int width) throws ImageGSException
	{
	
		//ڰ Է ش filename  
		if(filename == null)
		{
			throw new ImageGSException(this.getClass().getName() + " >> " + 
				ErrorMsg.ERRORUSERVALUEISNULL );
		} 
		
		// ش filename  üũ
		File fp = new File(filename);
		
		// ش filename  ʴ´ٸ  Ȳ .
		if(fp.exists() == false)
		{
			throw new ImageGSException(this.getClass().getName() + " >> " + 
				ErrorMsg.ERRORTHISFILEISNOTEXIST );
		}
		
		this.filename = filename;
/*
		// ش    ϰ ִٸ  Ȳ .
		if(fp.canRead() == false) // if(!fp.canRead())  .
		{
			throw new ImageGSException(this.getClass().getName() + " >> " + 
											ErrorMsg.ERRORTHISISFILEISOCCUPIED );			
		}
*/
		// Ȯڸ ν
		int ExtName_start = filename.lastIndexOf("."); // Ȯڸ ۵Ǵ ġ
		String ExtName = filename.substring(ExtName_start+1);

		// ҹڷ ٲپش.
		String LowerString = ExtName.toLowerCase();

		if(LowerString.equals("ppm"))
		{
			try
			{
				ReadPPM(filename);
			} 
			catch(ImageGSException e) 
			{
				throw e; 	
			}
		}
		else if(LowerString.equals("jpg"))
		{
			try
			{
				ReadJPEG(filename);
			} 
			catch(ImageGSException e) 
			{
				throw e; 	
			}
		}
		else if(LowerString.equals("png"))
		{
			try
			{
				ReadPNG(filename);
			} 
			catch (ImageGSException e) 
			{
				throw e;	
			}	
		}
		else if(LowerString.equals("bmp"))
		{
			try
			{
				ReadBMP(filename);
			} 
			catch (ImageGSException e) 
			{
				throw e;	
			}				
		}
		else if(LowerString.equals("raw"))
		{
			try
			{
				ReadRAW(filename, height, width);
			} 
			catch (ImageGSException e) 
			{
				throw e;	
			}				
		}
		else if(LowerString.equals("gif"))
		{
			try
			{
				ReadGIF(filename);
			} 
			catch (ImageGSException e) 
			{
				throw e;	
			}				
		}
		else 
		{
			throw new ImageGSException(
				this.getClass().getName()
					+ " >> "
					+ ErrorMsg.ERRORNOTSUPPORTFORMAT);
		}
   }

	/**
	 *  R,G,B äΰ  ÿ ϵ ۸ Ѵ.
	 */
	public void ReadGIF(String filename) throws ImageGSException
	{
		try 
		{
			// GIFImage class 
			GIFImage img = new GIFImage(filename);
	
			// load ޽带 ȣѴ.
			img.load();

			// Red, Green, Blue channel ֱ
			Red_ch = img.getRedChannel();
			Green_ch = img.getGreenChannel();
			Blue_ch = img.getBlueChannel();
			Gray_ch = img.getGrayChannel();

			myBufferedImage = img.getBufferedImage();

			height = img.getHeight();
			width = img.getWidth();
		} 
		catch (ImageGSException e) {
			throw e; 
		}
	}

	/**
	 *  R,G,B äΰ  ÿ ϵ ۸ Ѵ.
	 */
	public void ReadRAW(String filename, int height, int width) throws ImageGSException
	{
		try 
		{
			// RAWImage class 
			RAWImage img = new RAWImage(filename, height, width);
	
			// load ޽带 ȣѴ.
			img.load();

			// Red, Green, Blue channel ֱ
			Red_ch = img.getRedChannel();
			Green_ch = img.getGreenChannel();
			Blue_ch = img.getBlueChannel();
			Gray_ch = img.getGrayChannel();

			myBufferedImage = img.getBufferedImage();

			height = img.getHeight();
			width = img.getWidth();
		} 
		catch (ImageGSException e) {
			throw e; 
		}
	}
	
	/**
	 *  R,G,B äΰ  ÿ ϵ ۸ Ѵ.
	 */
	public void ReadBMP(String filename) throws ImageGSException
	{
		try 
		{
			// BMPImage class 
			BMPImage img = new BMPImage(filename);
	
			// load ޽带 ȣѴ.
			img.load();

			// Red, Green, Blue channel ֱ
			Red_ch = img.getRedChannel();
			Green_ch = img.getGreenChannel();
			Blue_ch = img.getBlueChannel();
			Gray_ch = img.getGrayChannel();

			myBufferedImage = img.getBufferedImage();

			height = img.getHeight();
			width = img.getWidth();
		} 
		catch (ImageGSException e) {
			throw e; 
		}
	}


	/**
	 *  R,G,B äΰ  ÿ ϵ ۸ Ѵ.
	 */
	public void ReadJPEG(String filename) throws ImageGSException
	{
		try 
		{
			// JPEGImage class 
			JPEGImage img = new JPEGImage(filename);
	
			// load ޽带 ȣѴ.
			img.load();

			// Red, Green, Blue channel ֱ
			Red_ch = img.getRedChannel();
			Green_ch = img.getGreenChannel();
			Blue_ch = img.getBlueChannel();
			Gray_ch = img.getGrayChannel();

			myBufferedImage = img.getBufferedImage();

			height = img.getHeight();
			width = img.getWidth();
		} 
		catch (ImageGSException e) {
			throw e; 
		}
	}

	/**
	 *  R,G,B äΰ  ÿ ϵ ۸ Ѵ.
	 */
	public void ReadPNG(String filename) throws ImageGSException
	{
		try
		{
			// PNGImage class 
			PNGImage img = new PNGImage(filename);
	
			// load ޽带 ȣѴ.
			img.load();
			
			height = img.getHeight();
			width = img.getWidth();

			// Red, Green, Blue channel ֱ
			Red_ch =  img.getRedChannel();
			Green_ch =img.getGreenChannel();
			Blue_ch = img.getBlueChannel();
			Gray_ch = img.getGrayChannel();
			myBufferedImage = img.getBufferedImage();
			
		} catch (ImageGSException e) {
			throw e;
		}
	}
		
	/**
	 *  R,G,B äΰ  ÿ ϵ ۸ Ѵ.
	 */
	public void ReadPPM(String filename) throws ImageGSException
	{
		int i,j;

		try 
		{
			// PPMImage class 
			PPMImage img = new PPMImage(filename);
	
			// load ޽带 ȣѴ.
			img.load();
			
			height = img.getHeight();
			width = img.getWidth();

			// Red, Green, Blue channel ֱ
			Red_ch =  img.getRedChannel();
			Green_ch =img.getGreenChannel();
			Blue_ch = img.getBlueChannel();
			Gray_ch = img.getGrayChannel();
			myBufferedImage = img.getBufferedImage();

		} catch (ImageGSException e) {
			throw e;	
		}
	}
	
	/**
	 * ÷  Ѵ.
	 */
	public void WriteFileName(short[][] Out_Red_ch, 
							  short[][] Out_Green_ch, 
							  short[][] Out_Blue_ch)
		throws ImageGSException
	{
		this.WriteFileName(this.filename, 
									Out_Red_ch, 
									Out_Green_ch, 
									Out_Blue_ch, 
									GetSizeIMG.HeightFromGrayIMG(Out_Red_ch), 
									GetSizeIMG.WidthFromGrayIMG(Out_Red_ch)); 	
	}

	/**
	 * ÷  Ѵ.
	 */	
	public void WriteFileName(String filename, 
											short[][] Out_Red_ch, 
											short[][] Out_Green_ch, 
											short[][] Out_Blue_ch)
		throws ImageGSException
	{
		this.WriteFileName(filename, 
									Out_Red_ch, 
									Out_Green_ch, 
									Out_Blue_ch, 
									GetSizeIMG.HeightFromGrayIMG(Out_Red_ch), 
									GetSizeIMG.WidthFromGrayIMG(Out_Red_ch)); 	
	}

	/**
	 * ÷  Ѵ.
	 */	
	public void WriteFileName(String filename, 
											short[][] Out_Red_ch, 
											short[][] Out_Green_ch, 
											short[][] Out_Blue_ch, 
											int Height, 
											int Width) 
		throws  ImageGSException
	{
		//ڰ Է ش filename  
		if(filename == null)
		{
			throw new ImageGSException(this.getClass().getName() + " >> " + 
											ErrorMsg.ERRORUSERVALUEISNULL );
		} 
		
		/*
		// ش    ϰ ִٸ  Ȳ .
		if(fp.canWrite() == false) // if(!fp.canWrite())  .
		{
			throw new ImageGSException(this.getClass().getName() + " >> " + 
											ErrorMsg.ERRORTHISISFILEISOCCUPIED );			
		}
		*/

		// Ȯڸ ν
		int ExtName_start = filename.lastIndexOf("."); // Ȯڸ ۵Ǵ ġ
		String ExtName = filename.substring(ExtName_start+1);

		if(ExtName.equals("ppm"))
		{
			try 
			{
				WritePPM(filename, Out_Red_ch, Out_Green_ch, Out_Blue_ch, Height, Width);
			} 
			catch (ImageGSException e)
			{
				throw e;
			}
		}
		else if(ExtName.equals("jpg"))
		{
			try 
			{
				WriteJPEG(filename, Out_Red_ch, Out_Green_ch, Out_Blue_ch, Height, Width);
			} 
			catch(ImageGSException e) 
			{ 
				throw e; 
			}
		}
		else if(ExtName.equals("png"))
		{
			try
			{
				WritePNG(filename, Out_Red_ch, Out_Green_ch, Out_Blue_ch, Height, Width);	
			} 
			catch(ImageGSException e) 
			{ 
				throw e; 
			}
		}
		else if(ExtName.equals("bmp"))
		{
			try
			{
				WriteBMP(filename, Out_Red_ch, Out_Green_ch, Out_Blue_ch, Height, Width);	
			} 
			catch(ImageGSException e) 
			{ 
				throw e; 
			}			
		}
		else if(ExtName.equals("raw"))
		{
			try
			{
				WriteRAW(filename, Out_Red_ch, Out_Green_ch, Out_Blue_ch, Height, Width);	
			} 
			catch(ImageGSException e) 
			{ 
				throw e; 
			}			
		}
		else {
			throw new ImageGSException (this.getClass().getName() + " >> " + 
				ErrorMsg.ERRORNOTSUPPORTFORMAT );
		}
	}

	/**
	 * RAW  
	 */
	public void WriteRAW(String filename, 
										short[][] Red_ch,
										short[][] Green_ch, 
										short[][] Blue_ch, 
										int Height, 
										int Width) 
		throws ImageGSException
	{
		try 
		{
			// RAWImage class 
			RAWImage img = new RAWImage(filename, Height, Width);
	
			// save ޽带 ȣѴ.
			img.save(Red_ch, Green_ch, Blue_ch, Height, Width);
		} 
		catch (ImageGSException e) 
		{
			throw e; 
		}
	}
	
	/**
	 * BMP  
	 */
	public void WriteBMP(String filename, 
										short[][] Red_ch,
										short[][] Green_ch, 
										short[][] Blue_ch, 
										int Height, 
										int Width) 
		throws ImageGSException
	{
		try 
		{
			// BMPImage class 
			BMPImage img = new BMPImage(filename);
	
			// save ޽带 ȣѴ.
			img.save(Red_ch, Green_ch, Blue_ch, Height, Width);
		} 
		catch (ImageGSException e) 
		{
			throw e; 
		}
	}
	
	/**
	 * PNG  
	 */
	public void WritePNG(String filename, 
										short[][] Red_ch,
										short[][] Green_ch, 
										short[][] Blue_ch, 
										int Height, 
										int Width) 
		throws ImageGSException
	{
		try 
		{
			// PNGImage class 
			PNGImage img = new PNGImage(filename);

			// save ޽带 ȣѴ.
			img.save(Red_ch, Green_ch, Blue_ch, Height, Width);
		} 
		catch (ImageGSException e) 
		{
			throw e; 
		}
	}
	
	/**
	 * JPEG  
	 */
	public void WriteJPEG(String filename, 
										short[][] Red_ch, 
										short[][] Green_ch, 
										short[][] Blue_ch,
										int Height, 
										int Width) 
		throws ImageGSException
	{
		try 
		{
			// JPEGImage class 
			JPEGImage img = new JPEGImage(filename);
	
			// save ޽带 ȣѴ.
			img.save(Red_ch, Green_ch, Blue_ch, Height, Width);
		} 
		catch (ImageGSException e) 
		{
			throw e;
		}
	}
		
	/**
	 * PPM  
	 */
	public void WritePPM(String filename, 
										short[][] Red_ch, 
										short[][] Green_ch, 
										short[][] Blue_ch, 
										int Height, 
										int Width) 
		throws ImageGSException
	{
		try 
		{
			// PPMFile class 
			PPMImage img = new PPMImage(filename);
	
			// WriteImage ޽带 ȣѴ.
			img.save(Red_ch, Green_ch, Blue_ch, Height, Width);
		} 
		catch (ImageGSException e) 
		{
			throw e; 
		}
	}
	
	/**
	 * ϵ  Ѵ.
	 */
	public void WriteGrayFileName(short[][] Out_Gray_ch) throws ImageGSException
	{
		this.WriteGrayFileName(this.filename, Out_Gray_ch, 
											GetSizeIMG.HeightFromGrayIMG(Out_Gray_ch), 
											GetSizeIMG.WidthFromGrayIMG(Out_Gray_ch));		
	}
	
	/**
	 * ϵ  Ѵ.
	 */
	public void WriteGrayFileName(String filename, short[][] Out_Gray_ch) throws ImageGSException
	{
		this.WriteGrayFileName(filename, Out_Gray_ch, 
											GetSizeIMG.HeightFromGrayIMG(Out_Gray_ch), 
											GetSizeIMG.WidthFromGrayIMG(Out_Gray_ch));		
	}
	
	/**
	 * ϵ  Ѵ.
	 */
	public void WriteGrayFileName(String filename, short[][] Out_Gray_ch, int Height, int Width) throws ImageGSException
	{

		//ڰ Է ش filename  
		if(filename == null)
		{
			throw new ImageGSException(this.getClass().getName() + " >> " + 
				ErrorMsg.ERRORUSERVALUEISNULL );
		} 
		
		// ܻȲ üũ
		// GrayCh ΰ?
		if(Out_Gray_ch == null)
		{
			throw new ImageGSException (this.getClass().getName() + " >> " +
				ErrorMsg.ERRORUNKNOWNSIZEOFGRAYIMG );		
		}
		// Height, Width ˻
		if(Height != GetSizeIMG.HeightFromGrayIMG(Out_Gray_ch) )
		{
			throw new ImageGSException (this.getClass().getName() + " >> " +
				ErrorMsg.ERRORNOTEQUALSIZEANDSIZEOFGRAYIMG );
		}
		if(Width != GetSizeIMG.WidthFromGrayIMG(Out_Gray_ch))														
		{
			throw new ImageGSException (this.getClass().getName() + " >> " +
				ErrorMsg.ERRORNOTEQUALSIZEANDSIZEOFGRAYIMG );		
		}
		
		short[][] R = InitIMGBuf.ShortIMGBuf(Height, Width);
		short[][] G = InitIMGBuf.ShortIMGBuf(Height, Width);
		short[][] B = InitIMGBuf.ShortIMGBuf(Height, Width);
			
		for(int i=0; i<Height; i++)
		{
			for(int j=0; j<Width; j++)
			{
				R[i][j] = Out_Gray_ch[i][j];
				G[i][j] = Out_Gray_ch[i][j];
				B[i][j] = Out_Gray_ch[i][j];
			}
		}

		// Ȯڸ ν
		int ExtName_start = filename.lastIndexOf("."); // Ȯڸ ۵Ǵ ġ
		String ExtName = filename.substring(ExtName_start+1);

		String LowerString = null;

		// ҹڷ ٲپش.
		LowerString = ExtName.toLowerCase();

		if(LowerString.equals("ppm"))
		{
			try 
			{
				WritePPM(filename, R, G, B, Height, Width);
			} 
			catch (ImageGSException e) 
			{
				throw e;	
			}
		}
		else if(ExtName.equals("jpg"))
		{
			try 
			{
				WriteJPEG(filename, R, G, B, Height, Width);
			} 
			catch (ImageGSException e) 
			{
				throw e;	
			}
		}
		else if(ExtName.equals("png"))
		{
			try
			{
				WritePNG(filename, R, G, B, Height, Width);	
			} 
			catch(ImageGSException e) 
			{ 
				throw e; 
			}
		}
		else if(ExtName.equals("bmp"))
		{
			try
			{
				WriteBMP(filename, R, G, B, Height, Width);	
			} 
			catch(ImageGSException e) 
			{ 
				throw e; 
			}
		}
		else if(ExtName.equals("raw"))
		{
			try
			{
				WriteRAW(filename, R, G, B, Height, Width);	
			} 
			catch(ImageGSException e) 
			{ 
				throw e; 
			}
		}
		else 
		{
			throw new ImageGSException (this.getClass().getName() + " >> " + 
				ErrorMsg.ERRORNOTSUPPORTFORMAT );
		}
		
		return;
	}

	/**
	 *   Ѵ.
	 */
	public void WriteBinaryFileName(short[][] Out_Binary_ch) throws ImageGSException
	{
		this.WriteBinaryFileName(this.filename, Out_Binary_ch, 
											GetSizeIMG.HeightFromGrayIMG(Out_Binary_ch), 
											GetSizeIMG.WidthFromGrayIMG(Out_Binary_ch));		
	}
	
	/**
	 *   Ѵ.
	 */
	public void WriteBinaryFileName(String filename, short[][] Out_Binary_ch) throws ImageGSException
	{
		this.WriteBinaryFileName(filename, Out_Binary_ch, 
											GetSizeIMG.HeightFromGrayIMG(Out_Binary_ch), 
											GetSizeIMG.WidthFromGrayIMG(Out_Binary_ch));		
	}
	
	/**
	 *   Ѵ. 
	 */
	public void WriteBinaryFileName(String filename, short[][] Out_Binary_ch, int Height, int Width) throws ImageGSException
	{
		short[][] Out_Gray_ch = Binary2GrayIMG.ShortBinary2GrayIMG(Out_Binary_ch);
		this.WriteGrayFileName(filename,Out_Gray_ch, Height, Width);	
	}
		
	/**
	 *  ̻縦 ٿ , <p>
	 * 
	 * filename = "1.ppm"̰, ̻簡 "test" ̸<br>
	 * "1_test.ppm" ش. н  ȯѴ.
	 */
	public String GetWriteFileName(String filename, String Suffix)
	{
		String pureFileName = CreateFileName.getSuffix(filename, Suffix, null);
		return pureFileName;
	}
	
	/**
	 * ppm -> jpg or jpg -> ppm    Ȯڸ ٲ Ҷ Ѵ.<br>
	 * н  ȯѴ.
	 */
	public String GetWriteFileName(String filename, String Suffix, String fmt) 
	{
		String pureFileName = CreateFileName.getSuffix(filename, Suffix, fmt);
		return pureFileName;
	}
	
	//==== method  ͼ  е  ù 빮ڸ ҹڷ  =====//
	//==== Wrapper method =====//
	//==== Warning! : imageGS API  wrapper method    . ===//
	
	/**
	 * wrapper method
	 */
	public void readFileName(String filename) throws ImageGSException
	{
		this.ReadFileName(filename);	
	}

	/**
	 * wrapper method
	 */
	public void readFileName(String filename, int height, int width) throws ImageGSException
	{
		this.ReadFileName(filename, height, width);	
	}
	
	/**
	 *  wrapper method
	 */
	public void readJPEG(String filename) throws ImageGSException
	{
		this.ReadJPEG(filename);	
	}

	/**
	 *  wrapper method
	 */
	public void readPNG(String filename) throws ImageGSException
	{
		this.ReadPNG(filename);	
	}

	/**
	 *  wrapper method
	 */
	public void readPPM(String filename) throws ImageGSException
	{
		this.ReadPPM(filename);	
	}

	/**
	 *  wrapper method
	 */
	public void readBMP(String filename) throws ImageGSException
	{
		this.ReadBMP(filename);	
	}

	/**
	 *  wrapper method
	 */
	public void readRAW(String filename, int height, int width) throws ImageGSException
	{
		this.ReadRAW(filename, height, width);	
	}		
					
	/**
	 * wrapper method
	 */
	public void writeFileName(short[][] Out_Red_ch, 
											short[][] Out_Green_ch, 
											short[][] Out_Blue_ch)
		throws ImageGSException
	{
		this.WriteFileName(this.filename, 
									Out_Red_ch, 
									Out_Green_ch, 
									Out_Blue_ch, 
									GetSizeIMG.HeightFromGrayIMG(Out_Red_ch), 
									GetSizeIMG.WidthFromGrayIMG(Out_Red_ch)); 	
	}

	/**
	 * wrapper method
	 */	
	public void writeFileName(String filename, 
											short[][] Out_Red_ch, 
											short[][] Out_Green_ch, 
											short[][] Out_Blue_ch)
		throws ImageGSException
	{
		this.WriteFileName(filename, 
									Out_Red_ch, 
									Out_Green_ch, 
									Out_Blue_ch, 
									GetSizeIMG.HeightFromGrayIMG(Out_Red_ch), 
									GetSizeIMG.WidthFromGrayIMG(Out_Red_ch)); 	
	}

	/**
	 * wrapper method
	 */	
	public void writeFileName(String filename, 
											short[][] Out_Red_ch, 
											short[][] Out_Green_ch, 
											short[][] Out_Blue_ch, 
											int Height, 
											int Width) 
		throws  ImageGSException
	{
		this.WriteFileName(filename, Out_Red_ch, Out_Green_ch, Out_Blue_ch, Height, Width);
	}

									
	/**
	 * wrapper method
	 */
	public void writeGrayFileName(short[][] Out_Gray_ch) throws ImageGSException
	{
		this.WriteGrayFileName(this.filename, Out_Gray_ch, 
											GetSizeIMG.HeightFromGrayIMG(Out_Gray_ch), 
											GetSizeIMG.WidthFromGrayIMG(Out_Gray_ch));		
	}

	/**
	 * wrapper method
	 */
	public void writeGrayFileName(String filename, short[][] Out_Gray_ch) throws ImageGSException
	{
		this.WriteGrayFileName(filename, Out_Gray_ch, 
											GetSizeIMG.HeightFromGrayIMG(Out_Gray_ch), 
											GetSizeIMG.WidthFromGrayIMG(Out_Gray_ch));		
	}

	/**
	 * wrapper method
	 */
	public void writeGrayFileName(String filename, short[][] Out_Gray_ch, int Height, int Width) throws ImageGSException
	{
		this.WriteGrayFileName(filename, Out_Gray_ch, Height, Width);
	}		

	/**
	 * wrapper method
	 */
	public void writeBinaryFileName(short[][] Out_Binary_ch) throws ImageGSException
	{
		this.WriteBinaryFileName(this.filename, Out_Binary_ch, 
											GetSizeIMG.HeightFromGrayIMG(Out_Binary_ch), 
											GetSizeIMG.WidthFromGrayIMG(Out_Binary_ch));		
	}

	/**
	 * wrapper method
	 */
	public void writeBinaryFileName(String filename, short[][] Out_Binary_ch)
						throws ImageGSException
	{
		this.WriteBinaryFileName(filename, Out_Binary_ch, 
											GetSizeIMG.HeightFromGrayIMG(Out_Binary_ch), 
											GetSizeIMG.WidthFromGrayIMG(Out_Binary_ch));		
	}

	/**
	 * wrapper method
	 */
	public void writeBinaryFileName(String filename, short[][] Out_Binary_ch, int Height, int Width) throws ImageGSException
	{
		this.WriteBinaryFileName(filename, Out_Binary_ch, Height, Width);
	}		
	
	/**
	 *  wrapper method
	 */
	public void writeJPEG(String filename, 
										short[][] Red_ch,
										short[][] Green_ch, 
										short[][] Blue_ch, 
										int Height, 
										int Width) 
		throws ImageGSException
	{
		this.WriteJPEG(filename, Red_ch, Green_ch, Blue_ch, Height, Width);	
	}

	/**
	 *  wrapper method
	 */
	public void writePNG(String filename, 
										short[][] Red_ch,
										short[][] Green_ch, 
										short[][] Blue_ch, 
										int Height, 
										int Width) 
		throws ImageGSException
	{
		this.WritePNG(filename, Red_ch, Green_ch, Blue_ch, Height, Width);	
	}

	/**
	 *  wrapper method
	 */
	public void writePPM(String filename, 
										short[][] Red_ch,
										short[][] Green_ch, 
										short[][] Blue_ch, 
										int Height, 
										int Width) 
		throws ImageGSException
	{
		this.WritePPM(filename, Red_ch, Green_ch, Blue_ch, Height, Width);	
	}

	/**
	 *  wrapper method
	 */
	public void writeBMP(String filename, 
										short[][] Red_ch,
										short[][] Green_ch, 
										short[][] Blue_ch, 
										int Height, 
										int Width) 
		throws ImageGSException
	{
		this.WriteBMP(filename, Red_ch, Green_ch, Blue_ch, Height, Width);	
	}

	/**
	 *  wrapper method
	 */
	public void writeRAW(String filename, 
										short[][] Red_ch,
										short[][] Green_ch, 
										short[][] Blue_ch, 
										int Height, 
										int Width) 
		throws ImageGSException
	{
		this.WriteRAW(filename, Red_ch, Green_ch, Blue_ch, Height, Width);	
	}
					
	/**
	 * wrapper method
	 */
	public String getWriteFileName(String filename, String Suffix)
	{
		String pureFileName = this.GetWriteFileName(filename, Suffix);
		return pureFileName;
	}
	
	/**
	 * wrapper method
	 */
	public String getWriteFileName(String filename, String Suffix, String fmt) 
	{
		String pureFileName = this.GetWriteFileName(filename, Suffix, fmt);
		return pureFileName;
	}
	
////////////////////// BufferedImage  //////////////////////////////

	/**
	 * BufferedImage  Ѵ. (׻ BufferedImage Ÿ TYPE_INT_RGB̾ Ѵ)
	 */
	public void WriteFileName(String filename, BufferedImage bi) throws ImageGSException
	{
		BufferedImage2Channel bc = new BufferedImage2Channel();
		bc.all(bi);
		
		short[][] redChannel = bc.getRedChannel();
		short[][] greenChannel = bc.getGreenChannel();
		short[][] blueChannel = bc.getBlueChannel();
		
		writeFileName(filename, redChannel, greenChannel, blueChannel);
	}

	/**
	 * wrapper method. (׻ BufferedImage Ÿ TYPE_INT_RGB̾ Ѵ)
	 */
	public void writeFileName(String filename, BufferedImage bi) throws ImageGSException
	{
		WriteFileName(filename, bi);
	}

//	/**
//	 * BufferedImage ϵ  Ѵ. 
//	 */
//	public void WriteGrayFileName(String filename, BufferedImage bi) throws ImageGSException
//	{
//		BufferedImage2Channel bc = new BufferedImage2Channel();
//		bc.gray(bi);
//		
//		short[][] grayChannel = bc.getGrayChannel();
//		WriteGrayFileName(filename, grayChannel);
//	}
//
//	/**
//	 * wrapper method. 
//	 */
//	public void writeGrayFileName(String filename, BufferedImage bi) throws ImageGSException
//	{
//		WriteFileName(filename, bi);
//	}		
//
//	/**
//	 * BufferedImage   Ѵ. 
//	 */
//	public void WriteBinaryFileName(String filename, BufferedImage bi) throws ImageGSException
//	{
//		BufferedImage2Channel bc = new BufferedImage2Channel();
//		bc.gray(bi);
//		
//		short[][] grayChannel = bc.getGrayChannel();
//		WriteBinaryFileName(filename, grayChannel);
//	}
//
//	/**
//	 * wrapper method. 
//	 */
//	public void writeBinaryFileName(String filename, BufferedImage bi) throws ImageGSException
//	{
//		WriteFileName(filename, bi);
//	}

	/**
	 *   ֱ
	 * 
	 */	
	public void display() throws ImageGSException
	{
		display(null);
	}
	
	/**
	 *   ֱ
	 * 
	 * @param captionTitle â  Ÿ (ĸ)
	 */	
	public void display(String captionTitle) throws ImageGSException
	{
		try
		{
			if(captionTitle == null || captionTitle.equals("")) 
			{
				captionTitle = this.filename;
			}
			
			ChannelViewer.run( myBufferedImage, captionTitle );	
		}
		catch(ImageGSException e)
		{
			throw new ImageGSException(this.getClass().getName() + " >> "  + e.getMessage());
		}
	}
}
