/**
 * Class Name	: Png2Jpeg 
 * Description	: PNG Ÿ ÷  JPEG Ÿ ȯ
 * Date 				: 2002/10/25
 * Author			: Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * History			: 2002/10/25 first created.
 */
package com.conv2.imageGS.IMGFileIO;

import com.conv2.imageGS.ErrorMsg.*;
import com.conv2.imageGS.Exception.*;

import java.io.*;

/**
 * PNG Ÿ  JPEG  Ÿ  ȯѴ.<p>
 * 
 * , ÷  Ѵ. <p>
 *
 * JDK 1.4 ̻󿡼 <p>
 *  
 * @author conv2@nvision.gsnu.ac.kr
 * @version 1.0.0
 */
public class Png2Jpeg
{
	private Png2Jpeg() {}

   /**
     * PNG JPEG ȯѴ. 
     * 
	 * @param	png_fname	PNG  θ
     * @return    jpeg_fname	ȯ JPEG  θ 
     * @exception ImageGSException
     */	
	public static void run(String png_fname, String jpeg_fname) throws ImageGSException
	{
		File fp_src = new File(png_fname);
		
		// png   ʴ´ٸ
		if(!fp_src.exists())
		{
			throw new ImageGSException("Png2Jpeg.run() >> " + png_fname + " : " 
				+ ErrorMsg.ERRORTHISFILEISNOTEXIST);
		}

	
		IMGFileIO img = new IMGFileIO();
		img.ReadPNG(png_fname);
		
		JPEGImage js = new JPEGImage(jpeg_fname);
		js.save(img.getRedChannel(), img.getGreenChannel(), img.getBlueChannel(), img.getHeight(), img.getWidth());
	}
}
