/**
 * Class Name	: Ppm2Jpeg 
 * Description	: PPM Ÿ ÷  JPEG Ÿ ȯ
 * Date 				: 2002/10/08
 * Author			: Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * History			: 2002/10/08 first created.
 */
package com.conv2.imageGS.IMGFileIO;

import com.conv2.imageGS.ErrorMsg.*;
import com.conv2.imageGS.Exception.*;

import java.io.*;

/**
 * PPM Ÿ  JPEG  Ÿ  ȯѴ.<p>
 * , ÷  Ѵ. ̿ܿ   ս Ͽ Ѵ.<p>
 * 
 * @author conv2@nvision.gsnu.ac.kr
 * @version 1.0.0
 */
public class Ppm2Jpeg
{
	private Ppm2Jpeg() {}

   /**
     * PPM  JPEG ȯѴ. 
     * 
	 * @param	ppm_fname	PPM  θ
     * @return    jpeg_fname	ȯ JPEG  θ 
     * @exception ImageGSException
     * @exception IOException 
     */	
	public static void run(String ppm_fname, String jpeg_fname) throws ImageGSException
	{
		File fp_src = new File(ppm_fname);
		
		// ppm   ʴ´ٸ
		if(!fp_src.exists())
		{
			throw new ImageGSException("Ppm2Jpeg.run() >> " + ppm_fname + " : " 
				+ ErrorMsg.ERRORTHISFILEISNOTEXIST);
		}
/*		
		File fp_dest = new File(jpeg_fname);
		
		// jpeg     ̶ִ Ǵ   Ǿ  
		if(fp_dest.canWrite())
		{
			throw new ImageGSException("Ppm2Jpeg.run() >> " + jpeg_fname + " : " 
												 + ErrorMsg.ERRORTHISISFILEISOCCUPIED);
		}			
*/		
	
		IMGFileIO img = new IMGFileIO();
		img.ReadPPM(ppm_fname);
		
		JPEGImage js = new JPEGImage(jpeg_fname);
		js.save(img.getRedChannel(), img.getGreenChannel(), img.getBlueChannel(), img.getHeight(), img.getWidth());
	}
}
