/**
 * Class Name	: AbstractGS
 * Description	: AbstractGS Ŭ
 * Date 				: 2003/05/25
 * Author			: Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * History			: 2003/04/21 first created.
 */

package com.conv2.imageGS.Util;

import com.conv2.imageGS.ErrorMsg.*;
import com.conv2.imageGS.Exception.*;
import com.conv2.imageGS.GeometryProc.*;

/**
 * Abstract class for imageGS <p>
 * 
 * ش Է ۸  double type ȯѴ. <br>
 * ̿   imageGS API ο double type ߽ óϰ ȴ. <br>
 * ׷ short / integer type ó ϰ ϰ ִ. <p>
 *  
 * updated : integer type  (2003/05/25) <p>
 * 
 * @author Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * @version 1.0.0
 */
public class AbstractGS
{
    /**
     *     - short type
     */
	private short[][] ShortResultIMG = null;  //  

	/**
	 *     - double type
	 */
	private double[][] DoubleResultIMG = null; //  

	/**
	 *     - int type
	 */
	private int[][] IntegerResultIMG = null; //  
		
	/**
	 * argument Ѱ    ۸  
	 */
	private double[][] IMGBuf = null;
	
	/**
	 * short, double type Ǵϱ  
	 */
	private int DataType = -1;

	/**
	 * short type  ϴ 
	 */
	static final protected int SHORTTYPE = 0;
	
	/**
	 * double type ϴ 
	 */
	static final protected int DOUBLETYPE = 1;
	
	/**
	 * integer type ϴ 
	 */
	static final protected int INTEGERTYPE = 2;
	
	/**
	 * short, double type  ƴҶ  
	 */
	static final protected int ERROR = 3;
	
	/**
	 * ش   
	 */
	private int IMGBuf_height = 0;

	/**
	 * ش   ʺ 
	 */
	private int IMGBuf_width = 0;

    /**
     *  : short type  ۸ ʱȭѴ.
     * 
     * @param    ShortIMGBuf      IMGBuf 
     */
 	public AbstractGS(short[][] ShortIMGBuf)
	{
		this(ShortIMGBuf, -1, -1);
	}

    /**
     *  : short type  ۸ ʱȭѴ.
     * 
     * @param    ShortIMGBuf      IMGBuf 
     * @param	height	  IMGBuf  
     * @param	width	  IMGBuf  ʺ
     */
 	public AbstractGS(short[][] ShortIMGBuf, int height, int width) 
	{
		//  Ѵ..
		if(height == -1 && width == -1)
		{
			try
			{
				DataType = SHORTTYPE;
			
				// ش   , ʺ Ѵ.
				this.IMGBuf_height = GetSizeIMG.getHeight(ShortIMGBuf);
				this.IMGBuf_width = GetSizeIMG.getWidth(ShortIMGBuf);
				this.IMGBuf = CopyIMGBuf.CopyShort2DoubleGrayIMGBuf(ShortIMGBuf);
				
				//      ۸ ʱȭ Ѵ.
				initImageBuf();
			}
			catch(ImageGSException e) 
			{
				DataType = ERROR;
			}
		}
		// ƴϸ Ѱܿ ڸ ״ ִ´.
		else 
		{
			this.IMGBuf_height = height;
			this.IMGBuf_width = width;		

			//   ۸ ʱȭϿ ѱ.
			try 
			{
				DataType = SHORTTYPE;
	
				this.IMGBuf = CopyIMGBuf.CopyShort2DoubleGrayIMGBuf(ShortIMGBuf);
				
				//      ۸ ʱȭ Ѵ.
				initImageBuf();
			} 
			catch (ImageGSException e)
			{
				DataType = ERROR;
			}
		}						
	}
	
    /**
     *  : double type   ۸ ʱȭѴ.
     * 
     * @param    DoubleIMGBuf        IMGBuf 
     */
 	public AbstractGS(double[][] DoubleIMGBuf)
	{
		this(DoubleIMGBuf, -1, -1);
	}
	
    /**
     *  : double type   ۸ ʱȭѴ.
     * 
     * @param    DoubleIMGBuf        IMGBuf 
     * @param	height	  IMGBuf  
     * @param	width	  IMGBuf  ʺ
     */
 	public AbstractGS(double[][] DoubleIMGBuf, int height, int width)
	{
		//  Ѵ..
		if(height == -1 && width == -1)
		{
			try
			{
				DataType = DOUBLETYPE;
			
				// ش   , ʺ Ѵ.
				this.IMGBuf_height = GetSizeIMG.getHeight(DoubleIMGBuf);
				this.IMGBuf_width = GetSizeIMG.getWidth(DoubleIMGBuf);
				this.IMGBuf = CopyIMGBuf.CopyDoubleGrayIMGBuf(DoubleIMGBuf);
				
				//      ۸ ʱȭ Ѵ.
				initImageBuf();
			}
			catch(ImageGSException e) 
			{
				DataType = ERROR;
			}
		}
		// ƴϸ Ѱܿ ڸ ״ ִ´.
		else 
		{
			this.IMGBuf_height = height;
			this.IMGBuf_width = width;		

			//   ۸ ʱȭϿ ѱ.
			try 
			{
				DataType = DOUBLETYPE;
	
				this.IMGBuf = CopyIMGBuf.CopyDoubleGrayIMGBuf(DoubleIMGBuf);
				
				//      ۸ ʱȭ Ѵ.
				initImageBuf();
			} 
			catch (ImageGSException e)
			{
				DataType = ERROR;
			}
		}
	}
 
	/**
	 *  : integer type  ۸ ʱȭѴ.
	 * 
	 * @param    IntegerIMGBuf      IMGBuf 
	 */
	public AbstractGS(int[][] IntegerIMGBuf)
	{
		this(IntegerIMGBuf, -1, -1);
	}

	/**
	 *  : integer type  ۸ ʱȭѴ.
	 * 
	 * @param    IntegerIMGBuf      IMGBuf 
	 * @param	height	  IMGBuf  
	 * @param	width	  IMGBuf  ʺ
	 */
	public AbstractGS(int[][] IntegerIMGBuf, int height, int width) 
	{
		//  Ѵ..
		if(height == -1 && width == -1)
		{
			try
			{
				DataType = INTEGERTYPE;
			
				// ش   , ʺ Ѵ.
				this.IMGBuf_height = GetSizeIMG.getHeight(IntegerIMGBuf);
				this.IMGBuf_width = GetSizeIMG.getWidth(IntegerIMGBuf);
				this.IMGBuf = CopyIMGBuf.CopyInteger2DoubleGrayIMGBuf(IntegerIMGBuf);
				
				//      ۸ ʱȭ Ѵ.
				initImageBuf();
			}
			catch(ImageGSException e) 
			{
				DataType = ERROR;
			}
		}
		// ƴϸ Ѱܿ ڸ ״ ִ´.
		else 
		{
			this.IMGBuf_height = height;
			this.IMGBuf_width = width;		

			//   ۸ ʱȭϿ ѱ.
			try 
			{
				DataType = INTEGERTYPE;
	
				this.IMGBuf = CopyIMGBuf.CopyInteger2DoubleGrayIMGBuf(IntegerIMGBuf);
				
				//      ۸ ʱȭ Ѵ.
				initImageBuf();
			} 
			catch (ImageGSException e)
			{
				DataType = ERROR;
			}
		}						
	}
	
			
 	//===============================
	//    ȯ 
	//===============================
	
	/**
	 *   ۸ ȯѴ.
	 * 
	 * @return short type ResultIMG ȯ
	 */
	public short[][] getShortResultIMG() throws ImageGSException
	{
		if(ShortResultIMG != null)
		{
			return (short[][])ShortResultIMG;
		}
		//  μ short typeӿ double type  ޱ   ؼ ߰. 
		else if(DoubleResultIMG != null)// && ShortResultIMG == null && IntegerResultIMG == null )
		{
			return TypeConv2GrayIMG.Double2ShortGrayIMG( DoubleResultIMG );
		}
		else if(IntegerResultIMG != null) // && ShortResultIMG == null && DoubleResultIMG == null )
		{
			return TypeConv2GrayIMG.Integer2ShortGrayIMG( IntegerResultIMG );
		}
		else
		{
			return null;
		}
	}

	/**
	 *   ۸ ȯѴ.
	 * 
	 * @return double type ResultIMG ȯ
	 */	
	public double[][] getDoubleResultIMG() throws ImageGSException
	{
		if(DoubleResultIMG != null)
		{
			return (double[][])DoubleResultIMG;	
		}
		//  μ double typeӿ short type  ޱ   ؼ ߰. 
		else if(ShortResultIMG != null)// && DoubleResultIMG == null && IntegerResultIMG == null)
		{
			return TypeConv2GrayIMG.Short2DoubleGrayIMG( ShortResultIMG );
		}
		//  μ double typeӿ integer type  ޱ   ؼ ߰. 
		if(IntegerResultIMG != null) // && DoubleResultIMG == null  && ShortResultIMG == null)
		{
			return TypeConv2GrayIMG.Integer2DoubleGrayIMG( IntegerResultIMG );
		}
		else 
		{
			return 	null;
		}
	}

	/**
	 *   ۸ ȯѴ.
	 * 
	 * @return integer type ResultIMG ȯ
	 */	
	public int[][] getIntegerResultIMG() throws ImageGSException
	{
		if(IntegerResultIMG != null)
		{
			return (int[][])IntegerResultIMG;	
		}
		//  μ integer typeӿ short type  ޱ   ؼ ߰. 
		else if(ShortResultIMG != null)// && DoubleResultIMG == null && IntegerResultIMG == null)
		{
			return TypeConv2GrayIMG.Short2IntegerGrayIMG( ShortResultIMG );
		}
		//  μ integer typeӿ double type  ޱ   ؼ ߰. 
		if(DoubleResultIMG != null) // && DoubleResultIMG == null  && ShortResultIMG == null)
		{
			return TypeConv2GrayIMG.Double2IntegerGrayIMG( DoubleResultIMG );
		}
		else 
		{
			return 	null;
		}
	}
	
	/**
	 *   ۳     ο  ۸ ȯѴ. <br>
	 * 
	 * ,   ȼ ũ ⺻  3,  3 ŭ ȴ.<p>
	 * 
	 * @return short type ResultIMG ȯ
	 */	
	public short[][] getCenterShortResultIMG() throws ImageGSException
	{
		return CenterIMGBuf.CenterShortGrayIMGBuf(getShortResultIMG(), 3, 3);
	}

	/**
	 *   ۳     ο  ۸ ȯѴ. <br>
	 * 
	 * ,   ȼ ũ⸦ Ͽ Ѵ.<p>
	 * 
	 * @param pixels	ȼ ũ 
	 * @return short type ResultIMG ȯ
	 */	
	public short[][] getCenterShortResultIMG(int pixels) throws ImageGSException
	{
		return CenterIMGBuf.CenterShortGrayIMGBuf(getShortResultIMG(), pixels, pixels);
	}
	
	/**
	 *   ۳     ο  ۸ ȯѴ. <br>
	 * 
	 * ,   ȼ, Ʒ ȼ ũ⸦ Ͽ Ѵ.<p>
	 * 
	 * @param left_pixels	 ȼ ũ
	 * @param bottom_pixels Ʒ ȼ ũ 
	 * @return short type ResultIMG ȯ
	 */	
	public short[][] getCenterShortResultIMG(int left_pixels, int bottom_pixels) throws ImageGSException
	{
		return CenterIMGBuf.CenterShortGrayIMGBuf(getShortResultIMG(), left_pixels, bottom_pixels);
	}
		
	/**
	 *   ۳     ο  ۸ ȯѴ. <br>
	 * 
	 * ,   ȼ ũ ⺻  3,  3 ŭ ȴ.<p>
	 * 
	 * @return double type ResultIMG ȯ
	 */	
	public double[][] getCenterDoubleResultIMG() throws ImageGSException
	{
		return CenterIMGBuf.CenterDoubleGrayIMGBuf(getDoubleResultIMG(), 3, 3);
	}

	/**
	 *   ۳     ο  ۸ ȯѴ. <br>
	 * 
	 * ,   ȼ ũ⸦ Ͽ Ѵ.<p>
	 * 
	 * @param pixels	ȼ ũ 
	 * @return double type ResultIMG ȯ
	 */	
	public double[][] getCenterDoubleResultIMG(int pixels) throws ImageGSException
	{
		return CenterIMGBuf.CenterDoubleGrayIMGBuf(getDoubleResultIMG(), pixels, pixels);
	}
	
	/**
	 *   ۳     ο  ۸ ȯѴ. <br>
	 * 
	 * ,   ȼ, Ʒ ȼ ũ⸦ Ͽ Ѵ.<p>
	 * 
	 * @param left_pixels	 ȼ ũ
	 * @param bottom_pixels Ʒ ȼ ũ 
	 * @return double type ResultIMG ȯ
	 */	
	public double[][] getCenterDoubleResultIMG(int left_pixels, int bottom_pixels) throws ImageGSException
	{
		return CenterIMGBuf.CenterDoubleGrayIMGBuf(getDoubleResultIMG(), left_pixels, bottom_pixels);
	}

	/**
	 *   ۳     ο  ۸ ȯѴ. <br>
	 * 
	 * ,   ȼ ũ ⺻  3,  3 ŭ ȴ.<p>
	 * 
	 * @return integer type ResultIMG ȯ
	 */	
	public int[][] getCenterIntegerResultIMG() throws ImageGSException
	{
		return CenterIMGBuf.CenterIntegerGrayIMGBuf(getIntegerResultIMG(), 3, 3);
	}

	/**
	 *   ۳     ο  ۸ ȯѴ. <br>
	 * 
	 * ,   ȼ ũ⸦ Ͽ Ѵ.<p>
	 * 
	 * @param pixels	ȼ ũ 
	 * @return short type ResultIMG ȯ
	 */	
	public int[][] CenterIntegerResultIMG(int pixels) throws ImageGSException
	{
		return CenterIMGBuf.CenterIntegerGrayIMGBuf(getIntegerResultIMG(), pixels, pixels);
	}
	
	/**
	 *   ۳     ο  ۸ ȯѴ. <br>
	 * 
	 * ,   ȼ, Ʒ ȼ ũ⸦ Ͽ Ѵ.<p>
	 * 
	 * @param left_pixels	 ȼ ũ
	 * @param bottom_pixels Ʒ ȼ ũ 
	 * @return short type ResultIMG ȯ
	 */	
	public int[][] CenterIntegerResultIMG(int left_pixels, int bottom_pixels) throws ImageGSException
	{
		return CenterIMGBuf.CenterIntegerGrayIMGBuf(getIntegerResultIMG(), left_pixels, bottom_pixels);
	}

	/**
	 *   ۳  Ϻθ  ,  Է   ũ ŭ ο  ۸  ȯѴ. <br>
	 * 
	 * ,   ȼ ũ ⺻  3,  3 ŭ ȴ.<p>
	 * 
	 * @return short type ResultIMG ȯ
	 */	
	public short[][] getEnlargeShortResultIMG() throws ImageGSException
	{
		return getEnlargeShortResultIMG(3, 3);
	}

	/**
	 *   ۳  Ϻθ  ,  Է   ũ ŭ ο  ۸  ȯѴ. <br>
	 * 
	 * ,   ȼ ũ⸦ Ͽ Ѵ.<p>
	 * 
	 * @param pixels	ȼ ũ 
	 * @return short type ResultIMG ȯ
	 */	
	public short[][] getEnlargeShortResultIMG(int pixels) throws ImageGSException
	{
		return getEnlargeShortResultIMG(pixels, pixels);
	}
	
	/**
	 *   ۳  Ϻθ  ,  Է   ũ ŭ ο  ۸  ȯѴ. <br>
	 * 
	 * ,   ȼ, Ʒ ȼ ũ⸦ Ͽ Ѵ.<p>
	 * 
	 * @param left_pixels	 ȼ ũ
	 * @param bottom_pixels Ʒ ȼ ũ 
	 * @return short type ResultIMG ȯ
	 */	
	public short[][] getEnlargeShortResultIMG(int left_pixels, int bottom_pixels) throws ImageGSException
	{
		if(left_pixels <0 || bottom_pixels <0) return null;
		
		if(getShortResultIMG() == null)
		{
			throw new ImageGSException(ErrorMsg.ERRORUNKNOWNSIZEOFGRAYIMG );	
		}
		
		short[][] tmpImage = BoundaryIMGBuf.delete(getShortResultIMG(), left_pixels, bottom_pixels);

		if(tmpImage == null)
		{
			throw new ImageGSException(ErrorMsg.ERRORUNKNOWNSIZEOFGRAYIMG );	
		}
				
		BilinearInterp bilinear = GeometryProc.getBilinearInterp(tmpImage);
		bilinear.BilinearInterpOP(IMGBuf_height, IMGBuf_width);
				
		return bilinear.getShortResultIMG();
	}

	/**
	 *   ۳  Ϻθ  ,  Է   ũ ŭ ο  ۸  ȯѴ. <br>
	 * 
	 * ,   ȼ ũ ⺻  3,  3 ŭ ȴ.<p>
	 * 
	 * @return double type ResultIMG ȯ
	 */	
	public double[][] getEnlargeDoubleResultIMG() throws ImageGSException
	{
		return getEnlargeDoubleResultIMG(3, 3);
	}

	/**
	 *   ۳  Ϻθ  ,  Է   ũ ŭ ο  ۸  ȯѴ. <br>
	 * 
	 * ,   ȼ ũ⸦ Ͽ Ѵ.<p>
	 * 
	 * @param pixels	ȼ ũ 
	 * @return double type ResultIMG ȯ
	 */	
	public double[][] getEnlargeDoubleResultIMG(int pixels) throws ImageGSException
	{
		return getEnlargeDoubleResultIMG(pixels, pixels);
	}
	
	/**
	 *   ۳  Ϻθ  ,  Է   ũ ŭ ο  ۸  ȯѴ. <br>
	 * 
	 * ,   ȼ, Ʒ ȼ ũ⸦ Ͽ Ѵ.<p>
	 * 
	 * @param left_pixels	 ȼ ũ
	 * @param bottom_pixels Ʒ ȼ ũ 
	 * @return double type ResultIMG ȯ
	 */	
	public double[][] getEnlargeDoubleResultIMG(int left_pixels, int bottom_pixels) throws ImageGSException
	{
		if(left_pixels <0 || bottom_pixels <0) return null;
		
		if(getDoubleResultIMG() == null)
		{
			throw new ImageGSException(ErrorMsg.ERRORUNKNOWNSIZEOFGRAYIMG );	
		}
		
		double[][] tmpImage = BoundaryIMGBuf.delete(getDoubleResultIMG(), left_pixels, bottom_pixels);

		if(tmpImage == null)
		{
			throw new ImageGSException(ErrorMsg.ERRORUNKNOWNSIZEOFGRAYIMG );	
		}
				
		BilinearInterp bilinear = GeometryProc.getBilinearInterp(tmpImage);
		bilinear.BilinearInterpOP(IMGBuf_height, IMGBuf_width);
				
		return bilinear.getDoubleResultIMG();
	}

	/**
	 *   ۳  Ϻθ  ,  Է   ũ ŭ ο  ۸  ȯѴ. <br>
	 * 
	 * ,   ȼ ũ ⺻  3,  3 ŭ ȴ.<p>
	 * 
	 * @return integer type ResultIMG ȯ
	 */	
	public int[][] getEnlargeIntegerResultIMG() throws ImageGSException
	{
		return getEnlargeIntegerResultIMG(3, 3);
	}

	/**
	 *   ۳  Ϻθ  ,  Է   ũ ŭ ο  ۸  ȯѴ. <br>
	 * 
	 * ,   ȼ ũ⸦ Ͽ Ѵ.<p>
	 * 
	 * @param pixels	ȼ ũ 
	 * @return integer type ResultIMG ȯ
	 */	
	public int[][] getEnlargeIntegerResultIMG(int pixels) throws ImageGSException
	{
		return getEnlargeIntegerResultIMG(pixels, pixels);
	}
	
	/**
	 *   ۳  Ϻθ  ,  Է   ũ ŭ ο  ۸  ȯѴ. <br>
	 * 
	 * ,   ȼ, Ʒ ȼ ũ⸦ Ͽ Ѵ.<p>
	 * 
	 * @param left_pixels	 ȼ ũ
	 * @param bottom_pixels Ʒ ȼ ũ 
	 * @return integer type ResultIMG ȯ
	 */	
	public int[][] getEnlargeIntegerResultIMG(int left_pixels, int bottom_pixels) throws ImageGSException
	{
		if(left_pixels <0 || bottom_pixels <0) return null;
		
		if(getIntegerResultIMG() == null)
		{
			throw new ImageGSException(ErrorMsg.ERRORUNKNOWNSIZEOFGRAYIMG );	
		}
		
		int[][] tmpImage = BoundaryIMGBuf.delete(getIntegerResultIMG(), left_pixels, bottom_pixels);

		if(tmpImage == null)
		{
			throw new ImageGSException(ErrorMsg.ERRORUNKNOWNSIZEOFGRAYIMG );	
		}
		
		// double type ȯ, (why? BilinearInterp Integer type Է  ۸  ʱ .
		double[][] tmpImage2 = TypeConv2GrayIMG.Integer2DoubleGrayIMG( tmpImage );
		
		if(tmpImage2 == null)
		{
			throw new ImageGSException(ErrorMsg.ERRORUNKNOWNSIZEOFGRAYIMG );	
		}
								
		BilinearInterp bilinear = GeometryProc.getBilinearInterp(tmpImage2);
		bilinear.BilinearInterpOP(IMGBuf_height, IMGBuf_width);
				
		return bilinear.getIntegerResultIMG();
	}
		
	/**
	 *    ش   ۸ ʱȭѴ. 
	 */
	public void initImageBuf() throws ImageGSException
	{
		initImageBuf(IMGBuf_height, IMGBuf_width);	
	}
	
	/**
	 *    ش   ۸ ʱȭѴ. 
	 * 
	 * @param height ʱȭ   
	 * @param width ʱȭ   
	 */
	public void initImageBuf(int height, int width) throws ImageGSException
	{
		if(DataType == DOUBLETYPE)
		{
			if(DoubleResultIMG != null) DoubleResultIMG = null;
			DoubleResultIMG =  InitIMGBuf.DoubleIMGBuf(height, width);	
		}
		else if(DataType == SHORTTYPE)
		{
			if(ShortResultIMG != null) ShortResultIMG = null;
			ShortResultIMG =  InitIMGBuf.ShortIMGBuf(height, width);
		}
		else if(DataType == INTEGERTYPE)
		{
			if(IntegerResultIMG != null) IntegerResultIMG = null;
			IntegerResultIMG = InitIMGBuf.IntegerIMGBuf(height, width);					
		}
		//	IMGBuf ϰ ܻȲ .
		else if(DataType == ERROR)
		{
			throw new ImageGSException (ErrorMsg.ERRORUNKNOWNSIZEOFGRAYIMG );

		}
	}

	/**
	 *    ش   ۸ ʱȭѴ. (  ä) 
	 * 
	 * @param height ʱȭ   
	 * @param width ʱȭ   ʺ 
	 */
	public void initWhiteImageBuf(int height, int width) throws ImageGSException
	{
		if(DataType == DOUBLETYPE)
		{
			if(DoubleResultIMG != null) DoubleResultIMG = null;
			DoubleResultIMG = FillIMGBuf.FillDoubleGrayIMGBuf(255.0, height, width);
		}
		else if(DataType == SHORTTYPE)
		{
			if(ShortResultIMG != null) ShortResultIMG = null;
			ShortResultIMG = FillIMGBuf.FillShortGrayIMGBuf((short)255, height, width);
		}
		else if(DataType == INTEGERTYPE)
		{
			if(IntegerResultIMG != null) IntegerResultIMG = null;
			IntegerResultIMG = FillIMGBuf.FillIntegerGrayIMGBuf(255, height, width);				
		}
		//	IMGBuf ϰ ܻȲ .
		else if(DataType == ERROR)
		{
			throw new ImageGSException (ErrorMsg.ERRORUNKNOWNSIZEOFGRAYIMG );

		}
	}	

	/**
	 *    ش   ۸ ʱȭѴ. (  ä) 
	 */
	public void initWhiteImageBuf() throws ImageGSException
	{
		initWhiteImageBuf(IMGBuf_height, IMGBuf_width);		
	}
	
	/**
	 *    ش   ۸ ʱȭѴ. (  ä) 
	 * 
	 * @param height ʱȭ   
	 * @param width ʱȭ   ʺ 
	 */
	public void initBlackImageBuf(int height, int width) throws ImageGSException
	{
		if(DataType == DOUBLETYPE)
		{
			if(DoubleResultIMG != null) DoubleResultIMG = null;
			DoubleResultIMG = FillIMGBuf.FillDoubleGrayIMGBuf(0.0, height, width);
		}
		else if(DataType == SHORTTYPE)
		{
			if(ShortResultIMG != null) ShortResultIMG = null;
			ShortResultIMG = FillIMGBuf.FillShortGrayIMGBuf((short)0, height, width);
		}
		else if(DataType == INTEGERTYPE)
		{
			if(IntegerResultIMG != null) IntegerResultIMG = null;
			IntegerResultIMG = FillIMGBuf.FillIntegerGrayIMGBuf(0, height, width);		
		}
		//	IMGBuf ϰ ܻȲ .
		else if(DataType == ERROR)
		{
			throw new ImageGSException (ErrorMsg.ERRORUNKNOWNSIZEOFGRAYIMG );

		}
	}

	/**
	 *    ش   ۸ ʱȭѴ. (  ä) 
	 */
	public void initBlackImageBuf() throws ImageGSException
	{
		initBlackImageBuf(IMGBuf_height, IMGBuf_width);		
	}
	
	/**
	 *    ش   ۸ ʱȭѴ. ( ϴ ȭҰ ä.) 
	 * 
	 * @param height ʱȭ   
	 * @param width ʱȭ   ʺ 
	 * @param var ϴ ȭҰ( )
	 */
	public void initUserDefinedImageBuf(int height, int width, short var) throws ImageGSException
	{
		if(DataType == DOUBLETYPE)
		{
			if(DoubleResultIMG != null) DoubleResultIMG = null;
			DoubleResultIMG = FillIMGBuf.FillDoubleGrayIMGBuf((double)var, height, width);
		}
		else if(DataType == SHORTTYPE)
		{
			if(ShortResultIMG != null) ShortResultIMG = null;
			ShortResultIMG = FillIMGBuf.FillShortGrayIMGBuf(var, height, width);
		}
		else if(DataType == INTEGERTYPE)
		{
			if(IntegerResultIMG != null) IntegerResultIMG = null;
			IntegerResultIMG = FillIMGBuf.FillIntegerGrayIMGBuf((int)var, height, width);		
		}
		//	IMGBuf ϰ ܻȲ .
		else if(DataType == ERROR)
		{
			throw new ImageGSException (ErrorMsg.ERRORUNKNOWNSIZEOFGRAYIMG );

		}
	}

	/**
	 *    ش   ۸ ʱȭѴ. ( ϴ ȭҰ ä.) 
	 * 
	 * @param var ϴ ȭҰ( )
	 */
	public void initUserDefinedImageBuf(short var) throws ImageGSException
	{
		initUserDefinedImageBuf(IMGBuf_height, IMGBuf_width, var);		
	}
	
	/**
	 * ش   ۿ ȭҰ Ѵ. 
	 * 
	 * @param pixelHeight ش ȭ ̿ ϴ ġ
	 * @param pixelWidth ش ȭ ʺ ϴ ġ
	 * @param var Ϸ ȭҰ 
	 */
	public void setImageBuf(int pixelHeight, int pixelWidth, double var)
	{
		setImageBuf(pixelHeight, pixelWidth, var, true);
	}

	/**
	 * ش   ۿ ȭҰ Ѵ. 
	 * 
	 * @param pixelHeight ش ȭ ̿ ϴ ġ
	 * @param pixelWidth ش ȭ ʺ ϴ ġ
	 * @param var Ϸ ȭҰ 
	 */
	public void setImageBuf(int pixelHeight, int pixelWidth, short var)
	{
		setImageBuf(pixelHeight, pixelWidth, (double)var, true);
	}

	/**
	 * ش   ۿ ȭҰ Ѵ. 
	 * 
	 * @param pixelHeight ش ȭ ̿ ϴ ġ
	 * @param pixelWidth ش ȭ ʺ ϴ ġ
	 * @param var Ϸ ȭҰ 
	 */
	public void setImageBuf(int pixelHeight, int pixelWidth, int var)
	{
		setImageBuf(pixelHeight, pixelWidth, (double)var, true);
	}	
	
	/**
	 * ش   ۿ ȭҰ Ѵ. 
	 * 
	 * @param pixelHeight ش ȭ ̿ ϴ ġ
	 * @param pixelWidth ش ȭ ʺ ϴ ġ
	 * @param var Ϸ ȭҰ 
	 * @param clampingFlag Ŭ  
	 */
	public void setImageBuf(int pixelHeight, int pixelWidth, double var, boolean clampingFlag)
	{
		if(DataType == DOUBLETYPE)
		{
			if(clampingFlag)
			{
				DoubleResultIMG[pixelHeight][pixelWidth] =  Clamping.DoubleSaturation(var);
			}
			else 
			{
				DoubleResultIMG[pixelHeight][pixelWidth] = var;
			}
		}
		else if(DataType == SHORTTYPE)
		{
			if(clampingFlag)
			{
				ShortResultIMG[pixelHeight][pixelWidth] =  Clamping.ShortSaturation(var);			
			}
			else 
			{
				ShortResultIMG[pixelHeight][pixelWidth] = (short)var;
			}
		}
		else if(DataType == INTEGERTYPE)
		{
			if(clampingFlag)
			{
				IntegerResultIMG[pixelHeight][pixelWidth] =  Clamping.IntSaturation(var);			
			}
			else 
			{
				IntegerResultIMG[pixelHeight][pixelWidth] = (int)var;
			}
		}
	}

	/**
	 * ش   ۿ ȭҰ Ѵ. 
	 * 
	 * @param pixelHeight ش ȭ ̿ ϴ ġ
	 * @param pixelWidth ش ȭ ʺ ϴ ġ
	 * @param var Ϸ ȭҰ 
	 * @param clampingFlag Ŭ  
	 */
	public void setImageBuf(int pixelHeight, int pixelWidth, short var, boolean clampingFlag)
	{
		setImageBuf(pixelHeight, pixelWidth, (double)var, clampingFlag);
	}	

	/**
	 * ش   ۿ ȭҰ Ѵ. 
	 * 
	 * @param pixelHeight ش ȭ ̿ ϴ ġ
	 * @param pixelWidth ش ȭ ʺ ϴ ġ
	 * @param var Ϸ ȭҰ 
	 * @param clampingFlag Ŭ  
	 */
	public void setImageBuf(int pixelHeight, int pixelWidth, int var, boolean clampingFlag)
	{
		setImageBuf(pixelHeight, pixelWidth, (double)var, clampingFlag);
	}	
		
	/**
	 * ش   ۿ   Ѵ. 
	 * 
	 * @param image  Ϸ    
	 */
	public void setImageBuf(double [][] image) throws ImageGSException
	{
		if(DataType == DOUBLETYPE)
		{
			DoubleResultIMG = CopyIMGBuf.CopyDoubleGrayIMGBuf(image); 	
		}
		else if(DataType == SHORTTYPE)
		{
			ShortResultIMG = CopyIMGBuf.CopyDouble2ShortGrayIMGBuf(image);
		}
		else if(DataType == INTEGERTYPE)
		{
			IntegerResultIMG = CopyIMGBuf.CopyDouble2IntegerGrayIMGBuf(image);
		}
	}

	/**
	 * ش   ۿ   Ѵ. 
	 * 
	 * @param image  Ϸ    
	 */
	public void setImageBuf(short [][] image) throws ImageGSException
	{
		if(DataType == DOUBLETYPE)
		{
			DoubleResultIMG = CopyIMGBuf.CopyShort2DoubleGrayIMGBuf(image); 	
		}
		else if(DataType == SHORTTYPE)
		{
			ShortResultIMG = CopyIMGBuf.CopyShortGrayIMGBuf(image);
		}
		else if(DataType == INTEGERTYPE)
		{
			IntegerResultIMG = CopyIMGBuf.CopyShort2IntegerGrayIMGBuf(image);
		}
	}

	/**
	 * ش   ۿ   Ѵ. 
	 * 
	 * @param image  Ϸ    
	 */
	public void setImageBuf(int [][] image) throws ImageGSException
	{
		if(DataType == DOUBLETYPE)
		{
			DoubleResultIMG = CopyIMGBuf.CopyInteger2DoubleGrayIMGBuf(image); 	
		}
		else if(DataType == SHORTTYPE)
		{
			ShortResultIMG = CopyIMGBuf.CopyInteger2ShortGrayIMGBuf(image);
		}
		else if(DataType == INTEGERTYPE)
		{
			IntegerResultIMG = CopyIMGBuf.CopyIntegerGrayIMGBuf(image);
		}
	}

	/**
	 * 
	 * ش Է   ̸ ȯѴ.
	 * 
	 * @return ش    
	 */
	public int getOrgImageBufHeight() 
	{
		return IMGBuf_height;
	}

	/**
	 * 
	 * ش Է   ʺ ȯѴ.
	 * 
	 * @return ش   ʺ
	 */
	public int getOrgImageBufWidth() 
	{
		return IMGBuf_width;
	}

	/**
	 * 
	 * ش Է  ۸ ȯѴ.(!! ⺻ double type)
	 * 
	 * @return double type ش  
	 */
	public double[][] getOrgImageBuf() 
	{
		return IMGBuf;
	}	

	/**
	 * 
	 * ش Է  ۸ ȯѴ.
	 * 
	 * @return double type ش  
	 */
	public double[][] getOrgDoubleImageBuf() 
	{
		return IMGBuf;
	}	
	
	/**
	 * 
	 * ش Է  ۸ short type ȯѴ.(!!)
	 * 
	 * @return short type ش  
	 */
	public short[][] getOrgShortImageBuf() throws ImageGSException
	{
		return TypeConv2GrayIMG.Double2ShortGrayIMG(IMGBuf);
	}	

	/**
	 * 
	 * ش Է  ۸ ȯѴ.(!!)
	 * 
	 * @return integer type ش  
	 */
	public int[][] getOrgIntegerImageBuf()  throws ImageGSException
	{
		return TypeConv2GrayIMG.Double2IntegerGrayIMG(IMGBuf);
	}	

	/**
	 * 
	 * ش Է   Ÿ ȯѴ.
	 * 
	 * @return SHORT_TYPE, DOUBLE_TYPE
	 */
	public int getOrgImageBufType() 
	{
		return DataType;
	}		
}


