/**
 * Class Name	: ArraySorter
 * Description	: ü  
 * Date 				: 2003/01/13
 * Author			: Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * History			: 2002/01/13 first created.
 */

package com.conv2.imageGS.Util;

/**
 * ü 迭 / Ѵ.
 *  
 * @author Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * @version 1.0.0
 */

public final class ArraySorter
{
	/**
	 *  Ѵ.
	 * 
	 * @param a  ü 迭
	 * @param comparer ü  ̽  Ŭ
	 */
	public static void sort(Object[] a, Comparer comparer)
	{
		sort(a, null, 0, a.length -1, true, comparer);
	}

	/**
	 * / Ѵ.
	 * 
	 * @param a  ü 迭
	 * @param comparer ü  ̽  Ŭ
	 * @param ascending ̸ false, ̸ true 
	 */	
	public static void sort(Object[] a, Comparer comparer, boolean ascending)
	{
		sort(a, null, 0, a.length -1, ascending, comparer);		
	}

	/**
	 * / Ѵ.
	 * 
	 * @param a  ü 迭
	 * @param b    ü 迭
	 * @param from  ε
	 * @param to  ε
	 * @param comparer ü  ̽  Ŭ
	 * @param ascending ̸ false, ̸ true 
	 */	
	public static void sort(Object[] a, Object[] b, int from, int to, boolean ascending, Comparer comparer)
	{
		if(a == null || a.length < 2) return;

		int i = from;
		int j = to;

		Object center = a [ (from + to)/ 2];
		do
		{
			if(ascending)
			{
				while( (i<to) && (comparer.compare(center, a[i])>0))
					i++;
				while( (j>from) && (comparer.compare(center, a[j])<0))
					j--;
			}
			else 
			{
				while( (i<to) && (comparer.compare(center, a[i])<0))
					i++;
				while( (j>from) && (comparer.compare(center, a[j])>0))
					j--;
			}
	
			if(i < j)
			{
				Object temp = a[i]; a[i] = a[j]; a[j] = temp;
				if(b!=null)
				{
					temp = b[i]; b[i]=b[j]; b[j] = temp;
				}
			}

			if(i<=j) { i++; j--;}


		} while(i<=j);

		if(from < j) sort(a, b, from, j, ascending, comparer);
		if(i<to) sort(a, b, i, to, ascending, comparer);
	}

	/**
	 * ü  ̽
	 */
	public static interface Comparer
	{
		public int compare(Object a, Object b);
	}
}
