/**
 * Class Name	: ClassBrowser
 * Description	: Ŭ  ִ Ŭ
 * Date 				: 2003/09/16
 * Author			: Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * History			: 2003/09/16 first created.
 */

package com.conv2.imageGS.Util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

import com.conv2.imageGS.ErrorMsg.ErrorMsg;
import com.conv2.imageGS.Exception.ImageGSException;

/**
 * Ŭ  Class, Contructor, Field, Method ִ  Ŭ   Ѵ.<br>
 * Reflection API  μ,  Ŭ  Object Inspector     ִ.<br>
 * ,  Ŭ public  ִ μ, ڼ  reflect Ű ϶.<p>
 * 
 * @author Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * @version 1.0.0
 */
public class ClassBrowser
{
	private Class cl;

	/**
	 *  
	 * 
	 * @param str String Ÿ Ŭ 
	 */
	public ClassBrowser( String str ) throws ImageGSException
	{
		try 
		{
			this.cl = Class.forName( str );
		}
		catch( ClassNotFoundException e)
		{
			throw new ImageGSException(this.getClassName() + ">>" 
				+ ErrorMsg.ERRORNOTEXISTCLASS + " (" + str + ")");
		}
	}
		
	/**
	 *  
	 * 
	 * @param obj ü 
	 */
	public ClassBrowser( Object obj )
	{
		this.cl = obj.getClass();
	}
	
	/**
	 *  
	 * 
	 * @param cl Ŭ ü
	 */
	public ClassBrowser( Class cl )
	{
		this.cl = cl;
	}
	
	/**
	 *  θ ´. ) public 
	 */
	public String getModifierName() 
	{
		return Modifier.toString( cl.getModifiers() ) + " ";
	}

	/**
	 *  Ŭ or ̽ ´.
	 */
	public String getClassName() 
	{
		// ̸̽
		if( cl.isInterface() )
		{
			return cl.getName() + " ";	
		}
		else 
		{
			return "class " + cl.getName() + " ";
		}
	}	
	
	/**
	 * Ŭ ´. ,  Ŭ θ Ŭ ´.
	 */
	public String getSuperClassName()
	{
		if( cl.getSuperclass() != null)
		{
			 return "extends " + cl.getSuperclass().getName() + " ";
		}
		else return "";
	}

	/**
	 * ̽  ´. ,  Ŭ  ̽  ´.
	 */
	public String getInterfaceNames()
	{
		StringBuffer sb = new StringBuffer();

		Class[] classes = cl.getInterfaces();
		
		//  
		if( classes.length != 0)
		{
			sb.append("implements ");
			for(int i=0; i<classes.length; i++)
			{
				if( (i+1) != classes.length ) sb.append( classes[i].getName() + ", " );
				else sb.append( classes[i].getName() + "\n");			
			}
			
			return sb.toString();
		}
		else 
		{
			return "  \n";
		}
	}

	/**
	 * ڸ Ͽ   ´.
	 */
	public String getConstructorNames()
	{
		StringBuffer sb = new StringBuffer();
		sb.append( "<< Constructors >> \n");
		
		Constructor[] constructors = cl.getConstructors();

		if( constructors.length == 0 )
		{
			sb.append("\t\tNot found constructor that has \"public\" property  \n");
			return sb.toString();
		}
				
		for(int i=0; i<constructors.length; i++)
		{
			sb.append("\t\t"); sb.append( constructors[i] ); sb.append("\n");
		}
		
		return sb.toString();
	}
	
	/**
	 * ʵ Ͽ   ´. 
	 */
	public String getFieldNames()
	{
		StringBuffer sb = new StringBuffer();
		sb.append( "<< Fields >> \n");
		
		Field[] fields = cl.getFields();
		
		if( fields.length == 0 )
		{
			sb.append("\t\tNot found field that has \"public\" property  \n");
			return sb.toString();
		}
		
		for(int i=0; i<fields.length; i++)
		{
			sb.append("\t\t"); sb.append( fields[i] ); sb.append("\n");
		}
		
		return sb.toString();		
	}
	
	/**
	 * ޼ҵ Ͽ   ´.
	 */
	public String getMethodNames()
	{
		StringBuffer sb = new StringBuffer();
		sb.append( "<< Methods >> \n");
		
		Method[] method = cl.getMethods();
		
		if( method.length == 0 )
		{
			sb.append("\t\tNot found method that has \"public\" property  \n");
			return sb.toString();
		}
		
		for(int i=0; i<method.length; i++)
		{
			sb.append("\t\t"); sb.append( method[i] ); sb.append("\n");
		}
		
		return sb.toString();				
	}
	/**
	 * ش Ŭ  ü ش.
	 */
	public String toString()
	{
		StringBuffer sb = new StringBuffer();
		
		// 
		sb.append( getModifierName() ); 
		
		// Ŭ or ̽ 
		sb.append( getClassName() );
		
		// Ŭ ´.
		sb.append( getSuperClassName() );
		
		// ̽  ´.
		sb.append( getInterfaceNames() );
	
		// ڸ  ´.
		sb.append( getConstructorNames() );
		
		// ʵ  ´.
		sb.append( getFieldNames() );

		// ޼ҵ  ´.
		sb.append( getMethodNames() );
					
		return sb.toString();
	}
	
}
