/**
 * Class Name	: Debug 
 * Description	:  Ŭ
 * Date 				: 2002/12/18
 * Author			: Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * History			: 2002/12/18 first created.
 */

package com.conv2.imageGS.Util;

import java.io.*;

/**
 *  Ŭ. <p>
 *
 * String Ÿ ޽ System.out  ѷش.<br> 
 * ,  ȣ  ɼ, ¥-ð ǥð Ȱȭ Ǿ ִ ̴.<p>
 * 
 * [] JDK 1.4 ̻ ϰ ִٸ assert  ̿غ  Ѵ.<p>
 * 
 * @author conv2@nvision.gsnu.ac.kr
 * @version 1.0.0
 */
public class Debug 
{
	private static boolean debug_flag = true;
	private String ClassName = null;
	private boolean dateDisplay = true;
	
	/**
	 * 
	 */	
	public Debug() {}

	/**
	 * , ¥-ð κ ǥ  
	 * 
	 * @param	dateDisplay	¥-ð ǥ 
	 */	
	public Debug(boolean dateDisplay) 
	{
		this.dateDisplay = dateDisplay;
	}
	
	/**
	 * 
	 * 
	 * @param ClassName ڽ Ŭ (this.getClass().getName() )
	 */
	public Debug(String ClassName)
	{
		this.ClassName = ClassName;	
	}

	/**
	 * 
	 * 
	 * @param obj   ü
	 */
	public Debug(Object obj)
	{
		this.ClassName = obj.getClass().getName(); 	
	}

	/**
	 * , ¥-ð κ ǥ .
	 * 
	 * @param dateDisplay ¥-ð ǥ 
	 * @param ClassName ڽ Ŭ (this.getClass().getName() )
	 */
	public Debug(boolean dateDisplay, String ClassName)
	{
		this.dateDisplay = dateDisplay;
		this.ClassName = ClassName;	
	}

	/**
	 * , ¥-ð κ ǥ .
	 * 
	 * @param dateDisplay ¥-ð ǥ 
	 * @param obj   ü
	 */
	public Debug(boolean dateDisplay, Object obj)
	{
		this.dateDisplay = dateDisplay;
		this.ClassName = obj.getClass().getName(); 	
	}
				
	/**
	 *  Ȱȭ Ѵ.
	 */	
	public void setEnabled()
	{
		debug_flag = true;
	}

	/**
	 *  ȰȭǾ ִ°   Ǵ  ش.
	 */	
	public boolean isEnabled()
	{
		return debug_flag;
	}
	
	/**
	 *  Ȱȭ Ѵ.
	 */
	public void setDisabled()
	{
		debug_flag = false;
	}
	
	/**
	 * System.out  msg ѷش. , ¥-ð ǥ ΰ    ش.
	 * 
	 * @param	msg	  ޽
	 */
	public void println(String msg)
    {
    	if(debug_flag == true && this.ClassName == null) 
    	{
	    	println(System.out, msg);
    	}
	    else if(debug_flag == true && this.ClassName != null)
	    {
	    	println(System.out, this.ClassName, msg);
	    }
    }

    private void println(PrintStream pstream, String ClassName, String msg)
    {
    	if(dateDisplay) 
    	{
    		pstream.println("[" + SystemDate.getDateString("yyyy-MM-dd HH:mm:ss:SSS") + "] [" + ClassName+ "] " + msg);
    	}
    	else 
    	{ 
    		pstream.println("[" + ClassName+ "] " + msg); 
    	}	
    }
    
    private void println(PrintStream pstream, String msg)
    {
     	if(dateDisplay) 
    	{
    		pstream.println("[" + SystemDate.getDateString("yyyy-MM-dd HH:mm:ss:SSS") + "] " + msg);
    	}
    	else 
    	{
    		pstream.println(msg);
    	}	
    }
 }
