/**
 * Class Name	: Matrix
 * Description	: Matrix()  Ŭ
 * Date 				: 2003/03/21
 * Author			: Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * History			: 2002/03/20 first created.
 */
package com.conv2.imageGS.Util;

import com.conv2.imageGS.Exception.*;

/**
 *   Ŭ. 
 * 
 * @author conv2@nvision.gsnu.ac.kr
 * @version 1.0.0
 */
public class Matrix
{
	private Matrix() {}

	//====================  // (short type) ==========================//

	/**
	 *    
	 * 
	 * @param matrix1 1
	 * @param matrix2 2
	 * @return 1 2 Ͽ   ȯѴ.
	 * @exception 1 2 ̰ ġ  ,   ϶.
	 */
	public static short[][] add(short[][] matrix1, short[][] matrix2) throws ImageGSException
	{
		return shortAMD(matrix1, matrix2, 0);
	}

	/**
	 *    
	 * 
	 * @param matrix1 1
	 * @param matrix2 2
	 * @return 1 2    ȯѴ.
	 * @exception 1 2 ̰ ġ  ,   ϶.
	 */
	public static short[][] minus(short[][] matrix1, short[][] matrix2) throws ImageGSException
	{
		return shortAMD(matrix1, matrix2, 1);
	}

	/**
	 *    
	 * 
	 * @param matrix1 1
	 * @param matrix2 2
	 * @return 1 2    ȯѴ.
	 * @exception 1 2 ̰ ġ  ,   ϶.
	 */
	public static short[][] div(short[][] matrix1, short[][] matrix2) throws ImageGSException
	{
		return shortAMD(matrix1, matrix2, 2);
	}

	
	// , ,  ó.
	private static short[][] shortAMD(short[][] matrix1, short[][] matrix2, int method) 
					throws ImageGSException
	{
		String msg_add = "Matrix.add()";
		String msg_minus = "Matrix.minus()";
		String msg_div = "Matrix.div()";
		
		short[][] retMatrix = null;
		int matrix1_rows;
		int matrix1_cols;
		int matrix2_rows;
		int matrix2_cols;

		long tmp = 0;
		
		// matrix1 matrix2 ϳ  
		if(matrix1 == null || matrix2 == null)
		{
			if(method == 0)
			{
				throw new ImageGSException(msg_add + " >> matrix1 or matrix2 is null!");
			}
			else if(method == 1)
			{
				throw new ImageGSException(msg_minus + " >> matrix1 or matrix2 is null!");
			}
			else if(method == 2)
			{
				throw new ImageGSException(msg_div + " >> matrix1 or matrix2 is null!");
			}	
		}
		
		//   rows, cols ̸ Ѵ.
		matrix1_rows = matrix1.length;	matrix1_cols = matrix1[0].length;
		matrix2_rows = matrix2.length;	matrix2_cols = matrix2[0].length;
		
		// 1 2 ũⰡ  ƾ Ѵ.
		if((matrix1_rows!= matrix2_rows) || (matrix1_cols!= matrix2_cols))
		{
			if(method == 0)
			{
				throw new ImageGSException(msg_add + " >> don't match!!! size of matrix1, matrix2");
			}
			else if(method == 1)
			{
				throw new ImageGSException(msg_minus + " >> don't match!!! size of matrix1, matrix2");
			}
			else if(method == 2)
			{
				throw new ImageGSException(msg_div + " >> don't match!!! size of matrix1, matrix2");
			}	
		}
		
		//    retMask ʱȭѴ.
		retMatrix = InitMaskBuf.ShortInitMask(matrix1_rows, matrix1_cols);
	
		// .	
		for(int i=0; i<matrix1_rows; i++)
		{
			for(int j=0; j<matrix1_cols; j++)
			{
				if(method == 0)
				{
					tmp = matrix1[i][j] + matrix2[i][j];
				
					if(tmp > Short.MAX_VALUE) 
					{
						throw new ImageGSException(msg_add + " >> overflow Short.MAX_VALUE!!");
					}
					
					retMatrix[i][j] = (short)(matrix1[i][j] + matrix2[i][j]);		
				}				
				else if(method == 1)
				{
					tmp = matrix1[i][j] - matrix2[i][j];
				
					if(tmp > Short.MAX_VALUE) 
					{
						throw new ImageGSException(msg_add + " >> overflow Short.MAX_VALUE!!");
					}
					else if(tmp < Short.MIN_VALUE)
					{
						throw new ImageGSException(msg_add + " >> overflow Short.MIN_VALUE!!");
					}
					
					retMatrix[i][j] = (short)(matrix1[i][j] - matrix2[i][j]);		
				}	
				else if(method == 2)
				{
					retMatrix[i][j] = (short)(matrix1[i][j] / matrix2[i][j]);	
				}				
			}	
		}
					
		return retMatrix;				
	}

	/**
	 *  ĳ ּҰ ´. 
	 * 
	 * @param matrix 
	 * @return ּҰ
	 * @exception  ϶.
	 */
	public static short getMinVal(short[][] matrix) throws ImageGSException
	{
		// matrix  
		if(matrix == null)
		{
			throw new ImageGSException("Matrix.getMinVal() >> matrix is null!");
		}
			
		int height = GetSizeIMG.getHeight( matrix );
		int width = GetSizeIMG.getWidth( matrix );

		short minVal = 10000;
		
		for(int i=0; i<height; i++)
		{
			for(int j=0; j<width; j++)
			{
				if(matrix[i][j] < minVal ) minVal = matrix[i][j];	
			}
		}
		
		return minVal;
	}

	/**
	 *  ĳ ִ밪 ´. 
	 * 
	 * @param matrix 
	 * @return ּҰ
	 * @exception  ϶.
	 */
	public static short getMaxVal(short[][] matrix) throws ImageGSException
	{
		// matrix  
		if(matrix == null)
		{
			throw new ImageGSException("Matrix.getMinVal() >> matrix is null!");
		}
					
		int height = GetSizeIMG.getHeight( matrix );
		int width = GetSizeIMG.getWidth( matrix );

		short maxVal = -10000;
		
		for(int i=0; i<height; i++)
		{
			for(int j=0; j<width; j++)
			{
				if(matrix[i][j] > maxVal ) maxVal = matrix[i][j];	
			}
		}
		
		return maxVal;
	}
	
	//====================  // (integer type) ==========================//

	/**
	 *    
	 * 
	 * @param matrix1 1
	 * @param matrix2 2
	 * @return 1 2 Ͽ   ȯѴ.
	 * @exception 1 2 ̰ ġ  ,   ϶.
	 */
	public static int[][] add(int[][] matrix1, int[][] matrix2) throws ImageGSException
	{
		return intAMD(matrix1, matrix2, 0);
	}

	/**
	 *    
	 * 
	 * @param matrix1 1
	 * @param matrix2 2
	 * @return 1 2    ȯѴ.
	 * @exception 1 2 ̰ ġ  ,   ϶.
	 */
	public static int[][] minus(int[][] matrix1, int[][] matrix2) throws ImageGSException
	{
		return intAMD(matrix1, matrix2, 1);
	}

	/**
	 *    
	 * 
	 * @param matrix1 1
	 * @param matrix2 2
	 * @return 1 2    ȯѴ.
	 * @exception 1 2 ̰ ġ  ,   ϶.
	 */
	public static int[][] div(int[][] matrix1, int[][] matrix2) throws ImageGSException
	{
		return intAMD(matrix1, matrix2, 2);
	}

	// , ,  ó.
	private static int[][] intAMD(int[][] matrix1, int[][] matrix2, int method) 
					throws ImageGSException
	{
		String msg_add = "Matrix.add()";
		String msg_minus = "Matrix.minus()";
		String msg_div = "Matrix.div()";
		
		int[][] retMatrix = null;
		int matrix1_rows;
		int matrix1_cols;
		int matrix2_rows;
		int matrix2_cols;

		long tmp = 0;
		
		// matrix1 matrix2 ϳ  
		if(matrix1 == null || matrix2 == null)
		{
			if(method == 0)
			{
				throw new ImageGSException(msg_add + " >> matrix1 or matrix2 is null!");
			}
			else if(method == 1)
			{
				throw new ImageGSException(msg_minus + " >> matrix1 or matrix2 is null!");
			}
			else if(method == 2)
			{
				throw new ImageGSException(msg_div + " >> matrix1 or matrix2 is null!");
			}	
		}
		
		//   rows, cols ̸ Ѵ.
		matrix1_rows = matrix1.length;	matrix1_cols = matrix1[0].length;
		matrix2_rows = matrix2.length;	matrix2_cols = matrix2[0].length;
		
		// 1 2 ũⰡ  ƾ Ѵ.
		if((matrix1_rows!= matrix2_rows) || (matrix1_cols!= matrix2_cols))
		{
			if(method == 0)
			{
				throw new ImageGSException(msg_add + " >> don't match!!! size of matrix1, matrix2");
			}
			else if(method == 1)
			{
				throw new ImageGSException(msg_minus + " >> don't match!!! size of matrix1, matrix2");
			}
			else if(method == 2)
			{
				throw new ImageGSException(msg_div + " >> don't match!!! size of matrix1, matrix2");
			}	
		}
		
		//    retMask ʱȭѴ.
		retMatrix = InitMaskBuf.IntegerInitMask(matrix1_rows, matrix1_cols);
	
		// .	
		for(int i=0; i<matrix1_rows; i++)
		{
			for(int j=0; j<matrix1_cols; j++)
			{
				if(method == 0)
				{
					tmp = matrix1[i][j] + matrix2[i][j];
				
					if(tmp > Integer.MAX_VALUE) 
					{
						throw new ImageGSException(msg_add + " >> overflow Integer.MAX_VALUE!!");
					}
					
					retMatrix[i][j] = matrix1[i][j] + matrix2[i][j];		
				}				
				else if(method == 1)
				{
					tmp = matrix1[i][j] - matrix2[i][j];
				
					if(tmp > Short.MAX_VALUE) 
					{
						throw new ImageGSException(msg_add + " >> overflow Integer.MAX_VALUE!!");
					}
					else if(tmp < Short.MIN_VALUE)
					{
						throw new ImageGSException(msg_add + " >> overflow Integer.MIN_VALUE!!");
					}
					
					retMatrix[i][j] = matrix1[i][j] - matrix2[i][j];		
				}	
				else if(method == 2)
				{
					retMatrix[i][j] = matrix1[i][j] / matrix2[i][j];	
				}				
			}	
		}
					
		return retMatrix;				
	}

	/**
	 *  ĳ ּҰ ´. 
	 * 
	 * @param matrix 
	 * @return ּҰ
	 * @exception  ϶.
	 */
	public static int getMinVal(int[][] matrix) throws ImageGSException
	{
		// matrix  
		if(matrix == null)
		{
			throw new ImageGSException("Matrix.getMinVal() >> matrix is null!");
		}
			
		int height = GetSizeIMG.getHeight( matrix );
		int width = GetSizeIMG.getWidth( matrix );

		int minVal = 10000000;
		
		for(int i=0; i<height; i++)
		{
			for(int j=0; j<width; j++)
			{
				if(matrix[i][j] < minVal ) minVal = matrix[i][j];	
			}
		}
		
		return minVal;
	}

	/**
	 *  ĳ ִ밪 ´. 
	 * 
	 * @param matrix 
	 * @return ּҰ
	 * @exception  ϶.
	 */
	public static int getMaxVal(int[][] matrix) throws ImageGSException
	{
		// matrix  
		if(matrix == null)
		{
			throw new ImageGSException("Matrix.getMinVal() >> matrix is null!");
		}
					
		int height = GetSizeIMG.getHeight( matrix );
		int width = GetSizeIMG.getWidth( matrix );

		int maxVal = -10000000;
		
		for(int i=0; i<height; i++)
		{
			for(int j=0; j<width; j++)
			{
				if(matrix[i][j] > maxVal ) maxVal = matrix[i][j];	
			}
		}
		
		return maxVal;
	}
	
	//====================  // (double type) ==========================//

	/**
	 *    
	 * 
	 * @param matrix1 1
	 * @param matrix2 2
	 * @return 1 2 Ͽ   ȯѴ.
	 * @exception 1 2 ̰ ġ  ,   ϶.
	 */
	public static double[][] add(double[][] matrix1, double[][] matrix2) throws ImageGSException
	{
		return doubleAMD(matrix1, matrix2, 0);
	}

	/**
	 *    
	 * 
	 * @param matrix1 1
	 * @param matrix2 2
	 * @return 1 2    ȯѴ.
	 * @exception 1 2 ̰ ġ  ,   ϶.
	 */
	public static double[][] minus(double[][] matrix1, double[][] matrix2) throws ImageGSException
	{
		return doubleAMD(matrix1, matrix2, 1);
	}

	/**
	 *    
	 * 
	 * @param matrix1 1
	 * @param matrix2 2
	 * @return 1 2    ȯѴ.
	 * @exception 1 2 ̰ ġ  ,   ϶.
	 */
	public static double[][] div(double[][] matrix1, double[][] matrix2) throws ImageGSException
	{
		return doubleAMD(matrix1, matrix2, 2);
	}

	
	// , ,  ó.
	private static double[][] doubleAMD(double[][] matrix1, double[][] matrix2, int method) 
					throws ImageGSException
	{
		String msg_add = "Matrix.add()";
		String msg_minus = "Matrix.minus()";
		String msg_div = "Matrix.div()";
		
		double[][] retMatrix = null;
		int matrix1_rows;
		int matrix1_cols;
		int matrix2_rows;
		int matrix2_cols;

		// matrix1 matrix2 ϳ  
		if(matrix1 == null || matrix2 == null)
		{
			if(method == 0)
			{
				throw new ImageGSException(msg_add + " >> matrix1 or matrix2 is null!");
			}
			else if(method == 1)
			{
				throw new ImageGSException(msg_minus + " >> matrix1 or matrix2 is null!");
			}
			else if(method == 2)
			{
				throw new ImageGSException(msg_div + " >> matrix1 or matrix2 is null!");
			}	
		}
		
		//   rows, cols ̸ Ѵ.
		matrix1_rows = matrix1.length;	matrix1_cols = matrix1[0].length;
		matrix2_rows = matrix2.length;	matrix2_cols = matrix2[0].length;
		
		// 1 2 ũⰡ  ƾ Ѵ.
		if((matrix1_rows!= matrix2_rows) || (matrix1_cols!= matrix2_cols))
		{
			if(method == 0)
			{
				throw new ImageGSException(msg_add + " >> don't match!!! size of matrix1, matrix2");
			}
			else if(method == 1)
			{
				throw new ImageGSException(msg_minus + " >> don't match!!! size of matrix1, matrix2");
			}
			else if(method == 2)
			{
				throw new ImageGSException(msg_div + " >> don't match!!! size of matrix1, matrix2");
			}	
		}
		
		//    retMask ʱȭѴ.
		retMatrix = InitMaskBuf.DoubleInitMask(matrix1_rows, matrix1_cols);
	
		// .	
		for(int i=0; i<matrix1_rows; i++)
		{
			for(int j=0; j<matrix1_cols; j++)
			{
				if(method == 0)
				{
					retMatrix[i][j] = matrix1[i][j] + matrix2[i][j];		
				}				
				else if(method == 1)
				{
					retMatrix[i][j] = matrix1[i][j] - matrix2[i][j];		
				}	
				else if(method == 2)
				{
					retMatrix[i][j] = matrix1[i][j] / matrix2[i][j];	
				}				
			}	
		}
					
		return retMatrix;				
	}

	
	//====================   ==========================//
	
	/**
	 *    
	 * 
	 * @param matrix1 1
	 * @param matrix2 2
	 * @return 1 2 Ͽ   ȯѴ.
	 * @exception 1 (cols) 2 (rows) ̰ ġ  ,   ϶.
	 */
	public static short[][] multiply(short[][] matrix1, short[][] matrix2) throws ImageGSException
	{
		short[][] retMatrix = null;
		int matrix1_rows;
		int matrix1_cols;
		int matrix2_rows;
		int matrix2_cols;

		// matrix1 matrix2 ϳ  
		if(matrix1 == null || matrix2 == null)
			throw new ImageGSException("Matrix.multiply() >> matrix1 or matrix2 is null!");
		
		//   rows, cols ̸ Ѵ.
		matrix1_rows = matrix1.length;	matrix1_cols = matrix1[0].length;
		matrix2_rows = matrix2.length;	matrix2_cols = matrix2[0].length;
		
		//  Ŀ ϱ   ٷ 1 cols 2 rows ũⰡ ƾ Ѵ.
		if(matrix1_cols != matrix2_rows)
		{
			throw new ImageGSException("Matrix.multiply() >> don't match!!! matrix1's cols : " + 
										matrix1_cols + " and matrix2's rows " + matrix2_rows);
		}
		
		//    retMask ʱȭѴ.
		retMatrix = InitMaskBuf.ShortInitMask(matrix1_rows, matrix2_cols);
	
		// ...	
		for(int i=0; i<matrix1_rows; i++)
		{
			for(int j=0; j<matrix2_cols; j++)
			{
				for(int k=0; k<matrix1_cols; k++)
				{
					retMatrix[i][j] += matrix1[i][k] * matrix2[k][j];	
				}	
			}	
		}
					
		return retMatrix;
	}

	/**
	 *    
	 * 
	 * @param matrix1 1
	 * @param matrix2 2
	 * @return 1 2 Ͽ   ȯѴ.
	 * @exception 1 (cols) 2 (rows) ̰ ġ  ,   ϶.
	 */
	public static int[][] multiply(int[][] matrix1, int[][] matrix2) throws ImageGSException
	{
		int[][] retMatrix = null;
		int matrix1_rows;
		int matrix1_cols;
		int matrix2_rows;
		int matrix2_cols;

		// matrix1 matrix2 ϳ  
		if(matrix1 == null || matrix2 == null)
			throw new ImageGSException("Matrix.multiply() >> matrix1 or matrix2 is null!");
		
		//   rows, cols ̸ Ѵ.
		matrix1_rows = matrix1.length;	matrix1_cols = matrix1[0].length;
		matrix2_rows = matrix2.length;	matrix2_cols = matrix2[0].length;
		
		//  Ŀ ϱ   ٷ 1 cols 2 rows ũⰡ ƾ Ѵ.
		if(matrix1_cols != matrix2_rows)
		{
			throw new ImageGSException("Matrix.multiply() >> don't match!!! matrix1's cols : " + 
										matrix1_cols + " and matrix2's rows " + matrix2_rows);
		}
		
		//    retMask ʱȭѴ.
		retMatrix = InitMaskBuf.IntegerInitMask(matrix1_rows, matrix2_cols);
	
		// ...	
		for(int i=0; i<matrix1_rows; i++)
		{
			for(int j=0; j<matrix2_cols; j++)
			{
				for(int k=0; k<matrix1_cols; k++)
				{
					retMatrix[i][j] += matrix1[i][k] * matrix2[k][j];	
				}	
			}	
		}
					
		return retMatrix;
	}

	/**
	 *    
	 * 
	 * @param matrix1 1
	 * @param matrix2 2
	 * @return 1 2 Ͽ   ȯѴ.
	 * @exception 1 (cols) 2 (rows) ̰ ġ  ,   ϶.
	 */
	public static double[][] multiply(double[][] matrix1, double[][] matrix2) throws ImageGSException
	{
		double[][] retMatrix = null;
		int matrix1_rows;
		int matrix1_cols;
		int matrix2_rows;
		int matrix2_cols;

		// matrix1 matrix2 ϳ  
		if(matrix1 == null || matrix2 == null)
			throw new ImageGSException("Matrix.multiply() >> matrix1 or matrix2 is null!");
		
		//   rows, cols ̸ Ѵ.
		matrix1_rows = matrix1.length;	matrix1_cols = matrix1[0].length;
		matrix2_rows = matrix2.length;	matrix2_cols = matrix2[0].length;
		
		//  Ŀ ϱ   ٷ 1 cols 2 rows ũⰡ ƾ Ѵ.
		if(matrix1_cols != matrix2_rows)
		{
			throw new ImageGSException("Matrix.multiply() >> don't match!!! matrix1's cols : " + 
										matrix1_cols + " and matrix2's rows " + matrix2_rows);
		}
		
		//    retMask ʱȭѴ.
		retMatrix = InitMaskBuf.DoubleInitMask(matrix1_rows, matrix2_cols);
	
		// ...	
		for(int i=0; i<matrix1_rows; i++)
		{
			for(int j=0; j<matrix2_cols; j++)
			{
				for(int k=0; k<matrix1_cols; k++)
				{
					retMatrix[i][j] += matrix1[i][k] * matrix2[k][j];	
				}	
			}	
		}
					
		return retMatrix;
	}

	/**
	 *  ĳ ּҰ ´. 
	 * 
	 * @param matrix 
	 * @return ּҰ
	 * @exception  ϶.
	 */
	public static double getMinVal(double[][] matrix) throws ImageGSException
	{
		// matrix  
		if(matrix == null)
		{
			throw new ImageGSException("Matrix.getMinVal() >> matrix is null!");
		}
			
		int height = GetSizeIMG.getHeight( matrix );
		int width = GetSizeIMG.getWidth( matrix );

		double minVal = 10000000.0;
		
		for(int i=0; i<height; i++)
		{
			for(int j=0; j<width; j++)
			{
				if(matrix[i][j] < minVal ) minVal = matrix[i][j];	
			}
		}
		
		return minVal;
	}

	/**
	 *  ĳ ִ밪 ´. 
	 * 
	 * @param matrix 
	 * @return ּҰ
	 * @exception  ϶.
	 */
	public static double getMaxVal(double[][] matrix) throws ImageGSException
	{
		// matrix  
		if(matrix == null)
		{
			throw new ImageGSException("Matrix.getMinVal() >> matrix is null!");
		}
					
		int height = GetSizeIMG.getHeight( matrix );
		int width = GetSizeIMG.getWidth( matrix );

		double maxVal = -10000000.0;
		
		for(int i=0; i<height; i++)
		{
			for(int j=0; j<width; j++)
			{
				if(matrix[i][j] > maxVal ) maxVal = matrix[i][j];	
			}
		}
		
		return maxVal;
	}
	
	//====================   ==========================//
	
	/**
	 *   System.out  ѷش. 
	 * 
	 * @param matrix 
	 */
	public static void print(short[][] matrix)
	{
		int rows = matrix.length;
		int cols = matrix[0].length;
		
		for(int i=0; i<rows; i++)
		{
			System.out.print("|");
			for(int j=0; j<cols; j++)
			{
				System.out.print(" " + matrix[i][j]);
				if(j!=cols-1) System.out.print(","); 	
			}	
			
			System.out.println("| ");
		}	
	}

	/**
	 *   System.out  ѷش. 
	 * 
	 * @param matrix 
	 */
	public static void print(int[][] matrix)
	{
		int rows = matrix.length;
		int cols = matrix[0].length;
		
		for(int i=0; i<rows; i++)
		{
			System.out.print("|");
			for(int j=0; j<cols; j++)
			{
				System.out.print(" " + matrix[i][j]);
				if(j!=cols-1) System.out.print(","); 	
			}	
			
			System.out.println("| ");
		}	
	}

	/**
	 *   System.out  ѷش. 
	 * 
	 * @param matrix 
	 */
	public static void print(double[][] matrix)
	{
		int rows = matrix.length;
		int cols = matrix[0].length;
		
		for(int i=0; i<rows; i++)
		{
			System.out.print("|");
			for(int j=0; j<cols; j++)
			{
				System.out.print(" " + matrix[i][j]);
				if(j!=cols-1) System.out.print(","); 	
			}	
			
			System.out.println("| ");
		}	
	}
}
