/**
 * Class Name	: PaddedIMG
 * Description	:     ߰Ѵ.
 * Date 				: 2004/02/11
 * Author			: Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * History			: 2004/02/11 first created.
 */

package com.conv2.imageGS.Util;

import com.conv2.imageGS.ErrorMsg.ErrorMsg;
import com.conv2.imageGS.Exception.ImageGSException;

/**
 * Է    ߰Ͽ  ũ⸦ .<p>
 * 
 *   ļ (frequency domain) ϴ   <br>
 *  ũⰡ Ǿ ϹǷ,  Ŭ ϴ ̴.<br>
 * 
 * @author conv2@nvision.gsnu.ac.kr
 * @version 1.0.0
 */
public class PaddedIMG 
{
	private int height = 0;
	private int width = 0;
	private int zPaddedLength = 0;
	private short[][] orgImage = null;
	private short[][] zPaddedImage = null;
	
	public PaddedIMG( short[][] image ) throws ImageGSException
	{
		if( image == null)
		{
			throw new ImageGSException( this.getClass().getName()  +" >> " 
				+ ErrorMsg.ERRORUNKNOWNSIZEOFGRAYIMG );	
		}	
		
		orgImage = CopyIMGBuf.CopyShortGrayIMGBuf( image );
		height = GetSizeIMG.getHeight( image );
		width = GetSizeIMG.getWidth( image );		
	}

	/**
	 * Է  height ȯѴ.
	 * 
	 * @return height
	 */
	public int getHeight()
	{
		return height;
	}
	
	/**
	 * Է  width ȯѴ.
	 * 
	 * @return width
	 */
	public int getWidth()
	{
		return width;
	}
	
	/**
	 *   ߰  ũ⸦ ȯѴ.
	 */	
	public int getPaddedLength()
	{
		return zPaddedLength;
	}
	
	/**
	 *   ߰  ȯѴ.
	 */
	public short[][] getPaddedImage() throws ImageGSException
	{
		if( zPaddedImage == null)
		{
			throw new ImageGSException( this.getClass().getName()  +" >> " 
				+ ErrorMsg.ERRORUNKNOWNSIZEOFGRAYIMG );	
		}	
		
		return zPaddedImage;
	}

	/**
	 * Է    ߰ , Է  ũ⸸ŭ ȯѴ.
	 */	
	public short[][] getImage( short[][] paddedImage )
	{
		return getImage( paddedImage, this.height, this.width );
	}
	
	/**
	 * Է    ߰ , Է  ũ⸸ŭ ȯѴ.
	 */
	public short[][] getImage( short[][] paddedImage, int height, int width )
	{
		short[][] image = InitIMGBuf.ShortIMGBuf( height, width );
		
		for(int i=0; i<height; i++)
		{
			for(int j=0; j<width; j++)
			{
				image[i][j] = paddedImage[i][j];
			}
		}
		
		return image;
	}
	
	/**
	 *  ũ , ߰ ȭ  0̴.<p>
	 * 
	 * ) 112 x 123  ũ⸦    128 x 128 ũ . <p>
	 *  
	 * @return  ũ 
	 * @exception image ϶ 
	 */
	public short[][] addValue() throws ImageGSException
	{
		return addValue((short)0 );
	}

	/**
	 *  ũ , ߰ ȭ  value̴.<p>
	 * 
	 * ) 112 x 123  ũ⸦    128 x 128 ũ . <p>
	 *  
	 * @param value ߰ ȭҿ   
	 * @return  ũ 
	 * @exception image ϶ 
	 */	
	public short[][] addValue(short var ) throws ImageGSException
	{
		int i, j;

		if( var <0 || var > 255 )
		{
			throw new ImageGSException( PaddedIMG.class.getName()  +" >> " 
				+ ErrorMsg.ERRORDONOTTHEVALUERANGE + " (0~255)" ); 					
		}
		
		if(height >= width )
		{
			int result = 0;
			int tmp_height = height;
			int real_num = tmp_height;
			
			while(tmp_height >= 2)
			{
				tmp_height = tmp_height >> 1;
				result++;
			}
			
			if(real_num != (int)Math.pow(2,result))
			{
				zPaddedLength = (int)Math.pow(2,result+1);
			}
			else {
				zPaddedLength = height;
			}		
		}
		else if(height < width )
		{
			int result = 0;
			int tmp_width = width;
			int real_num = tmp_width;
			
			while(tmp_width >= 2)
			{
				tmp_width = tmp_width >> 1;
				result++;
			}
			
			if(real_num != (int)Math.pow(2,result))
			{
				zPaddedLength = (int)Math.pow(2,result+1);
			}
			else {
				zPaddedLength = width;
			}		
		}
		
		zPaddedImage = InitIMGBuf.ShortIMGBuf( zPaddedLength, zPaddedLength );
		
		for(i=0; i<height; i++)
		{
			for(j=0; j<width; j++)
			{
				zPaddedImage[i][j] = orgImage[i][j];
			}
		}
		
		return zPaddedImage;
	}
}
