/**
 * Class Name	: Quantization
 * Description	: Quantization
 * Date 				: 2003/05/24
 * Author			: Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * History			: 2003/05/24 first created.
 */

package com.conv2.imageGS.Util;

import com.conv2.imageGS.Exception.*;

/**
 * ȭ(Quantization) Ѵ.
 * 
 * @author Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * @version 1.0.0
 */
public class Quantization extends AbstractGS
{
	/**
	 *  : short type ϵ  ۸ ʱȭѴ.
	 * 
	 * @param    ShortGrayIMG      ϵ  GrayIMG 
	 */
	public Quantization(short[][] ShortGrayIMG)
	{
		super(ShortGrayIMG);
	}

	/**
	 *  : short type ϵ  ۸ ʱȭѴ.
	 * 
	 * @param    ShortGrayIMG      ϵ  GrayIMG 
	 * @param	height	ϵ  GrayIMG  
	 * @param	width	ϵ  GrayIMG  ʺ
	 */
	public Quantization(short[][] ShortGrayIMG, int height, int width) 
	{
		super(ShortGrayIMG, height, width);
	}
	
	/**
	 *  : double type ϵ  ۸ ʱȭѴ.
	 * 
	 * @param    DoubleGrayIMG      ϵ  GrayIMG 
	 */
	public Quantization(double[][] DoubleGrayIMG)
	{
		super(DoubleGrayIMG);
	}
	
	/**
	 *  : double type ϵ  ۸ ʱȭѴ.
	 * 
	 * @param    DoubleGrayIMG      ϵ  GrayIMG 
	 * @param	height	ϵ  GrayIMG  
	 * @param	width	ϵ  GrayIMG  ʺ
	 */
	public Quantization(double[][] DoubleGrayIMG, int height, int width)
	{
		super(DoubleGrayIMG, height, width);
	}

    /**
     * Quantization Operation.
     * 
     * @param	quantLevel	ȭ  (1~256)
     * @exception ImageGSException GrayIMG  , 
     */
	public void QuantizationOP(int quantLevel)  throws ImageGSException
	{
		int i,j,m;

		// Է  ۿ õ  ´.
		double[][] grayIMG = getOrgImageBuf();
		int height = getOrgImageBufHeight();
		int width = getOrgImageBufWidth();  
				
		if(quantLevel <=0) quantLevel = 1; 
		else if(quantLevel > 256) quantLevel = 256;

		int quantVar;
		int quantNextVar;
		int var;
		int standLevel = 256/quantLevel;
		
		double resultVar = 0.0;

		initImageBuf();
				
		for(i=0; i<height; i++)
		{
			for(j=0; j<width; j++)
			{
				var = (int)grayIMG[i][j];

				for(m=0; m<quantLevel; m++)
				{
					quantVar = standLevel * m;
					quantNextVar = standLevel * (m+1);
					
					if( var >= quantVar && var < quantNextVar)
					{
						resultVar = (double)( (256 / quantLevel) * m);
						setImageBuf(i, j, resultVar);
					}
				}
			}
		}		
		
		return;
	}


}

