/**
 * Class Name	: ReplaceIMGBuf
 * Description	: ش  ٸ  üѴ.
 * Date 				: 2003/01/17
 * Author			: Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * History			: 2003/01/17 first created.
 */

package com.conv2.imageGS.Util;

import com.conv2.imageGS.ErrorMsg.*;
import com.conv2.imageGS.Exception.*;

/**
 * ش  ۳ ش ȭҰ Ư  ٲ۴.
 * 
 * @author conv2@nvision.gsnu.ac.kr
 * @version 1.0.0
 */
public class ReplaceIMGBuf
{
	private ReplaceIMGBuf() {}
	
    /**
     * short Ÿ  ۳ ȭҰ constant ٲ۴. 
     * 
     * @param	Image 	  
     * @param	oldConstant	 ȭҰ
     * @param	newConstant	ٲ ȭҰ
     * @return    short type[][]   ȯ
     * @exception ImageGSException Image ϶
     */
	public static short [][] ReplaceShortGrayIMGBuf(short[][] Image, short oldConstant, short newConstant) throws  ImageGSException	
	{

		short [][] TargetGrayIMGBuf = null;
		int height;
		int width;

		if(Image == null)
		{
			throw new ImageGSException("ReplaceIMGBuf.ReplaceShortGrayIMGBuf() >> " 
				+ ErrorMsg.ERRORUNKNOWNSIZEOFGRAYIMG );	
		}	
				
		if(oldConstant < 0 || oldConstant > 255)
		{
			throw new ImageGSException("ReplaceIMGBuf.ReplaceShortGrayIMGBuf() >> "
				+ ErrorMsg.ERRORDONOTTHEVALUERANGE + " (0~255)" ); 					
		}
		
		if(newConstant < 0 || newConstant > 255)
		{
			throw new ImageGSException("ReplaceIMGBuf.ReplaceShortGrayIMGBuf() >>"
				+ ErrorMsg.ERRORDONOTTHEVALUERANGE + " (0~255)" ); 					
		}
				
		try
		{
			//height = GetSizeIMG.HeightFromGrayIMG(Image);
			//width = GetSizeIMG.WidthFromGrayIMG(Image);
			height = GetSizeIMG.getHeight(Image);
			width = GetSizeIMG.getWidth(Image);
			
			TargetGrayIMGBuf = InitMaskBuf.ShortInitMask(height, width);
			
			//replace
			for(int i=0; i<height; i++)
			{
				for(int j=0; j<width; j++)
				{
					if(Image[i][j] == oldConstant)
						TargetGrayIMGBuf[i][j] = newConstant;
					else 
						TargetGrayIMGBuf[i][j] = Image[i][j];
				}
			}
		}
		catch(ImageGSException e)
		{
			throw new ImageGSException("ReplaceIMGBuf.ReplaceShortGrayIMGBuf()  >> "
				+ e.getMessage() ); 			
			
		}
		return TargetGrayIMGBuf;
	}


    /**
     * integer Ÿ  ۳ ȭҰ constant ٲ۴. <p>
     * 
     * @param	Image 	  
     * @param	oldConstant	 ȭҰ
     * @param	newConstant	ٲ ȭҰ
     * @return    short type[][]   ȯ
     * @exception ImageGSException Image ϶
     */
	public static int [][] ReplaceIntegerGrayIMGBuf(int[][] Image, int oldConstant, int newConstant) throws  ImageGSException	
	{

		int [][] TargetGrayIMGBuf = null;
		int height;
		int width;

		if(Image == null)
		{
			throw new ImageGSException("ReplaceIMGBuf.ReplaceIntegerGrayIMGBuf() >> " 
				+ ErrorMsg.ERRORUNKNOWNSIZEOFGRAYIMG );	
		}	
				
		if(oldConstant < 0 || oldConstant > 255)
		{
			throw new ImageGSException("ReplaceIMGBuf.ReplaceIntegerGrayIMGBuf() >> "
				+ ErrorMsg.ERRORDONOTTHEVALUERANGE + " (0~255)" ); 					
		}
		
		if(newConstant < 0 || newConstant > 255)
		{
			throw new ImageGSException("ReplaceIMGBuf.ReplaceIntegerGrayIMGBuf() >>"
				+ ErrorMsg.ERRORDONOTTHEVALUERANGE + " (0~255)" ); 					
		}
				
		try
		{
			//height = GetSizeIMG.HeightFromGrayIMG(Image);
			//width = GetSizeIMG.WidthFromGrayIMG(Image);
			height = GetSizeIMG.getHeight(Image);
			width = GetSizeIMG.getWidth(Image);
			
			TargetGrayIMGBuf = InitMaskBuf.IntegerInitMask(height, width);
			
			//replace
			for(int i=0; i<height; i++)
			{
				for(int j=0; j<width; j++)
				{
					if(Image[i][j] == oldConstant)
						TargetGrayIMGBuf[i][j] = newConstant;
					else 
						TargetGrayIMGBuf[i][j] = Image[i][j];
				}
			}
		}
		catch(ImageGSException e)
		{
			throw new ImageGSException("ReplaceIMGBuf.ReplaceIntegerGrayIMGBuf()  >> "
				+ e.getMessage() ); 			
			
		}
		return TargetGrayIMGBuf;
	}

    /**
     * double Ÿ  ۳ ȭҰ constant ٲ۴. 
     * 
     * @param	Image 	  
     * @param	oldConstant	 ȭҰ
     * @param	newConstant	ٲ ȭҰ
     * @return    short type[][]   ȯ
     * @exception ImageGSException Image ϶
     */
	public static double [][] ReplaceDoubleGrayIMGBuf(double[][] Image, double oldConstant, double newConstant) throws ImageGSException	
	{

		double [][] TargetGrayIMGBuf = null;
		int height;
		int width;

		if(Image == null)
		{
			throw new ImageGSException("ReplaceIMGBuf.ReplaceDoubleGrayIMGBuf() >> " 
				+ ErrorMsg.ERRORUNKNOWNSIZEOFGRAYIMG );	
		}	
				
		if(oldConstant < 0.0 || oldConstant > 255.0)
		{
			throw new ImageGSException("ReplaceIMGBuf.ReplaceDoubleGrayIMGBuf() >> "
				+ ErrorMsg.ERRORDONOTTHEVALUERANGE + " (0~255)" ); 					
		}
		
		if(newConstant < 0.0 || newConstant > 255.0)
		{
			throw new ImageGSException("ReplaceIMGBuf.ReplaceDoubleGrayIMGBuf() >>"
				+ ErrorMsg.ERRORDONOTTHEVALUERANGE + " (0~255)" ); 					
		}
				
		try
		{
			//height = GetSizeIMG.HeightFromGrayIMG(Image);
			//width = GetSizeIMG.WidthFromGrayIMG(Image);
			height = GetSizeIMG.getHeight(Image);
			width = GetSizeIMG.getWidth(Image);
			
			TargetGrayIMGBuf = InitMaskBuf.DoubleInitMask(height, width);
			
			//replace
			for(int i=0; i<height; i++)
			{
				for(int j=0; j<width; j++)
				{
					if(Image[i][j] == oldConstant)
						TargetGrayIMGBuf[i][j] = newConstant;
					else 
						TargetGrayIMGBuf[i][j] = Image[i][j];
				}
			}
		}
		catch(ImageGSException e)
		{
			throw new ImageGSException("ReplaceIMGBuf.ReplaceShortGrayIMGBuf()  >> "
				+ e.getMessage() ); 			
			
		}
		
		return TargetGrayIMGBuf;
	}
}
