/**
 * Class Name	: SepConv2
 * Description	: и ȸ(separable convolution)  Ŭ
 * Date 				: 2003/08/04
 * Author			: Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * History			: 2003/08/04 first created.
 */

package com.conv2.imageGS.Util;

import com.conv2.imageGS.ErrorMsg.*;
import com.conv2.imageGS.Exception.*;

/**
 * Separable convolutionμ, ȸ  short[][] Ǵ double[][]  ǵش. <p>
 *  ȸ ˰ ׵θ  ʰ  ̴.<p>
 * 
 * @author conv2@nvision.gsnu.ac.kr
 * @version 1.0.0
 */
public class SepConv2
{
	private SepConv2() {}
	
	/**
	 * Convolution Operation for short type, mask is double type.
	 *
	 * @param	grayIMG	 GrayIMG  for short type
	 * @param	mask		ũ , double type
	 * @return    ȸ   for short type
	 * @exception ImageGSException 
	 */
	public static short [][] Conv2OP (short[][] grayIMG, double[][] mask) throws  ImageGSException
	{
		double[][] resultTmpIMG = (double[][])Conv2OP((Object)grayIMG, (Object)mask);
		
		short[][] resultIMG = TypeConv2GrayIMG.Double2ShortGrayIMG( resultTmpIMG );
		resultTmpIMG = null;
		
		return resultIMG;
	}

	/**
	 * Convolution Operation for integer type, mask is double type.
	 *
	 * @param	grayIMG	 GrayIMG  for integer type
	 * @param	mask		ũ , double type
	 * @return    ȸ   for integer type
	 * @exception ImageGSException 
	 */
	public static int [][] Conv2OP (int [][] grayIMG, double[][] mask) throws  ImageGSException
	{
		double[][] resultTmpIMG = (double[][])Conv2OP((Object)grayIMG, (Object)mask);
		
		int[][] resultIMG = TypeConv2GrayIMG.Double2IntegerGrayIMG( resultTmpIMG );
		resultTmpIMG = null;
		
		return resultIMG;
	}
	
	/**
	 * Convolution Operation for double type, mask is double type.
	 *
	 * @param	grayIMG	 GrayIMG  for double type
	 * @param	mask		ũ , double type
	 * @return    ȸ   for double type
	 * @exception ImageGSException
	 */
	public static double [][] Conv2OP (double[][] grayIMG, double[][] mask) throws  ImageGSException
	{
		double[][] resultIMG = (double[][])Conv2OP((Object)grayIMG, (Object)mask);
		return resultIMG;
	}
	
	private static Object Conv2OP(Object objGrayIMG, Object objMask) throws ImageGSException
	{
		/**
		 *    
		 */
		double[][] resultIMG = null; //  
		double[][] grayIMG = null;
		double[][] mask = null;
		
		int i = 0;
		int j = 0;
		int m = 0;
		int n = 0;
		double var = 0.0;

		// Object type  double Ÿ
		if(objGrayIMG instanceof double[][])
		{
			grayIMG = CopyIMGBuf.CopyDoubleGrayIMGBuf( (double [][])objGrayIMG );
		}
		else if( objGrayIMG instanceof short[][])
		{
			grayIMG = TypeConv2GrayIMG.Short2DoubleGrayIMG( (short[][])objGrayIMG);
		}
		
		// Object type  double Ÿ
		if(objMask instanceof double[][])
		{
			mask = CopyIMGBuf.CopyDoubleGrayIMGBuf( (double [][])objMask );
		}
		else if( objMask instanceof short[][])
		{
			mask = TypeConv2GrayIMG.Short2DoubleGrayIMG( (short[][])objMask);
		}
				
		// null   ܻȲ .
		if(grayIMG == null || mask == null) 
		{
			throw new ImageGSException("SepConv2.Conv2OP() : " 
				+ ErrorMsg.ERRORUNKNOWNSIZEOFGRAYIMGORMASK); 
		}
	
		// mask ̿ ʺ ˾Ƴ.
		int maskHeight  = mask.length;		
		int maskWidth = (mask[maskHeight-1]).length;
				
		// ش ϵ  , ʺ Ѵ.
		int height = GetSizeIMG.getHeight(grayIMG);
		int width = GetSizeIMG.getWidth(grayIMG);
				
		//   resultIMG  ޸ Ҵ
		resultIMG = InitIMGBuf.DoubleIMGBuf(height, width);
		
		// Step 1 : 1 ۷ ȯ
		double[] kernel = DimensionTrans.Double2SingleArray(mask, maskHeight, maskWidth);
		double[] grayIMGBuf = DimensionTrans.Double2SingleArray(grayIMG, height, width);
			
		// Step 2 : mask ̿ ʺ  1/2 .
		int maskHalfHeight = maskHeight / 2;
		int maskHalfWidth = maskWidth / 2;
		
		int tmpHeightPos; int tmpHeightOffset;
		int tmpWidthPos; int tmpWidthOffset;
		
		double tmpMaskValue;
		double sum = 0.0;
		
		// Step 3 : separable convolution
		for(i=0; i<height; i++)
		{
			for(j=0; j<width; j++)
			{
				
				for(m=-maskHalfHeight; m<=maskHalfHeight; m++)
				{
					tmpHeightPos = i + m;
					
					// ش grayIMG ȿ ٸ,
					if( tmpHeightPos >=0 && tmpHeightPos < height)
					{
						tmpHeightOffset = tmpHeightPos * width;
					}
					else 
					{
						tmpHeightOffset = i * width;
					}
					
					tmpWidthOffset = maskWidth * (m + maskHalfHeight) + maskHalfWidth;
					
					for(n=-maskHalfWidth; n<=maskHalfWidth; n++)
					{
						tmpMaskValue = kernel[tmpWidthOffset + n];
						
						if( tmpMaskValue != 0)
						{
							tmpWidthPos = j + n;
							
							if( !( tmpWidthPos >=0 && tmpWidthPos < width))
							{
								tmpWidthPos = j;
							}
							
							sum += tmpMaskValue * grayIMGBuf[tmpHeightOffset + tmpWidthPos];

						}
					}
				}

				// clamping
				resultIMG[i][j] = Clamping.ShortSaturation(sum);
				sum = 0.0; // ʱȭ 
								
			}
		}
		
		kernel = null;
		grayIMGBuf = null;
		 
		return (double[][])resultIMG;		
	}
}
