/**
 * Class Name	: StatisticsIMG
 * Description	: ش   ġ ȯ.
 * Date 				: 2002/09/10
 * Author			: Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * History			: 2002/09/10 first created.
 */

package com.conv2.imageGS.Util;

import com.conv2.imageGS.IMGFileIO.*;
import com.conv2.imageGS.ErrorMsg.*;
import com.conv2.imageGS.Exception.*;
import com.conv2.imageGS.HistogramProc.*;

/**
 * ش  Red, Green, Blue channel, Gray level  GrayIMGInfo entity ǵش. 
 * 
 * @author conv2@nvision.gsnu.ac.kr
 * @version 1.0.0
 */
public class StatisticsIMG
{
	/**
	 * հ
	 */	
	private double [] Mean = null;
	
	/**
	 *  ǥ
	 */
	private double [] StandardDev = null;

	/**
	 *  հ 
	 */
	private double [] Sum = null;
		
	/**
	 *  л갪
	 */
	private double [] Variance = null;
		
	/**
	 * HistogramInfo
	 */
	private HistogramInfo [] hinfo = null;
		
		
	/**
	 *  GrayIMGInfo
	 */
	private GrayIMGInfo [] ginfo = null;

	/**
	 * NameList
	 */
	private String [] NameList = null;
	
	/**
	 * Histogram
	 */	
	private Histogram hist = null;
	
	/**
	 * ʱȭ 
	 */		
	public StatisticsIMG() 
	{
		Mean = new double[4];

		StandardDev = new double[4];

		Sum = new double[4];

		Variance = new double[4];

		hinfo = new HistogramInfo[4];

		ginfo = new GrayIMGInfo[4];	

		// Name array & initialize & insert value
		NameList = new String[4];
		NameList[0] = "REDCHANNEL";
		NameList[1] = "GREENCHANNEL";
		NameList[2] = "BLUECHANNEL";
		NameList[3] = "GRAYLEVEL";
	}
	
	
	/**
	 * ش   м Ѵ. ⼭ ׷  ߰Ͽ ´. 
	 * 
	 * @param IMGFileName 	  ̸
	 */
	public void StatisticsIMGOP(String IMGFileName)	throws ImageGSException
	{
		try {
			this.StatisticsIMGOP(IMGFileName, 1);
		}
		catch (ImageGSException e)
		{
			throw new ImageGSException(e.getMessage());		
		} 
	}
	
    /**
     * ش    м Ѵ.
     * 
     * @param    IMGFileName      ̸
     * @param	Method : 0 (׷   ʰڴ.), Method : 1(׷  ߰Ͽ ڴ)
     * @exception ImageGSException
     */
 	public void StatisticsIMGOP(String IMGFileName, int Method) throws ImageGSException 
	{
		int i, j, count;
		int height;
		int width;
		short[][] RedChannel = null;
		short[][] GreenChannel = null;
		short[][] BlueChannel = null;
		short[][] GrayChannel = null;
								
		try {

			if(Method < 0 || Method > 1)
			{
				throw new ImageGSException(this.getClass().getName() + " >> " 
					+ ErrorMsg.ERRORMISSMETHOD );	
			}
			
			IMGFileIO img = new IMGFileIO();
			img.readFileName(IMGFileName);
			height = img.getHeight();
			width = img.getWidth();
			RedChannel = img.getRedChannel();
			GreenChannel = img.getGreenChannel();
			BlueChannel = img.getBlueChannel();
			GrayChannel = img.getGrayChannel();
												
			// Red channel, Green channel, Blue channel, Gray channel 
			//  óѴ.
		
			//   
			for(i=0; i<height; i++)
			{
				for(j=0; j<width; j++)
				{
					Sum[0] += RedChannel[i][j];
					Sum[1] += GreenChannel[i][j];
					Sum[2] += BlueChannel[i][j];
					Sum[3] += GrayChannel[i][j];
				}
			}
			
			// հ Ѵ.
			for(i=0; i<4; i++)
			{
				Mean[i] = Sum[i] / (double)(height * width);			
			}
			
			
			// л Ѵ.
			for(i=0; i<height; i++)
			{
				for(j=0; j<width; j++)
				{
					Variance[0] +=  Math.pow((RedChannel[i][j] - Mean[0]), 2.0);
					Variance[1] +=  Math.pow((GreenChannel[i][j] - Mean[1]), 2.0);
					Variance[2] +=  Math.pow((BlueChannel[i][j] - Mean[2]), 2.0);
					Variance[3] +=  Math.pow((GrayChannel[i][j] - Mean[3]), 2.0);
				}
			}	

			// ǥ & GrayIMGInfo entity class Ѵ.
			for(i=0; i<4; i++)
			{
				StandardDev[i] = Math.sqrt( Variance[i] / (double)(height * width));	
				
				// ̺κ ¿  .. hard coding.. :-(
				if(Method == 1)
				{
					if(i==0)				
						hist = new Histogram(RedChannel);
					else if(i==1)
						hist = new Histogram(GreenChannel);
					else if(i==3)
						hist = new Histogram(BlueChannel);
					else if(i==4)
						hist = new Histogram(GrayChannel);
						
					// GrayIMGInfo(...)ȿ hist.getHistogramInfo()   ־,
					//  ̱  Ϻη ߰ ̴.	
					
					hinfo[i] = hist.getHistogramInfo();
				
				} 
				
				ginfo[i] = new GrayIMGInfo(NameList[i],
														hinfo[i],
														Mean[i],
														StandardDev[i],
														height,
														width);
			}			
	
		} 
		catch (ImageGSException e)
		{
			throw new ImageGSException(e.getMessage());	
		}
	}

	/**
	 * Red, Green, Blue, Gray  ش.
	 * 
	 * @return GrayIMGInfo array
	 */
	public GrayIMGInfo[] getAllIMGInfo()
	{
		return ginfo;	
	}
	
	/**
	 * Name ġϴ GrayIMGInfo ´. <br>
	 * Name : REDCHANNEL, GREENCHANNEL, BLUECHANNEL, GRAYLEVEL <br>
	 * , ҹڸ  ʰ, ġϵ Ѵ. <br>
	 * ġ  ܻȲ .
	 * 
	 * @return GrayIMGInfo
	 * @exception ImageGSException Name ġ 
	 */
	public GrayIMGInfo getIMGInfo(String Name)	throws ImageGSException
	{
		int index = -1;
		
		// 빮ڷ ȯѴ.
		String upper_name = Name.toUpperCase();
	
		for(int i=0; i<ginfo.length; i++)
		{
			if(upper_name.compareTo(ginfo[i].getName()) == 0)
			{
				index = i;
				break;				
			}	
		}
		
		// ߰  
		if(index == -1) 
		{
			throw new ImageGSException(this.getClass().getName() + " >> " 
				+ ErrorMsg.ERRORNOTEQUALARGUMENT );
		}		
		else 
		{	
			return ginfo[index];
		}
	}
}

///////////////////////////////////////////////////////////////////////////////////////////////////////
// Example coding by conv2@nvision.gsnu.ac.kr
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*
 
	public static void test_stat(String Read_fname) throws ImageGSException, IOException 
	{
		try
		{
			StatisticsIMG st = new StatisticsIMG();
			st.StatisticsIMGOP(Read_fname);

			//GrayIMGInfo ginfo = st.getIMGInfo("GREENCHANNEL");
			//System.out.println("mean2 : " + ginfo.getMean());
			//System.out.println("std2 : " + ginfo.getStandardDev());
			//System.out.println("histogram max : " + ginfo.getHistogramInfo().getMax());

			GrayIMGInfo [] ginfo = st.getAllIMGInfo();
			for(int i = 0; i<ginfo.length; i++)
			{
				System.out.println("========= " + ginfo[i].getName() + " ============");
				System.out.println("mean2 : " + ginfo[i].getMean());
				System.out.println("std2 : " + ginfo[i].getStandardDev());
				System.out.println("histogram max : " + ginfo[i].getHistogramInfo().getMax());
			}
		}
		catch (ImageGSException e)
		{
			throw new ImageGSException(e.getMessage());
		}
		return;
	}	
	
 

========= REDCHANNEL ============
mean2 : 133.84177838577293
std2 : 54.05385873777509
histogram max : 179
========= GREENCHANNEL ============
mean2 : 84.50549931600547
std2 : 38.27189658552163
histogram max : 42
========= BLUECHANNEL ============
mean2 : 73.59091655266758
std2 : 33.26815042462731
histogram max : 42
========= GRAYLEVEL ============
mean2 : 97.52705882352942
std2 : 41.416223926685745
histogram max : 71	

*/	
/////////////////////////////////////////////////////////////////////////////////////////////////////////