/**
 * Class Name	: StringUtil
 * Description	: String õ ƿƼ Ŭ
 * Date 				: 2003/01/09
 * Author			: Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * History			: 2002/01/06 first created.
 */

package com.conv2.imageGS.Util;

/**
 * String  ƿƼ ޼ҵ带  Ŭ .
 *  
 * @author Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * @version 1.0.0
 */
public class StringUtil
{
	private StringUtil() {}
	
	/**
	 * ڿ delim  ūóѴ.
	 * 
	 * @param	str	ش ڿ
	 * @param	delim	ĺ
	 * @return ū 迭
	 */
	public static String[] split(String str, String delim)
	{
		return Tokenizer.tokenize(str, delim, false);
	}
	
	/**
	 * ڿ ģ.
	 * 
	 * @param	obj	ڿ 迭
	 * @param	delim	ĺ
	 * @return  ڿ
	 */
	public static String concat(Object obj[], String delim)
	{
		StringBuffer sb = new StringBuffer();
		
		if(obj != null)
		{
			for(int i=0; i<obj.length-1; i++)
			{
				sb.append(obj[i]).append(delim);	
			}
			sb.append(obj[obj.length-1]);
		}
		else 
		{
			sb.append("");	
		}
		
		return sb.toString();	
	}

	/**
	 * ڿ ģ.
	 * 
	 * @param	obj	ڿ 迭
	 * @return  ڿ
	 */
	public static String concat(Object obj[])
	{
		return concat(obj, "");
	}
	
		
	/**
	 *   Ѵ. 
	 * 
	 * @param str	ڿ
	 * @return    ڿ
	 */
	public static String ltrim(String str)
	{
		int count = 0;
		int str_length = str.length();
		
		for(int i=0; i<str_length; i++)
		{
			//   .
			if(str.charAt(i) != ' ') 
			{
				break;		
			}
			count++;	
		}
		
		return str.substring(count, str_length);	
	}

	/**
	 *   Ѵ. 
	 * 
	 * @param str	ڿ
	 * @return    ڿ
	 */
	public static String rtrim(String str)
	{
		int count = 0;
		int str_length = str.length();
				
		for(int i=str_length-1; i>=0; i--)
		{
			//   .
			if(str.charAt(i) != ' ') 
			{
				break;		
			}
			count++;	
		}
		
		return str.substring(0, str_length - count);	
	}	

	/**
	 *   Ѵ. 
	 * 
	 * @param str	ڿ
	 * @return   ڿ
	 */
	public static String trim(String str)
	{
		StringBuffer sb = new StringBuffer();
		
		int str_length = str.length();
		
		for(int i=0; i<str_length; i++)
		{
			//  ƴ ͸ append Ѵ.
			if(str.charAt(i) != ' ') sb.append(str.charAt(i));	
		}
		
		return sb.toString();	
	}	

	/**
	 * Ư ڸ ڿ ü(replace) Ѵ.
	 * 
	 * @param str	ڿ
	 * @param oldChar	ü 
	 * @param newChar	ü 
	 * @return ü ڿ ȯѴ.
	 */
	public static String replaceCharAll(String str, char oldChar, char newChar)
	{
		StringBuffer sb = new StringBuffer();
		int str_length = str.length();
				
		if(oldChar != newChar)
		{
			for(int i=0; i<str_length; i++)
			{
				sb.append( (str.charAt(i) == oldChar) ? newChar : str.charAt(i) ); 
				//if(str.charAt(i) == oldChar) sb.append(newChar);
				//else sb.append(str.charAt(i));	
			}
		}
		else 
		{
			sb.append(str);		
		}
		
		return sb.toString();
		
	} 

	/**
	 * ڿ ó Ÿ ڸ Ư ڷ ü(replace) Ѵ. 
	 * 
	 * @param str	ڿ
	 * @param oldChar	ü 
	 * @param newChar	ü 
	 * @return ü ڿ ȯѴ.		
	 */
	public static String replaceFirstChar(String str, char oldChar, char newChar)
	{
		StringBuffer sb = new StringBuffer();
		int str_length = str.length();
		boolean first = false;
				
		if(oldChar != newChar)
		{
			for(int i=0; i<str_length; i++)
			{
				if(str.charAt(i) == oldChar && first == false) 
				{
					sb.append(newChar);
					first = true;
				}
				else sb.append(str.charAt(i));	
			}
		}
		else 
		{
			sb.append(str);		
		}
		
		return sb.toString();
	} 

	/**
	 * ڿ ó Ÿ ڸ Ư ڿ ü(replace) Ѵ. 
	 * 
	 * @param str	ڿ
	 * @param oldStr	ü ڿ
	 * @param newStr	ü ڿ
	 * @return ü ڿ ȯѴ. 	
	 */
	public static String replaceFirstStr(String str, String oldStr, String newStr)
	{
		StringBuffer sb = new StringBuffer();
			
		if(oldStr == null || newStr == null)
		{
			sb.append(str);
		}
		else 
		{
			int first_index = str.indexOf(oldStr);
			sb.append(str.substring(0, first_index));
			sb.append(newStr);
			sb.append(str.substring(first_index + oldStr.length()));
		}
		
		return sb.toString();
	} 
	
	/**
	 * Ư ڿ ڿ ü(replace) Ѵ. 
	 * 
	 * @param str	ڿ
	 * @param oldStr	ü ڿ
	 * @param newStr	ü ڿ
	 * @return ü ڿ ȯѴ. 	
	 */
	public static String replaceStrAll(String str, String oldStr, String newStr)
	{
		StringBuffer sb = new StringBuffer();
		String str_tmp = str;

		if(oldStr == null || newStr == null)
		{
			sb.append(str);
		}
		else 
		{
			int index = 0;
			String back_str;
			while(true)
			{
				sb.delete(0, sb.length());

				index = str_tmp.indexOf(oldStr);
				if(index == -1) break;

				back_str = str_tmp.substring(index + oldStr.length());	
				sb.append(str_tmp.substring(0, index));
				sb.append(newStr);
			
				str_tmp = sb.toString() + back_str; 	
			}
		}
		
		return str_tmp;
	} 

	/**
	 * Ư ڸ ڿ Ѵ.
	 * 
	 * @param str	ڿ
	 * @param delChar	 
	 * @return ŵ ڿ ȯѴ.
	 */
	public static String deleteCharAll(String str, char delChar)
	{
		StringBuffer sb = new StringBuffer();
		int str_length = str.length();
				
		if(delChar != '\0')
		{
			for(int i=0; i<str_length; i++)
			{
				if(str.charAt(i) != delChar) sb.append(str.charAt(i));
			}
		}
		else 
		{
			sb.append(str);		
		}
		
		return sb.toString();
	} 

	/**
	 * Ư ڿ ڿ  Ѵ. 
	 * 
	 * @param str	ڿ
	 * @param delStr	 ڿ
	 * @return ŵ ڿ ȯѴ. 	
	 */
	public static String deleteStrAll(String str, String delStr)
	{
		StringBuffer sb = new StringBuffer();
		String str_tmp = str;

		if(delStr == null)
		{
			sb.append(str);
		}
		else 
		{
			int index = 0;
			String back_str;
			while(true)
			{
				sb.delete(0, sb.length());

				index = str_tmp.indexOf(delStr);
				if(index == -1) break;

				back_str = str_tmp.substring(index + delStr.length());	
				sb.append(str_tmp.substring(0, index));
				str_tmp = sb.toString() + back_str; 	
			}
		}
		
		return str_tmp;
	} 

	/**
	 * ڿ  Ư ڿ ϴ ȮѴ.
	 * 
	 * @param str	ڿ
	 * @param matchStr ã ڿ
	 * @return ϸ true, ׷  false ȯѴ.
	 */
	public static boolean matchStr(String str, String matchStr)
	{
		return str.indexOf(matchStr) != -1 ? true : false;	
	}

	/**
	 * ڿ  Ư ڿ ϴ ȮѴ.
	 * 
	 * @param str	ڿ
	 * @param matchStr ã ڿ 迭 
	 * @return  Ѱ ϸ true, ׷  false ȯѴ.
	 */
	public static boolean matchStr(String str, String[] matchStr)
	{
		boolean flag = false;

		if(matchStr == null) return false;
		else
		{
			for(int i=0; i<matchStr.length; i++)
			{
				 if(str.indexOf(matchStr[i]) != -1) 
				 {
				 	flag = true;
				 	break;
				 }
			}
		}
		
		return flag == true ? true : false;	
	}
	
	/**
	 * ڿ  Ư ڰ ϴ ȮѴ.
	 * 
	 * @param str	ڿ
	 * @param matchChar ã 
	 * @return ϸ true, ׷  false ȯѴ.
	 */
	public static boolean matchChar(String str, char matchChar)
	{
		return str.indexOf(matchChar) != -1 ? true : false;	
	}	
}
