/**
 * Class Name	: Unicode
 * Description	: Unicode encoding/decoding Ŭ
 * Date 				: 2003/11/19
 * Author			: Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * History			: 2003/11/19 first created.
 */

package com.conv2.imageGS.Util;

import com.conv2.imageGS.Exception.*;

/**
 * unicode encoding / decoding class.
 *  
 * @author Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * @author choongsun_cho ( cho@changjo.co.kr )
 * @version 1.0.0
 */
public class Unicode 
{

	private Unicode() {}
	
	/**
	 * ش ڿ ڵ Ѵ.
	 * 
	 * @param data  ڵ ڿ
	 * @return ڵ ڿ ȯ
	 */
	public static String encoding( String str ) throws ImageGSException
	{
		int i;

		StringBuffer unicodeStr = new StringBuffer();
		String tmpStr = null;
		
		// str null Ǵ   ܻȲ .
		if( str == null ) 
		{
			throw new ImageGSException("Unicoder.encoding() >> argument is null!");
		}
		else if( str.length() <= 0)
		{
			throw new ImageGSException("Unicoder.encoding() >> argument is blank string!!");
		}

		for(i=0; i<str.length(); i++)
		{
			tmpStr = Integer.toHexString( str.charAt(i) );
			unicodeStr.append( "\\u" + (tmpStr.length()==4 ? tmpStr : "00" + tmpStr ) );
		}

		return unicodeStr.toString();
	}

	/**
	 * ڵ ڿ ڵ Ѵ.
	 * 
	 * @param data  ڵ ڿ
	 * @return  ڵ ڿ ȯ
	 */
	public static String decoding( String uniStr ) throws ImageGSException
	{
		int i;
		StringBuffer str = new StringBuffer();

		// uniStr null Ǵ   ܻȲ .
		if( uniStr == null ) 
		{
			throw new ImageGSException("Unicoder.decoding() >> argument is null!");
		}
		else if( uniStr.length() <= 0)
		{
			throw new ImageGSException("Unicoder.decoding() >> argument is blank string!!");
		}

		for(i=uniStr.indexOf("\\u"); i>-1 ; i=uniStr.indexOf("\\u") )
		{
			str.append( uniStr.substring( 0, i ) );
			str.append( String.valueOf( (char)Integer.parseInt( uniStr.substring( i + 2, i + 6 ) ,16) ) );
			uniStr = uniStr.substring( i +6);
		}
		
		str.append( uniStr );

		return str.toString();
	}
}