/**
 * Class Name	: Zip
 * Description	: zip   Ŭ
 * Date 				: 2002/12/29
 * Author			: Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * History			: 2002/12/29 first created.
 */

package com.conv2.imageGS.Util.Zip;

import java.io.*;
import java.util.zip.*;
import java.util.*;

import com.conv2.imageGS.Util.*;
import com.conv2.imageGS.ErrorMsg.*;
import com.conv2.imageGS.Exception.*;

/**
 * ش zip    Ѵ. <p>
 * 
 *  ó : http://java.freehosting.co.kr/java/messages/368.html <br>
 *  :  <p>
 * 
 *  zip  Ʈ ٶ   Ͽ.<p>
 *
 * imageGS API Zip Ű   ⿣  ̳, <br>
 * ó õ Ʈũ ȯ濡 ȿ   ǹǷ ߰Ͽ. <p>
 * 
 *   
 * @author , Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * @version 1.0.0
 */
public class UnZip
{
	private boolean isListing = false;
	private String zipFile = null;
	private String targetPath = null;
	private final String onlyListing = "conv2 love image processing ^.^;;";
	private File zipfile = null;

	/**
	 * , targetPath   Կ Ѵ. 
	 * 
	 * @param zipFile 	 Ǯ zip ϸ ( θ  Ѵ!)
	 * @param targetPath  Ǯ 丮 ( θ  Ѵ!)
	 * @exception ImageGSException zipFile   
	 */	
	public UnZip(String zipFile, String targetPath) throws ImageGSException
	{
		init(zipFile, targetPath, false);	
	}	

	/**
	 * , ش zipFile      isListing true Ѵ.
	 * 
	 * @param zipFile 	 Ǯ zip ϸ ( θ  Ѵ!)
	 * @param isListing     (true/false)
	 * @exception ImageGSException zipFile   
	 */	
	public UnZip(String zipFile, boolean isListing) throws ImageGSException
	{
		init(zipFile, onlyListing, isListing);
	}

	/**
	 * , targetPath   Կ Ѵ. 
	 * ش zipFile      isListing true Ѵ.<p>
	 * 
	 * ࿡ true Ǿ ,    System.out    ,  Կ Ѵ. <p>
	 *  
	 * @param zipFile 	 Ǯ zip ϸ ( θ  Ѵ!)
	 * @param targetPath  Ǯ 丮 ( θ  Ѵ!)
	 * @param isListing     (true/false)
	 * @exception ImageGSException zipFile   
	 */	
	public UnZip(String zipFile, String targetPath, boolean isListing) throws ImageGSException
	{
		init(zipFile, targetPath, isListing);	
	}
	
	private void init(String zipFile, String targetPath, boolean isListing) throws ImageGSException
	{
		this.isListing = isListing;
		
		zipfile = new File(zipFile);
	
		if(!zipfile.exists())
		{
			throw new ImageGSException(this.getClass().getName() + " >> " 
															+ ErrorMsg.ERRORTHISFILEISNOTEXIST + " (" + zipFile + ")");	
		}
		
		this.targetPath = targetPath;
			
	}

	/**
	 *   Ѵ.
	 * 
	 * @exception ImageGSException   丮 ̹   
	 */	
	public void decompressZip() throws ImageGSException
	{
		try
		{
			// ڰ list() Ϸ ߴµ, ࿡ decompressZip() ȣ ߴٸ,
			//  Ȳ .
			if(targetPath.equals(onlyListing))
			{
				throw new ImageGSException(this.getClass().getName() + " >> list()? check constructor!");		
			}

			// isListing ɼ Ȱȭ Ǿ   ش.
			if(isListing)
				this.list();
				
			ZipInputStream zis = new ZipInputStream( new FileInputStream(zipfile) );
			
			ZipEntry entry = null;
			File entryFile = null;
			File parent = null;
			FileOutputStream fos = null;
			
			// targetPath   Ѵ.
			File targetPath_fp = new File(targetPath);
			if(!targetPath_fp.exists()) targetPath_fp.mkdirs();
			
			//  Ǯ
			while((entry = zis.getNextEntry()) != null)
			{
				entryFile = new File( targetPath + File.separator + entry.getName().replace('/', File.separatorChar));
				
				if(entry.isDirectory())
				{
					if(!entryFile.exists())
					{
						entryFile.mkdirs();	
					}	
					continue;
				}
				
				if(entryFile.getParent() != null)
				{
					parent = new File(entryFile.getParent());
					if(!parent.exists())
					{
						parent.mkdirs();
					}	
				}
				
				if(entry.getMethod() == ZipEntry.STORED) {}
				else if(entry.getMethod() == ZipEntry.DEFLATED) {}
				else 
				{
					// ˼    Ϸ    Ұ   Ȳ .
					throw new ImageGSException(this.getClass().getName() + " >> unknown compression method!");
				}
				
				if(entryFile.exists())
				{
					throw new ImageGSException(this.getClass().getName() + " >> " 
																	+ ErrorMsg.ERRORTHISFILEISEXIST + " (" + entryFile.getPath() + ")");	
					
				}
				
				fos = new FileOutputStream(entryFile);
				
				byte buf[] = new byte[1024];
				for(int cnt; (cnt = zis.read(buf)) != -1; )
				{
					fos.write(buf, 0, cnt);
				}									
				fos.close();	
			}
			
			fos = null;
			entry = null;
			entryFile = null;
			parent = null;
			zis.close();
			zipfile = null;
		}
		catch(IOException e) 
		{
			throw new ImageGSException(this.getClass().getName() + " >> " + e.getMessage());	
		}		
	}

	/**
	 * ش  zipFile   Ʈ ũ, ũ, ¥, ϸ  ش.
	 * 
	 * @exception ش zipFile    
	 */
	public void list() throws ImageGSException
	{
		if(isListing == false) return;	

		try
		{
			ZipInputStream zis_list = new ZipInputStream( new FileInputStream(zipfile) );
			
			ZipEntry entry = null;
			
			PrintfFormat title = new PrintfFormat("%10s %4s %10s %4s %-19s %s");
			String title_tmp[] = {"size","----", "comp size","----","     date/time", "filename"};
			
			// title  ֱ
			System.out.println("=============================================================================================");
			System.out.println(title.sprintf(title_tmp));
			System.out.println("=============================================================================================");

			//   Ʈ ش.
			PrintfFormat format = new PrintfFormat("%10s %4s %10s %4s %-19s %s");
			String[] tmp = new String[6];
			
			while( (entry = zis_list.getNextEntry()) != null)
			{
				zis_list.closeEntry();
				tmp[0] = String.valueOf(entry.getSize());
				tmp[1] = "byte";
				tmp[2] = String.valueOf(entry.getCompressedSize());
				tmp[3] = "byte";
				tmp[4] = SystemDate.dateToString( new Date(entry.getTime()), "yyyy-MM-dd HH:mm:ss");	
				tmp[5] = entry.getName();
				System.out.println(format.sprintf(tmp));
			}			 

			System.out.println("=============================================================================================\n");
			
			entry = null;
			zis_list.close();
			zipfile = null;
		}
		catch(IOException e)
		{
			throw new ImageGSException(this.getClass().getName() + " >> " + e.getMessage());	
		}	
	}
}
