------------------------------------------------------------------------------------
--
-- CensusPlus customized by Cooper Sellers(warcraftrealms.com)
-- CensusPlus-kr customized by dsh(wowcensus.dnip.net)
--
------------------------------------------------------------------------------------

g_CensusPlusLocale = "KR";							--  한국 서버만 조사. 

----------------------------------------------------------------------------------
--
-- Constants
-- 
---------------------------------------------------------------------------------
local CensusKr_Rev = "$Rev: 489 $";
local _, _, CensusKr_RevNo = string.find(CensusKr_Rev, "(%d+)");
local CensusPlus_VERSION = "KR r" .. CensusKr_RevNo; 				-- version
local CensusKr_DataVersion = 3;                                -- data version
local CensusPlus_MAXBARHEIGHT = 128;			-- Length of blue bars
local CensusPlus_NUMGUILDBUTTONS = 10;			-- How many guild buttons are on the UI?
local MAX_CHARACTER_LEVEL = 70;					-- Maximum level a PC can attain
local MAX_WHO_RESULTS = 49;						-- Maximum number of who results the server will return
CensusPlus_GUILDBUTTONSIZEY = 16;
local CensusPlus_UPDATEDELAY = 5;				-- Delay time between /who messages
local CP_MAX_TIMES = 50;

----------------------------------------------------------------------------------
--
-- Print a string to the chat frame
--	msg - message to print
-- 
---------------------------------------------------------------------------------
function CensusKr_Print(msg)
    if (DEFAULT_CHAT_FRAME) then
        DEFAULT_CHAT_FRAME:AddMessage("Census+: " .. msg, 1.0, 1.0, 0.5);
    end
end

----------------------------------------------------------------------------------
--
-- Global scope variables
-- 
---------------------------------------------------------------------------------
CensusPlus_Database = {};							-- Database of all CensusPlus results

----------------------------------------------------------------------------------
--
-- File scope variables
-- 
---------------------------------------------------------------------------------
local g_CensusPlusInitialized;						-- Is CensusPlus initialized?
local g_JobQueue = {};							-- The queue of pending jobs
local g_CurrentJob = {};						-- Current job being executed
g_IsCensusPlusInProgress = false;			-- Is a CensusPlus in progress?
local g_CensusPlusPaused = false;               -- Is CensusPlus in progress paused?
local g_CensusPlusManuallyPaused = false;       -- Is CensusPlus in progress manually paused?
local g_WhoAutoClose = 0;                       -- AutoClose who window?

local g_NumNewCharacters = 0;					-- How many new characters found this CensusPlus
local g_NumUpdatedCharacters = 0;				-- How many characters were updated during this CensusPlus

local g_MobXPByLevel = {};						-- XP earned for killing
local g_CharacterXPByLevel = {};				-- XP required to advance through the given level
local g_TotalCharacterXPPerLevel = {};			-- Total XP required to attain the given level

local g_Guilds = {};							-- All known guild

local g_TotalCharacterXP = 0;					-- Total character XP for currently selected search
local g_TotalCount = 0;							-- Total number of characters which meet search criteria
local g_RaceCount = {};							-- Totals for each race given search criteria
local g_ClassCount = {};						-- Totals for each class given search criteria
local g_LevelCount = {};						-- Totals for each level given search criteria

local g_GuildSelected = 0;						-- Search criteria: Currently selected guild, 0 indicates none
local g_RaceSelected = 0;						-- Search criteria: Currently selected race, 0 indicates none
local g_ClassSelected = 0;						-- Search criteria: Currently selected class, 0 indicates none
local g_LevelSelected = 0;

local g_LastOnUpdateTime = 0;					-- Last time OnUpdate was called
local g_WaitingForWhoUpdate = false;			-- Are we waiting for a who update event?

local g_WhoAttempts = 0;                        -- Counter for detecting stuck who results
local g_MiniOnStart = 1;                        -- Flag to have the mini-censusP displayed on startup

local g_CompleteCensusStarted = false;          -- Flag for counter
local g_TakeHour = 0;                           -- Our timing hour 
local g_TimeDatabase = {};                      -- Time database
local g_ResetHour = true;                       -- Rest hour
local g_VariablesLoaded = false;                -- flag to tell us if vars are loaded
local g_FirstRun = true;
local g_LastCensusRun = time() - 1500;			--  timer used if auto census is turned on

local g_Pre_FriendsFrameOnHideOverride = nil;		--  override for friend's frame to stop the close window sound
local g_Pre_FriendsFrameOnShowOverride = nil;		--  override for friend's frame to stop the close window sound
local g_Pre_WhoList_UpdateOverride = nil;		--  override for friend's frame to stop the close window sound
local g_Pre_WhoHandler = nil;						--  override for submiting a who
local g_Pre_FriendsFrame_Update = nil;
local g_CurrentlyInBG = false;

g_RaceClassList = { };						-- Used to pick the right icon
g_RaceClassList[CENSUSPlus_DRUID]		= 10;
g_RaceClassList[CENSUSPlus_HUNTER]		= 11;
g_RaceClassList[CENSUSPlus_MAGE]		= 12;
g_RaceClassList[CENSUSPlus_PRIEST]		= 13;
g_RaceClassList[CENSUSPlus_ROGUE]		= 14;
g_RaceClassList[CENSUSPlus_WARLOCK]	    = 15;
g_RaceClassList[CENSUSPlus_WARRIOR]	    = 16;
g_RaceClassList[CENSUSPlus_SHAMAN]		= 17;
g_RaceClassList[CENSUSPlus_PALADIN]	    = 18;

g_RaceClassList[CENSUSPlus_DWARF]		= 20;
g_RaceClassList[CENSUSPlus_GNOME]		= 21;
g_RaceClassList[CENSUSPlus_HUMAN]		= 22;
g_RaceClassList[CENSUSPlus_NIGHTELF]	= 23;
g_RaceClassList[CENSUSPlus_ORC]		    = 24;
g_RaceClassList[CENSUSPlus_TAUREN]		= 25;
g_RaceClassList[CENSUSPlus_TROLL]		= 26;
g_RaceClassList[CENSUSPlus_UNDEAD]		= 27;
g_RaceClassList[CENSUSPlus_DRAENEI]		= 28;
g_RaceClassList[CENSUSPlus_BLOODELF]		= 29;

local g_TimeDatabase = {};                      -- Time database
g_TimeDatabase[CENSUSPlus_DRUID]		= 0;
g_TimeDatabase[CENSUSPlus_HUNTER]		= 0;
g_TimeDatabase[CENSUSPlus_MAGE]			= 0;
g_TimeDatabase[CENSUSPlus_PRIEST]		= 0;
g_TimeDatabase[CENSUSPlus_ROGUE]		= 0;
g_TimeDatabase[CENSUSPlus_WARLOCK]	    = 0;
g_TimeDatabase[CENSUSPlus_WARRIOR]	    = 0;
g_TimeDatabase[CENSUSPlus_SHAMAN]		= 0;
g_TimeDatabase[CENSUSPlus_PALADIN]	    = 0;
g_TimeDatabase["전쟁노래 협곡"]			= 0;
g_TimeDatabase["알터랙 계곡"]		= 0;
g_TimeDatabase["아라시 분지"]			= 0;
g_TimeDatabase[CENSUSPlus_DWARF]	= 0;
g_TimeDatabase[CENSUSPlus_GNOME]	= 0;
g_TimeDatabase[CENSUSPlus_HUMAN]	= 0;
g_TimeDatabase[CENSUSPlus_NIGHTELF]	= 0;
g_TimeDatabase[CENSUSPlus_ORC]		= 0;
g_TimeDatabase[CENSUSPlus_TAUREN]	= 0;
g_TimeDatabase[CENSUSPlus_TROLL]		= 0;
g_TimeDatabase[CENSUSPlus_UNDEAD]	= 0;
g_TimeDatabase[CENSUSPlus_DRAENEI]	= 0;
g_TimeDatabase[CENSUSPlus_BLOODELF]	= 0;


local g_FactionCheck = {};

g_FactionCheck[CENSUSPlus_ORC]		= CENSUSPlus_HORDE;
g_FactionCheck[CENSUSPlus_TAUREN]	= CENSUSPlus_HORDE;
g_FactionCheck[CENSUSPlus_TROLL]	= CENSUSPlus_HORDE;
g_FactionCheck[CENSUSPlus_UNDEAD]	= CENSUSPlus_HORDE;
g_FactionCheck[CENSUSPlus_BLOODELF]	= CENSUSPlus_HORDE;

g_FactionCheck[CENSUSPlus_DWARF]	= CENSUSPlus_ALLIANCE;
g_FactionCheck[CENSUSPlus_GNOME]	= CENSUSPlus_ALLIANCE;
g_FactionCheck[CENSUSPlus_HUMAN]	= CENSUSPlus_ALLIANCE;
g_FactionCheck[CENSUSPlus_NIGHTELF]	= CENSUSPlus_ALLIANCE;
g_FactionCheck[CENSUSPlus_DRAENEI]	= CENSUSPlus_ALLIANCE;

local g_TimeStamp = nil;
local g_ProcessedZone = nil;
local g_ProcessZoneCount = 0;
local g_TimeKey = nil;

-----------------------------------------------------------------------------------
--
-- Insert a job at the end of the job queue
--
-----------------------------------------------------------------------------------
local function InsertJobIntoQueue(job)
	table.insert(g_JobQueue, job);
end

-----------------------------------------------------------------------------------
--
-- Initialize the tables of constants for XP calculations
--
-----------------------------------------------------------------------------------
local function InitConstantTables()
	--
	-- XP earned for killing
	--
	for i = 1, MAX_CHARACTER_LEVEL, 1 do
		g_MobXPByLevel[i] = (i * 5) + 45;
	end
	
	--
	-- XP required to advance through the given level
	--
	for i = 1, MAX_CHARACTER_LEVEL, 1 do
		g_CharacterXPByLevel[i] = ((8 * i * g_MobXPByLevel[i]) / 100) * 100;
	end

	--
	-- Total XP required to attain the given level
	--
	local totalCharacterXP = 0;
	for i = 1, MAX_CHARACTER_LEVEL, 1 do
		g_TotalCharacterXPPerLevel[i] = totalCharacterXP;
		totalCharacterXP = totalCharacterXP + g_CharacterXPByLevel[i];
	end
end

-----------------------------------------------------------------------------------
--
-- Return a table of races for the input faction
--
-----------------------------------------------------------------------------------
local function CensusPlus_GetFactionRaces(faction)
	local ret = {};
	if (faction == CENSUSPlus_HORDE) then
		ret = {CENSUSPlus_ORC, CENSUSPlus_TAUREN, CENSUSPlus_TROLL, CENSUSPlus_UNDEAD, CENSUSPlus_BLOODELF};
	elseif (faction == CENSUSPlus_ALLIANCE) then
		ret = {CENSUSPlus_DWARF, CENSUSPlus_GNOME, CENSUSPlus_HUMAN, CENSUSPlus_NIGHTELF, CENSUSPlus_DRAENEI};
	end
	return ret;
end

-----------------------------------------------------------------------------------
--
-- Return a table of classes for the input faction
--
-----------------------------------------------------------------------------------
local function CensusPlus_GetFactionClasses(faction)
        local ret = {};
        ret = {CENSUSPlus_DRUID, CENSUSPlus_HUNTER, CENSUSPlus_MAGE, CENSUSPlus_PRIEST, CENSUSPlus_ROGUE, CENSUSPlus_WARLOCK, CENSUSPlus_WARRIOR, CENSUSPlus_PALADIN, CENSUSPlus_SHAMAN};
        return ret;
        --[[
        if (faction == CENSUSPlus_HORDE) then
		ret = {CENSUSPlus_DRUID, CENSUSPlus_HUNTER, CENSUSPlus_MAGE, CENSUSPlus_PRIEST, CENSUSPlus_ROGUE, CENSUSPlus_WARLOCK, CENSUSPlus_WARRIOR, CENSUSPlus_SHAMAN};
	elseif (faction == CENSUSPlus_ALLIANCE) then
		ret = {CENSUSPlus_DRUID, CENSUSPlus_HUNTER, CENSUSPlus_MAGE, CENSUSPlus_PRIEST, CENSUSPlus_ROGUE, CENSUSPlus_WARLOCK, CENSUSPlus_WARRIOR, CENSUSPlus_PALADIN};
	end
	return ret;
        ]]
end

-----------------------------------------------------------------------------------
--
-- Return a table of classes for the input race
--
-----------------------------------------------------------------------------------
local function CensusPlus_GetRaceClasses(race)
	local ret = {};
	if (race == CENSUSPlus_ORC) then
		ret = {CENSUSPlus_WARRIOR, CENSUSPlus_HUNTER, CENSUSPlus_ROGUE, CENSUSPlus_SHAMAN, CENSUSPlus_WARLOCK};
	elseif (race == CENSUSPlus_TAUREN) then
		ret = {CENSUSPlus_WARRIOR, CENSUSPlus_HUNTER, CENSUSPlus_SHAMAN, CENSUSPlus_DRUID};
	elseif (race == CENSUSPlus_TROLL) then
		ret = {CENSUSPlus_WARRIOR, CENSUSPlus_HUNTER, CENSUSPlus_ROGUE, CENSUSPlus_PRIEST, CENSUSPlus_SHAMAN, CENSUSPlus_MAGE};
	elseif (race == CENSUSPlus_UNDEAD) then
		ret = {CENSUSPlus_WARRIOR, CENSUSPlus_ROGUE, CENSUSPlus_PRIEST, CENSUSPlus_MAGE, CENSUSPlus_WARLOCK};
	elseif (race == CENSUSPlus_DWARF) then
		ret = {CENSUSPlus_WARRIOR, CENSUSPlus_PALADIN, CENSUSPlus_HUNTER, CENSUSPlus_ROGUE, CENSUSPlus_PRIEST};
	elseif (race == CENSUSPlus_GNOME) then
		ret = {CENSUSPlus_WARRIOR, CENSUSPlus_ROGUE, CENSUSPlus_MAGE, CENSUSPlus_WARLOCK};
	elseif (race == CENSUSPlus_HUMAN) then
		ret = {CENSUSPlus_WARRIOR, CENSUSPlus_PALADIN, CENSUSPlus_ROGUE, CENSUSPlus_PRIEST, CENSUSPlus_MAGE, CENSUSPlus_WARLOCK};
	elseif (race == CENSUSPlus_NIGHTELF) then
		ret = {CENSUSPlus_WARRIOR, CENSUSPlus_HUNTER, CENSUSPlus_ROGUE, CENSUSPlus_PRIEST, CENSUSPlus_DRUID};
	elseif (race == CENSUSPlus_BLOODELF) then
		ret = {CENSUSPlus_PALADIN, CENSUSPlus_HUNTER, CENSUSPlus_ROGUE, CENSUSPlus_PRIEST, CENSUSPlus_MAGE, CENSUSPlus_WARLOCK};
	elseif (race == CENSUSPlus_DRAENEI) then
		ret = {CENSUSPlus_WARRIOR, CENSUSPlus_PALADIN, CENSUSPlus_HUNTER, CENSUSPlus_PRIEST, CENSUSPlus_SHAMAN, CENSUSPlus_MAGE};
	end
	return ret;
end

-----------------------------------------------------------------------------------
--
-- Return common letters found in zone names
--
-----------------------------------------------------------------------------------
--[[
    -- 칼림도어
    "다르나서스",
    "텔드랏실",
    "어둠의 해안",
    "악령의 숲",
    "여명의 설원",
    "잿빛 골짜기",
    "아즈샤라",
    "돌발톱 산맥",
    "불모의 땅",
    "오그리마",
    "듀로타",
    "잊혀진 땅",
    "썬더 블러프",
    "멀고어",
    "페랄라스",
    "먼지진흙 습지대",
    "버섯구름 봉우리",
    "실리더스",
    "운고로 분화구",
    "타나리스",
    -- 동부대륙
    "검은바위 산", 
    "언더시티",
    "아이언포지",
    "스톰윈드",
    "티리스팔 숲",
    "서부 역병지대",
    "동부 역병지대",
    "은빛소나무 숲",
    "알터랙 산맥",
    "힐스브래드 구릉지",
    "동부 내륙지",
    "아라시 고원",
    "저습지",
    "던 모로",
    "모단 호수",
    "이글거리는 협곡",
    "황야의 땅",
    "불타는 평원",
    "엘윈 숲",
    "붉은마루 산맥",
    "서부 몰락지대",
    "그늘숲",
    "죽음의 고개",
    "슬픔의 늪",
    "가시덤불 골짜기",
    "저주받은 땅",
    -- 던젼
    "성난불길 협곡",
    "통곡의 동굴",
    "검은심연의 나락",
    "가시덩쿨 우리",
    "가시덩쿨 구릉",
    "줄파락",
    "줄구룹",
    "마라우돈",
    "혈투의 전장",
    "오닉시아의 둥지",
    "죽음의 폐광",
    "그림자송곳니 성채",
    "스톰윈드 지하감옥",
    "놈리건",
    "붉은십자군 수도원",
    "울다만",
    "아탈학카르 신전",
    "검은바위 나락",
    "검은바위 첨탑",
    "스칼로맨스",
    "스트라솔름",
    "화산 심장부",
    "검은날개 둥지",
    "안퀴라즈",
    "낙스라마스",
    -- 전장
    "전쟁노래 협곡",
    "알터랙 계곡",
    "아라시 분지"
]]

local function GetZoneLetters()
	-- 한글 지역
        if (UnitFactionGroup("player") == "Horde") then
            return {
                "오그리마", -- 오그리마 
                "샤트라스",
                "어둠달 골짜기",
                "황천의 폭풍",
                "칼날 산맥",
                "나그란드",
                "테로가르 숲",
                "카라잔",
                "어둠의 미궁",
                "메카나르",
                "알터랙 계곡",
                "칼날 산맥",
                "장가르 습지대",
            };
        else
            return {
                "아이언포지", -- 아이언포지 
                "샤트라스",
                "어둠달 골짜기",
                "황천의 폭풍",
                "칼날 산맥",
                "나그란드",
                "테로가르 숲",
                "카라잔",
                "어둠의 미궁",
                "메카나르",
                "알터랙 계곡",
                "칼날 산맥",
                "장가르 습지대",
            };
        end
end
	
---------------------------------------------------------------------------------
--
-- Register with Cosmos UI
-- 
---------------------------------------------------------------------------------
local function CensusPlus_RegisterCosmos()
	--
	-- If Cosmos is installed, add a button to the Cosmos page to activate CensusPlus
	--
	if ( Earth) then
		EarthFeature_AddButton(
			{
				id = "CensusPlus";
				name = CENSUSPlus_BUTTON_TEXT;
				subtext = CENSUSPlus_BUTTON_SUBTEXT;
				tooltip = CENSUSPlus_BUTTON_TIP;
				icon = "Interface\\AddOns\\CensusPlus\\Skin\\CensusPlus_Icon";
				callback = CensusPlus_Toggle;
			}
		);
	elseif ( Cosmos_RegisterButton ) then 
			Cosmos_RegisterButton(CENSUSPlus_BUTTON_TEXT, CENSUSPlus_BUTTON_SUBTEXT, CENSUSPlus_BUTTON_TIP, "Interface\\AddOns\\CensusPlus\\Skin\\CensusPlus_Icon", CensusPlus_Toggle);
	end
end


----------------------------------------------------------------------------------
--
-- Called when the main window is shown
-- 
---------------------------------------------------------------------------------
function CensusPlus_OnShow()
	-- Initialize if this is the first OnShow event
	if (g_CensusPlusInitialized == false) then
		g_CensusPlusInitialized = true;
	end
	CensusPlus_UpdateView();
end

----------------------------------------------------------------------------------
--
-- Toggle hidden status
-- 
---------------------------------------------------------------------------------
function CensusPlus_Toggle() 
	if ( CensusPlus:IsVisible() ) then 
		CensusPlus:Hide();
	else
		CensusPlus:Show();
                MiniCensusPlus:Hide();
	end
end

----------------------------------------------------------------------------------
--
-- Toggle options pane
-- 
---------------------------------------------------------------------------------
function CensusPlus_ToggleOptions() 
	if ( CP_OptionsWindow:IsVisible() ) then 
		CP_OptionsWindow:Hide();
	else
		CP_OptionsWindow:Show();
	end
end

-----------------------------------------------------------------------------------
--
-- Called once on load
--
-----------------------------------------------------------------------------------
function CensusPlus_OnLoad()
    --
    -- Update the version number
    --
    CensusPlusText:SetText("Census+ "..CensusPlus_VERSION);
    CensusPlusText2:SetText( CENSUSPlus_UPLOAD );

    --
    -- Init constant tables
    --
    InitConstantTables();

    --
    -- Register with Cosmos, if it is installed
    --
    CensusPlus_RegisterCosmos();

    --
    -- Register for events
    --
    this:RegisterEvent("VARIABLES_LOADED");
    this:RegisterEvent("WHO_LIST_UPDATE");
    --	this:RegisterEvent("GUILD_ROSTER_SHOW");
    --	this:RegisterEvent("GUILD_ROSTER_UPDATE");
    --	this:RegisterEvent("TRAINER_SHOW");
    --	this:RegisterEvent("TRAINER_CLOSED");
    --	this:RegisterEvent("MERCHANT_SHOW");
    --	this:RegisterEvent("MERCHANT_CLOSED");
    --	this:RegisterEvent("GUILD_REGISTRAR_SHOW");
    --	this:RegisterEvent("GUILD_REGISTRAR_CLOSED");
    --	this:RegisterEvent("TRADE_SHOW");
    --	this:RegisterEvent("TRADE_CLOSED");
    --	this:RegisterEvent("AUCTION_HOUSE_SHOW");
    --	this:RegisterEvent("AUCTION_HOUSE_CLOSED");
    --	this:RegisterEvent("BANKFRAME_OPENED");
    --	this:RegisterEvent("BANKFRAME_CLOSED");


    this:RegisterEvent("PLAYER_TARGET_CHANGED" );
    this:RegisterEvent("UPDATE_MOUSEOVER_UNIT");	
--    this:RegisterEvent("PARTY_MEMBERS_CHANGED");	
            
    this:RegisterEvent("ZONE_CHANGED_NEW_AREA");		

    this:RegisterEvent("AUCTION_ITEM_LIST_UPDATE");
    this:RegisterEvent("UPDATE_BATTLEFIELD_SCORE");
    this:RegisterEvent("UPDATE_WORLD_STATES");
    this:RegisterEvent("LOOT_OPENED");
    this:RegisterEvent("MERCHANT_UPDATE");
    this:RegisterEvent("MERCHANT_SHOW");
    this:RegisterEvent("QUEST_COMPLETE");
    this:RegisterEvent("CHAT_MSG_LOOT");
    --[[
    this:RegisterEvent("QUEST_DETAIL");
    this:RegisterEvent("QUEST_GREETING");
    this:RegisterEvent("QUEST_PROGRESS");
    this:RegisterEvent("QUEST_FINISHED");
    this:RegisterEvent("QUEST_ITEM_UPDATE");
    this:RegisterEvent("QUEST_ACCEPT_CONFIRM");
    this:RegisterEvent("QUEST_LOG_UPDATE");
    ]]

    --
    -- Register a slash command
    --
    SLASH_CensusPlusCMD1 = "/Census";
    SLASH_CensusPlusCMD2 = "/CensusPlus";
    SLASH_CensusPlusCMD3 = "/Census+";
    SLASH_CensusPlusCMD4 = "/인구조사";
    SlashCmdList["CensusPlusCMD"] = CensusPlus_Command;

    SLASH_CensusPlusVerbose1 = "/censusverbose";	
    SlashCmdList["CensusPlusVerbose"] = CensusPlus_Verbose;

    --
    --  Set the auto close to true
    --
    CensusPlus_AutoCloseWho( 1 );
    --AutoClose:SetChecked( 1 );

    g_Pre_FriendsFrameOnHideOverride = FriendsFrame_OnHide;
    FriendsFrame_OnHide = CensusPlus_FriendsFrame_OnHide;

    g_Pre_FriendsFrameOnShowOverride = FriendsFrame_OnShow;
    FriendsFrame_OnShow = CensusPlus_FriendsFrame_OnShow;

    g_Pre_WhoList_UpdateOverride = WhoList_Update;
    WhoList_Update = CensusPlus_WhoList_Update;	

    g_Pre_FriendsFrame_Update  = FriendsFrame_Update;
    FriendsFrame_Update = CensusPlus_FriendsFrame_Update;

    g_Pre_WhoHandler = SlashCmdList["WHO"];
    SlashCmdList["WHO"] = CensusPlus_WhoHandler;

    CensusPlus_CheckForBattleground();
end

-----------------------------------------------------------------------------------
--
-- Load Handler for options box
--
-----------------------------------------------------------------------------------
function CP_OptionsOnShow()
	CP_OptionAutoClose:SetChecked(g_WhoAutoClose);
	CP_OptionVerboseButton:SetChecked(CensusPlus_Database["Info"]["Verbose"]);
	CP_OptionScanAuction:SetChecked(CensusPlus_Database["Info"]["ScanAuction"]);
	CP_OptionScanBG:SetChecked(CensusPlus_Database["Info"]["ScanBG"]);
	CP_OptionScanLoot:SetChecked(CensusPlus_Database["Info"]["ScanLoot"]);
end

-----------------------------------------------------------------------------------
--
-- CensusPlus Friends Frame override to stop the window close sound
--
-----------------------------------------------------------------------------------
function CensusPlus_FriendsFrame_OnHide()
	g_Pre_FriendsFrameOnHideOverride();
end

-----------------------------------------------------------------------------------
--
-- CensusPlus Friends Frame override to stop the window close sound
--
-----------------------------------------------------------------------------------
function CensusPlus_FriendsFrame_OnShow()
	g_Pre_FriendsFrameOnShowOverride();
end

function CensusPlus_WhoList_Update()
	if( g_IsCensusPlusInProgress == true and g_WhoAutoClose ) then
		local numWhos, totalCount = GetNumWhoResults();
		local name, guild, level, race, class, zone, group;
		local button;
		local columnTable;
		local whoOffset = FauxScrollFrame_GetOffset(WhoListScrollFrame);
		local whoIndex;
		local showScrollBar = nil;
		if ( numWhos > WHOS_TO_DISPLAY ) then
			showScrollBar = 1;
		end
		local displayedText = "";
		if ( totalCount > MAX_WHOS_FROM_SERVER ) then
			displayedText = format(WHO_FRAME_SHOWN_TEMPLATE, MAX_WHOS_FROM_SERVER);
		end
		WhoFrameTotals:SetText(format(GetText("WHO_FRAME_TOTAL_TEMPLATE", nil, totalCount), totalCount).."  "..displayedText);
		for i=1, WHOS_TO_DISPLAY, 1 do
			whoIndex = whoOffset + i;
			button = getglobal("WhoFrameButton"..i);
			button.whoIndex = whoIndex;
			name, guild, level, race, class, zone, group = GetWhoInfo(whoIndex);
			columnTable = { zone, guild, race };
			getglobal("WhoFrameButton"..i.."Name"):SetText(name);
			getglobal("WhoFrameButton"..i.."Level"):SetText(level);
			getglobal("WhoFrameButton"..i.."Class"):SetText(class);
			local variableText = getglobal("WhoFrameButton"..i.."Variable");
			variableText:SetText(columnTable[UIDropDownMenu_GetSelectedID(WhoFrameDropDown)]);
			if ( not group  ) then
				group = "";
			end
			--getglobal("WhoFrameButton"..i.."Group"):SetText(getglobal(strupper(group)));
			
			-- If need scrollbar resize columns
			if ( showScrollBar ) then
				variableText:SetWidth(95);
			else
				variableText:SetWidth(110);
			end

			-- Highlight the correct who
			if ( WhoFrame.selectedWho == whoIndex ) then
				button:LockHighlight();
			else
				button:UnlockHighlight();
			end
			
			if ( whoIndex > numWhos ) then
				button:Hide();
			else
				button:Show();
			end
		end

		if ( not WhoFrame.selectedWho ) then
			WhoFrameGroupInviteButton:Disable();
			WhoFrameAddFriendButton:Disable();
		else
			WhoFrameGroupInviteButton:Enable();
			WhoFrameAddFriendButton:Enable();
			WhoFrame.selectedName = GetWhoInfo(WhoFrame.selectedWho); 
		end

		-- If need scrollbar resize columns
		if ( showScrollBar ) then
			WhoFrameColumn_SetWidth(105, WhoFrameColumnHeader2);
			UIDropDownMenu_SetWidth(80, WhoFrameDropDown);
		else
			WhoFrameColumn_SetWidth(120, WhoFrameColumnHeader2);
			UIDropDownMenu_SetWidth(95, WhoFrameDropDown);
		end

		-- ScrollFrame update
		FauxScrollFrame_Update(WhoListScrollFrame, numWhos, WHOS_TO_DISPLAY, FRIENDS_FRAME_WHO_HEIGHT );
	else
		g_Pre_WhoList_UpdateOverride();
	end
end


function CensusPlus_FriendsFrame_Update()
	if ( FriendsFrame.selectedTab == 3 and g_IsCensusPlusInProgress == true and g_WhoAutoClose ) then
		FriendsFrameTopLeft:SetTexture("Interface\\ClassTrainerFrame\\UI-ClassTrainer-TopLeft");
		FriendsFrameTopRight:SetTexture("Interface\\ClassTrainerFrame\\UI-ClassTrainer-TopRight");
		FriendsFrameBottomLeft:SetTexture("Interface\\FriendsFrame\\GuildFrame-BotLeft");
		FriendsFrameBottomRight:SetTexture("Interface\\FriendsFrame\\GuildFrame-BotRight");
		local guildName;
		guildName = GetGuildInfo("player");
		FriendsFrameTitleText:SetText(guildName);
		FriendsFrame_ShowSubFrame("GuildFrame");
	else
		g_Pre_FriendsFrame_Update();
	end
end

-----------------------------------------------------------------------------------
--
-- CensusPlus Who Handler
--
-----------------------------------------------------------------------------------
function CensusPlus_WhoHandler( msg )
	if( g_IsCensusPlusInProgress == true ) then
		if ( msg == "" ) then
			msg = WhoFrame_GetDefaultWhoCommand();
			ShowWhoPanel();
		elseif ( msg == "cheat" ) then
			-- Remove the "cheat" part later!
			ShowWhoPanel();
		end
		SendWho(msg);
	else
		g_Pre_WhoHandler(msg);
	end
end

-----------------------------------------------------------------------------------
--
-- CensusPlus command
--
-----------------------------------------------------------------------------------
function CensusPlus_Command( param )
    local  firsti, lasti, command, value = string.find (param, "(%w+) (%w+)") ;

--	if( string.lower(param) == "locale" ) then
--		CP_EU_US_Version:Show();
--	else
	if( string.lower(param) == "options" or param == "설정" ) then
		CP_OptionsWindow:Show();
	elseif( string.lower(param) == "tz" ) then
		CensusPlus_DetermineServerDate();
	elseif( string.lower(param) == "verbose" ) then
		CensusPlus_Verbose();
	elseif( param == "초기화" ) then
		CensusPlus_Purge();
	elseif( param == "시작" ) then
		CensusPlus_StartCensus();
	elseif( param == "중지" ) then
		CensusPlus_StopCensus();
	else
		CensusPlus_DisplayUsage();
	end
end

-----------------------------------------------------------------------------------
--
-- CensusPlus Display Usage
--
-----------------------------------------------------------------------------------
function CensusPlus_DisplayUsage()
    local text;

    CensusPlus:Show();

    CensusKr_Print("Usage:\n  /인구조사 \n");
    CensusKr_Print("  /인구조사 verbose - 대화모드를 켜거나 끕니다. \n");
    CensusKr_Print("  /인구조사 설정 - 설정 창을 엽니다. \n");
    CensusKr_Print("  /인구조사 초기화 - 인구조사 자료를 초기화합니다. \n");
    CensusKr_Print("  /인구조사 시작 - 인구조사를 시작합니다.\n");
    CensusKr_Print("  /인구조사 중지 - 인구조사를 중지합니다.\n");
end

-----------------------------------------------------------------------------------
--
-- CensusPlus Verbose option
--
-----------------------------------------------------------------------------------
function CensusPlus_Verbose()
    if( CensusPlus_Database["Info"]["Verbose"] == true ) then
        CensusKr_Print( "Verbose Mode : OFF" );
        CensusPlus_Database["Info"]["Verbose"] = false;
	else
        CensusKr_Print( "Verbose Mode : ON" );
        CensusPlus_Database["Info"]["Verbose"] = true;
    end
end

function CensusPlus_SetOption(opt, flag) 
    if (opt =="auction") then
        CensusPlus_Database["Info"]["ScanAuction"] = flag;
    end
    if (opt =="bg") then
        CensusPlus_Database["Info"]["ScanBG"] = flag;
    end
    if (opt =="loot") then
        CensusPlus_Database["Info"]["ScanLoot"] = flag;
    end
end

-----------------------------------------------------------------------------------
--
-- Minimize the window
--
-----------------------------------------------------------------------------------
function CensusPlus_OnClickMinimize()
    if( CensusPlus:IsVisible() ) then
        MiniCensusPlus:Show();
        CensusPlus:Hide();
    end
end

-----------------------------------------------------------------------------------
--
-- Minimize the window
--
-----------------------------------------------------------------------------------
function CensusPlus_OnClickMaximize()
    if( MiniCensusPlus:IsVisible() ) then
        MiniCensusPlus:Hide();
        CensusPlus:Show();
    end
end

-----------------------------------------------------------------------------------
--
-- Take or pause a census depending on current status
--
-----------------------------------------------------------------------------------
function CensusPlus_Take_OnClick()
	if (g_IsCensusPlusInProgress) then
	    CensusPlus_TogglePause();
	else
		CensusPlus_StartCensus();
	end
end

-----------------------------------------------------------------------------------
--
-- Display a tooltip for the take button
--
-----------------------------------------------------------------------------------
function CensusPlus_Take_OnEnter()
	if (g_IsCensusPlusInProgress) then
		if (g_CensusPlusManuallyPaused) then
			GameTooltip:SetOwner(this, "ANCHOR_RIGHT");
			GameTooltip:SetText(CENSUSPlus_UNPAUSECENSUS, 1.0, 1.0, 1.0);
			GameTooltip:Show();					
		else
			GameTooltip:SetOwner(this, "ANCHOR_RIGHT");
			GameTooltip:SetText(CENSUSPlus_PAUSECENSUS, 1.0, 1.0, 1.0);
			GameTooltip:Show();					
		end
	else
		GameTooltip:SetOwner(this, "ANCHOR_RIGHT");
		GameTooltip:SetText(CENSUSPlus_TAKECENSUS, 1.0, 1.0, 1.0);
		GameTooltip:Show();					
	end
end

-----------------------------------------------------------------------------------
--
-- Pause the current census
--
-----------------------------------------------------------------------------------
function CensusPlus_TogglePause()
	if (g_IsCensusPlusInProgress == true) then
	    if( g_CensusPlusManuallyPaused == true ) then
	        CensusPlusTakeButton:SetText( CENSUSPlus_PAUSE );
            g_CensusPlusManuallyPaused = false;
	    else
	        CensusPlusTakeButton:SetText( CENSUSPlus_UNPAUSE );
            g_CensusPlusManuallyPaused = true;
        end
    end
end
-----------------------------------------------------------------------------------
--
-- Purge the database for this realm and faction
--
-----------------------------------------------------------------------------------
function CensusPlus_Purge()
	if( CensusPlus_Database["Servers"] ~= nil ) then
		CensusPlus_Database["Servers"] = nil;
	end
	CensusPlus_Database["Servers"] = {};
	CensusPlus_UpdateView();
	CensusKr_Print(CENSUSPlus_PURGEMSG);	
	
	if( CensusPlus_Database["Guilds"] ~= nil ) then
		CensusPlus_Database["Guilds"] = nil;
	end
	CensusPlus_Database["Guilds"] = {};

	if( CensusPlus_Database["TimesPlus"] ~= nil ) then
		CensusPlus_Database["TimesPlus"] = nil;
	end
	CensusPlus_Database["TimesPlus"] = {};

        if( CensusPlus_Database["Stat"] ~= nil ) then
		CensusPlus_Database["Stat"] = nil;
	end
	CensusPlus_Database["Stat"] = {};

        CK_Auction = {};
        CK_Item = {};
        CK_BattleField = {};
        CK_Loot = {};
        CK_Quest = {};
        CK_Vendor = {};
        CensusKr_Print("경매, 루팅, 전장 정보를 삭제하였습니다.");
	
end

-----------------------------------------------------------------------------------
--
-- Handler for auto close checkbox
--
-----------------------------------------------------------------------------------
function CensusPlus_AutoCloseWho(close)
    g_WhoAutoClose = close;
end

-----------------------------------------------------------------------------------
--
-- Take a CensusPlus
--
-----------------------------------------------------------------------------------
function CensusPlus_StartCensus()

    if (g_IsCensusPlusInProgress) then
        if( g_CensusPlusManuallyPaused == true ) then
            g_CensusPlusManuallyPaused = false;
            CensusPlusPauseButton:SetText( CENSUSPlus_PAUSE );
        else
            -- Do not initiate a new CensusPlus while one is in progress
            CensusKr_Print(CENSUSPlus_ISINPROGRESS);
        end
    elseif( g_CurrentlyInBG ) then
        g_LastCensusRun = time()-600;    
        CensusKr_Print(CENSUSPlus_ISINBG);
    else
        -- who 결과를 ui로 보냄
        SetWhoToUI(1);

        --
        -- Initialize the job queue and counters
        --
        CensusKr_Print(CENSUSPlus_TAKINGONLINE);
        g_NumNewCharacters = 0;
        g_NumUpdatedCharacters = 0;
        g_JobQueue = {};

        -- timestamp 초기화
        g_TimeStamp = nil;
        CensusKr_setTimeStamp(); 

        -- 진행상태
        g_ProcessedZone = {};

        local counter = 0;
        -- 레벨 조건으로 환원 (확장팩)
        for outer = 0, 4, 1 do
            local job = {m_MinLevel=outer*10+1, m_MaxLevel=outer*10+10};
            InsertJobIntoQueue(job);
        end
        local job = {m_MinLevel=51, m_MaxLevel=59};
        InsertJobIntoQueue(job);
        job = {m_MinLevel=60, m_MaxLevel=60};
        InsertJobIntoQueue(job);
        for outer = 61, MAX_CHARACTER_LEVEL, 1 do
            local job = {m_MinLevel = outer, m_MaxLevel = outer};
            InsertJobIntoQueue(job);
        end
        --[[ 지역 조건 
        local zoneLetters = GetZoneLetters();
        g_ProcessZoneCount = #zoneLetters; -- 진행 상태 처리용.
        local minLevel = 1;
        local maxLevel = MAX_CHARACTER_LEVEL; -- 60
        for i=1, #zoneLetters, 1 do
        local job = {m_zoneLetter = zoneLetters[i], m_MinLevel = minLevel, m_MaxLevel = maxLevel};
        InsertJobIntoQueue(job);
        end
        ]]

        g_IsCensusPlusInProgress = true;
        g_WaitingForWhoUpdate = false;
        g_CensusPlusManuallyPaused = false;

        local hour, minute = CensusKr_GetTime();
        g_TakeHour = hour;
        g_ResetHour = true;
    end

    CensusPlusTakeButton:SetText( CENSUSPlus_PAUSE );
    MiniCensusPlusButton1:SetText(CENSUSPlus_STOP);
    CensusKr_InitProgressBar();
end

-----------------------------------------------------------------------------------
--
-- Stop a CensusPlus
--
-----------------------------------------------------------------------------------
function CensusPlus_StopCensus(  )
    if (g_IsCensusPlusInProgress) then
        CensusPlusTakeButton:SetText( CENSUSPlus_TAKE );
        MiniCensusPlusButton1:SetText(CENSUSPlus_TAKE);
        g_CensusPlusManuallyPaused = false;

        g_JobQueue = {};
        g_JobQueue = nil;
        g_JobQueue = {};

        CensusPlus_DisplayResults(true);
        CensusKr_InitProgressBar();
    else
        CensusKr_Print(CENSUSPlus_NOCENSUS);
    end
end

-----------------------------------------------------------------------------------
--
-- Display Census results
--
-----------------------------------------------------------------------------------
function CensusPlus_DisplayResults(forced)
    --
    -- We are all done, report our results
    --
    g_IsCensusPlusInProgress = false;
    --CensusPlus_UpdateView();

    if (forced) then
        CensusKr_Print("인구조사가 중지되었습니다.");
    else
        CensusKr_Print(format(CENSUSPlus_FINISHED, g_NumUpdatedCharacters));
        ChatFrame1:AddMessage(CENSUSPlus_UPLOAD, 0.5, 1.0, 1.0);
        --MiniCensusPlus:Hide();
        CensusPlusProgressText:SetText("인구조사 완료");
        MiniCensusPlusButton1:SetText(CENSUSPlus_TAKE);
        g_TimeKey = g_TimeStamp;
        -- DropDown Menu 다시 불러오기
        if (CensusPlus:IsVisible()) then
            CensusKrTsDropDown:Hide();
            CensusKrTsDropDown:Show();
        end
    end

    CensusPlus_UpdateView();
    g_LastCensusRun = time();

    -- who 결과 ui 반응을 원래 상태로 돌림. 
    SetWhoToUI(0);

    CensusPlusTakeButton:SetText( CENSUSPlus_TAKE );
end

-----------------------------------------------------------------------------------
--
-- Create a who command text for the input job
--
-----------------------------------------------------------------------------------
function CensusPlus_CreateWhoText(job)
	local whoText = "";
	local race = job.m_Race;
	if (race ~= nil) then
		whoText = whoText.." r-\""..race.."\"";
	end

	local class = job.m_Class;
	if (class ~= nil) then
		whoText = whoText.." c-\""..class.."\"";
	end

	local minLevel = job.m_MinLevel;
	if (minLevel == nil) then
		minLevel = 1;
	end
	local maxLevel = job.m_MaxLevel;
	if (maxLevel == nil) then
		maxLevel = 60;
	end
	whoText = whoText.." "..minLevel.."-"..maxLevel;

	local zoneLetter = job.m_zoneLetter;
	if ( zoneLetter ~= nil) then
		whoText = whoText.." z-\""..zoneLetter.."\"";
	end

	--[[ 한글처리 안됨
	local letter = job.m_Letter;
	if( letter ~= nil ) then
		whoText = whoText.." n-"..letter;
	end
	--]]
	return whoText;
end

function CensusKr_getProcess()
    return math.ceil(#g_ProcessedZone / g_ProcessZoneCount * 100) .. "%";
end

-----------------------------------------------------------------------------------
--
-- Called on events
--
-----------------------------------------------------------------------------------
function CensusPlus_OnEvent(event,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9)

	if( arg1 == nil ) then
		arg1 = "nil"
	end
	if( arg2 == nil ) then
		arg2 = "nil"
	end
	if( arg3 == nil ) then
		arg3 = "nil"
	end
	if( arg4 == nil ) then
		arg4 = "nil"
	end
		
	--
	-- If we have not been initialized, do nothing
	--
	if (g_CensusPlusInitialized == false) then
		return
	end
	
--	CensusKr_Print( "Message =>" .. event );
	
	--
	-- WHO_LIST_UPDATE
	--
	if( event == "TRAINER_SHOW" or event == "MERCHANT_SHOW" or event == "TRADE_SHOW" or event == "GUILD_REGISTRAR_SHOW" 
	            or event == "AUCTION_HOUSE_SHOW" or event == "BANKFRAME_OPENED" or event == "QUEST_DETAIL" ) then
	    if( g_IsCensusPlusInProgress ) then
	        g_CensusPlusPaused = true;
	    end
	elseif( event == "TRAINER_CLOSED" or event == "MERCHANT_CLOSED" or event == "TRADE_CLOSED" or event == "GUILD_REGISTRAR_CLOSED" 
	            or event == "AUCTION_HOUSE_CLOSED" or event == "BANKFRAME_CLOSED" or event == "QUEST_FINISHED" ) then
	    if( g_IsCensusPlusInProgress ) then
	        g_CensusPlusPaused = false;
	    end
        elseif (event == "AUCTION_ITEM_LIST_UPDATE") then
            if (CensusPlus_Database["Info"]["ScanAuction"]) then
                Ck_ProcessAuction();
            end
        elseif (event == "UPDATE_BATTLEFIELD_SCORE" or event == "UPDATE_WORLD_STATES") then
            if (CensusPlus_Database["Info"]["ScanBG"]) then
                Ck_ProcessBF();
            end
        elseif (event == "MERCHANT_SHOW" or event == "MERCHANT_UPDATE") then
                --CensusKr_Print("fired... " .. event);
                Ck_ProcessVendor();
        elseif (event == "CHAT_MSG_LOOT") then
                --CensusKr_Print("arg1... " .. arg1);
                local itemLink = gsub(arg1, "아이템을 획득했습니다: (.+)", "%1");
                if (itemLink) then
                    Ck_SaveItem(itemLink);
                end
        elseif (event == "QUEST_COMPLETE") then
                --CensusKr_Print("fired... " .. event);
                Ck_ProcessQuest();
        elseif (event == "LOOT_OPENED") then
            if (CensusPlus_Database["Info"]["ScanLoot"]) then
                Ck_ProcessLoot();
            end
	elseif(event == "WHO_LIST_UPDATE") then
		--
		-- Only process who results if a CensusPlus is in progress
		--
		if (g_IsCensusPlusInProgress) then
			local numWhoResults = GetNumWhoResults();
			--CensusKr_Print("debug: WHO_LIST_UPDATE fired. ret - " .. numWhoResults);
			CensusPlus_CheckForBattleground();
			CensusPlus_ProcessWhoResults();
			if (numWhoResults > MAX_WHO_RESULTS) then
				--
				-- Who list is overflowed, split the query to make the return smaller
                                -- 지역/종족/직업/레벨
				--
				local minLevel = g_CurrentJob.m_MinLevel;
				local maxLevel = g_CurrentJob.m_MaxLevel;
				local race = g_CurrentJob.m_Race;
				local class = g_CurrentJob.m_Class;
				local zoneLetter = g_CurrentJob.m_zoneLetter;
				local letter = g_CurrentJob.m_Letter;
                                --[[ 지역 검색 우선 
                                if (zoneLetter == nil) then
                                        --
                                        -- This job does not specify zone, so split it that way, making more jobs
                                        --
                                        local zoneLetters = GetZoneLetters();
                                        for i=1, #zoneLetters, 1 do
                                                local job = {m_zoneLetter = zoneLetters[i], m_MinLevel = minLevel, m_MaxLevel = maxLevel};
                                                InsertJobIntoQueue(job);
                                        end
                                else
                                    --
                                    -- We cannot split the level range any more
                                    --
                                    local factionGroup = UnitFactionGroup("player");
                                    if (race == nil) then
                                            --
                                            -- This job does not specify race, so split it that way, making four new jobs
                                            --
                                            local thisFactionRaces = GetFactionRaces(factionGroup);
                                            local numRaces = #thisFactionRaces;
                                            for i = 1, numRaces, 1 do
                                                    local job = {m_zoneLetter = zoneLetter, m_Race = thisFactionRaces[i], m_MinLevel = minLevel, m_MaxLevel = maxLevel};
                                                    InsertJobIntoQueue(job);
                                            end	
                                    else             
                                        if (class == nil) then
                                                --
                                                -- This job does not specify class, so split it that way, making more jobs
                                                --
                                                local thisRaceClasses = GetRaceClasses(race);
                                                local numClasses = #thisRaceClasses;
                                                for i = 1, numClasses, 1 do
                                                        local job = {m_zoneLetter = zoneLetter, m_Race = race, m_Class = thisRaceClasses[i], m_MinLevel = minLevel, m_MaxLevel = maxLevel};
                                                        InsertJobIntoQueue(job);
                                                end	
                                        else                               
                                            if (minLevel ~= maxLevel) then
                                                    --
                                                    -- The level range is greater than a single level, so split it in half and submit the two jobs
                                                    --
                                                    local pivot = floor((minLevel + maxLevel) / 2);
                                                    local jobLower = {m_zoneLetter = zoneLetter, m_Race = race, m_Class = class, m_MinLevel = minLevel, m_MaxLevel = pivot};
                                                    InsertJobIntoQueue(jobLower);
                                                    local jobUpper = {m_zoneLetter = zoneLetter, m_Race = race, m_Class = class, m_MinLevel = pivot + 1, m_MaxLevel = maxLevel};
                                                    InsertJobIntoQueue(jobUpper);
                                            else
                                                    --
                                                    -- There are too many characters with a single level, class, race and letter, give up
                                                    --
                                                    local whoText = CensusPlus_CreateWhoText(g_CurrentJob);
                                                    if( CensusPlus_Database["Info"]["Verbose"] == true ) then
                                                            CensusKr_Print(format(CENSUSPlus_TOOMANY, whoText));
                                                    end
                                            end -- end level
                                        end -- end class
                                    end -- end race
                                end -- end zone
                                ]]
				if (minLevel ~= maxLevel) then
                                    --
                                    -- The level range is greater than a single level, so split it in half and submit the two jobs
                                    --
                                    local pivot = floor((minLevel + maxLevel) / 2);
                                    local jobLower = {m_Race = race, m_Class = class, m_MinLevel = minLevel, m_MaxLevel = pivot};
                                    InsertJobIntoQueue(jobLower);
                                    local jobUpper = {m_Race = race, m_Class = class, m_MinLevel = pivot + 1, m_MaxLevel = maxLevel};
                                    InsertJobIntoQueue(jobUpper);
				else
                                    --
                                    -- We cannot split the level range any more
                                    --
                                    local factionGroup = UnitFactionGroup("player");
                                    local level = minLevel;
                                    if (race == nil) then
                                            --
                                            -- This job does not specify race, so split it that way, making four new jobs
                                            --
                                            local thisFactionRaces = CensusPlus_GetFactionRaces(factionGroup);
                                            local numRaces = table.getn(thisFactionRaces);
                                            for i = 1, numRaces, 1 do
                                                    local job = {m_Race = thisFactionRaces[i], m_MinLevel = minLevel, m_MaxLevel = maxLevel};
                                                    InsertJobIntoQueue(job);
                                            end
                                    else
                                        if (class == nil) then
                                                --
                                                -- This job does not specify class, so split it that way, making more jobs
                                                --
                                                local thisRaceClasses = CensusPlus_GetRaceClasses(race);
                                                local numClasses = table.getn(thisRaceClasses);
                                                for i = 1, numClasses, 1 do
                                                    -- 마법사에서 중복 검색되니깐 흑마법사는 검색에서 제외. 시간 좀 줄이자...
                                                    if (thisRaceClasses[i] ~= CENSUSPlus_WARLOCK) then
                                                        local job = {m_Race = race, m_Class = thisRaceClasses[i], m_MinLevel = minLevel, m_MaxLevel = maxLevel};
                                                        InsertJobIntoQueue(job);
                                                    end
                                                end
                                        else
                                            if( zoneLetter == nil ) then
                                                    --
                                                    -- There are too many characters with a single level, class and race
                                                    --  주요 지역으로 추가 검색.
                                                    --
                                                local zoneLetters = GetZoneLetters();
                                                for i=1, #zoneLetters, 1 do
                                                        local job = {m_zoneLetter = zoneLetters[i], m_MinLevel = minLevel, m_MaxLevel = maxLevel, m_Race = race, m_Class = class};
                                                        InsertJobIntoQueue(job);
                                                end
                                            else
                                                --
                                                -- There are too many characters with a single level, class, race and letter, give up
                                                --
                                                local whoText = CensusPlus_CreateWhoText(g_CurrentJob);
                                                if( CensusPlus_Database["Info"]["Verbose"] == true ) then
                                                        CensusKr_Print(format(CENSUSPlus_TOOMANY, whoText));
                                                end
                                            end -- end zone
                                        end -- end class
                                    end -- end race
				end -- end level
                            end
		else
		    --
		    --  This is just a random /who done by the player
		    --  인구조사 진행 중인 경우가 아니면 조사 하지 않음.
			--CensusPlus_ProcessWhoResults();
		end
		--
		-- We got the who update
		--
		g_WaitingForWhoUpdate = false;
	elseif ( event == "VARIABLES_LOADED" ) then
	    --
	    --  Initialize our variables
	    --
	    CensusPlus_InitializeVariables();
        elseif (event == "PLAYER_TARGET_CHANGED") then
            CensusKr_SetUnitSex("target");
            CensusKr_BaseStat("target");
        elseif (event == "UPDATE_MOUSEOVER_UNIT") then
            CensusKr_SetUnitSex("mouseover");
            CensusKr_BaseStat("mouseover");
            --[[
        elseif (event == "PARTY_MEMBERS_CHANGED") then
            CensusKr_Print("fired: " .. event);
            ]]
        elseif( event == "ZONE_CHANGED_NEW_AREA" ) then
		--
		--  We need to check to see if we entered a battleground
		--
		CensusPlus_CheckForBattleground();
	end
end

function CensusKr_SetUnitSex(unit)
    local realm = GetRealmName();
    local realmDB = CensusPlus_Database.Servers[realm];
    if (realmDB == nil) then
        return;
    end
    local name = UnitName(unit);
    local unitDB = realmDB[name];
    if (unitDB == nil) then
        return;
    end
    if (unitDB.sex == nil) then
        unitDB.sex = UnitSex(unit);
    end
end

--[[
race,class,level = stat (Strength, Agility, Stamina, Intellect, Spirit )
]]
function CensusKr_BaseStat(unit)
    local statDB;

    if (CensusPlus_Database["Stat"] == nil) then
        CensusPlus_Database["Stat"] = {};
    end
    statDB = CensusPlus_Database["Stat"];
    local race = UnitRace(unit);
    local class = UnitClass(unit);
    local level = UnitLevel(unit);
    local base = "";
    if (CheckInteractDistance(unit, 1)) then
        for i = 1, 5 do 
            bs, es, pb, nb = UnitStat(unit, i);
            if (bs) then
                if (bs == 0) then 
                    return;
                else
                    --CensusKr_Print("bs:" .. bs .. " es:" .. es .. "pb:" .. pb .. " nb:" .. nb);
                    bs = bs - pb - nb;
                    if (base ~= "") then
                        base = base .. ",";
                    end
                    base = base .. bs;
                end
            end
        end
    end

    if (race and class and level and base ~= "") then
        if (statDB[race] == nil) then
            statDB[race] = {};
        end
        if (statDB[race][class] == nil) then
            statDB[race][class] = {};
        end
        if (statDB[race][class][level] == nil) then
            --CensusKr_Print(race .. " " .. class .. " " .. level .. " " .. base);
            statDB[race][class][level] = base;
        end                    
    end -- end if race,class,level
end

-----------------------------------------------------------------------------------
--
-- Initialize our primary save variables --  called when VARIABLES_LOADED event is fired
--
-----------------------------------------------------------------------------------
function CensusPlus_InitializeVariables()

    if( CensusPlus_Database["Servers"] == nil ) then 
            CensusPlus_Database["Servers"] = {};
    end	    
    
    if( CensusPlus_Database["TimesPlus"] == nil ) then
        CensusPlus_Database["TimesPlus"] = {};
    end
	
    --
    --  Times should now be initted, so let's sort them
    --
    table.sort(CensusPlus_Database["TimesPlus"]);

    --
    --  Make sure info is last so it will be first in the output so we can grab the version number
    --
    if( CensusPlus_Database["Info"] == nil ) then
        CensusPlus_Database["Info"] = {};
        CensusPlus_Database["Info"]["Verbose"] = true;
        CensusPlus_Database["Info"]["ScanAuction"] = true;
        CensusPlus_Database["Info"]["ScanBG"] = true;
        CensusPlus_Database["Info"]["ScanLoot"] = true;
    end
    if (CensusPlus_Database["Info"]["ScanAuction"] == nil) then
        CensusPlus_Database["Info"]["ScanAuction"] = true;
    end
    if (CensusPlus_Database["Info"]["ScanBG"] == nil) then
        CensusPlus_Database["Info"]["ScanBG"] = true;
    end
    if (CensusPlus_Database["Info"]["ScanLoot"] == nil) then
        CensusPlus_Database["Info"]["ScanLoot"] = true;
    end

    -- 이전 버젼인 경우. 저장기록 초기화. 
    if ((CensusPlus_Database["Info"]["DataVersion"] == nil) 
    or (CensusPlus_Database["Info"]["DataVersion"] ~= CensusKr_DataVersion)) then
        CensusKr_Print("자료구조가 변경되어서 이전 버젼에서 작성된 조사기록을 초기화합니다.");
        CensusPlus_Purge();
    end

    CensusPlus_Database["Info"]["Version"] = CensusPlus_VERSION;
    CensusPlus_Database["Info"]["DataVersion"] = CensusKr_DataVersion;
    CensusPlus_Database["Info"]["ClientLocale"] = GetLocale();
    if( CensusPlus_Database["Info"]["LoginServer"] ~= nil ) then
        --  already present, make sure it equals, and if
        --		not, force a purge
        if( CensusPlus_Database["Info"]["LoginServer"] ~= GetCVar("realmList") ) then
            --[[
                    We have to nuke the data in the case that someone is playing on both
                    US and EU servers
            ]]--
            CensusPlus_Purge()
        end
    end
    CensusPlus_Database["Info"]["LoginServer"] = GetCVar("realmList");

    local localeSetting = CensusPlus_Database["Info"]["Locale"];
    if( localeSetting == "??" ) then
        --  We had problems previously.. we must purge =(
        CensusPlus_Purge();
        localeSetting = nil;
    end
    
    if( localeSetting == nil ) then
        --
        --  Have a new way to detect locale, yay!
        --
        if( CensusPlus_Database["Info"]["ClientLocale"] == "enUS" ) then
            CensusPlus_Database["Info"]["Locale"] = "US";
        elseif( CensusPlus_Database["Info"]["ClientLocale"] == "enGB" ) then
            CensusPlus_Database["Info"]["Locale"] = "EU";
        elseif( CensusPlus_Database["Info"]["ClientLocale"] == "frFR" ) then
            CensusPlus_Database["Info"]["Locale"] = "EU";
        elseif( CensusPlus_Database["Info"]["ClientLocale"] == "deDE" ) then
            CensusPlus_Database["Info"]["Locale"] = "EU";
        elseif( CensusPlus_Database["Info"]["ClientLocale"] == "koKR" ) then
            CensusPlus_Database["Info"]["Locale"] = "KR";
        else
            CensusPlus_Database["Info"]["Locale"] = "??";
        end
    end
    
    local locale = CensusPlus_Database["Info"]["Locale"];
    if (locale == nil) then
        CensusPlus_Database["Info"]["Locale"] = g_CensusPlusLocale;
    end
    
    local miniStart = CensusPlus_Database["Info"]["MiniStart"];
    if( miniStart == nil ) then
        miniStart = 0;
    end

    if( CensusPlus_Database["Info"]["CensusButtonPosition"] == nil ) then
        CensusPlus_Database["Info"]["CensusButtonPosition"] = 370;
    end

    if( CensusPlus_Database["Info"]["CensusButtonShown"] == nil ) then
        CensusPlus_Database["Info"]["CensusButtonShown"] = 1;
    end

    if( CensusPlus_Database["Info"]["CensusButtonShown"] == 1 ) then
            CensusButtonFrame:Show();
    else
            CensusButtonFrame:Hide();
    end
	
    if( miniStart ) then
        CensusKr_Print(" "..CensusPlus_VERSION.." "..CENSUSPlus_MSG1);
    end
    
    g_VariablesLoaded = true;
    
    InitConstantTables();
    
    CP_OptionAutoShowMinimapButton:SetChecked(CensusPlus_Database["Info"]["CensusButtonShown"]);
    CP_SliderButtonPos:SetValue(CensusPlus_Database["Info"]["CensusButtonPosition"]);
end



-----------------------------------------------------------------------------------
--
-- Call on the update event
--
-----------------------------------------------------------------------------------
function CensusPlus_OnUpdate()
        -- autocensus 옵션 기능. autocensus가 활성화 되어 있으면 자동으로 인구조사 시작. 
        -- kr5에서 막음. 
        --[[
	if( g_VariablesLoaded and g_IsCensusPlusInProgress == false and g_LastCensusRun < time() - 1800 ) then
		CensusPlus_Take_OnClick();
	end
        ]]
	
	if (g_IsCensusPlusInProgress == true and g_CensusPlusPaused == false and g_CensusPlusManuallyPaused == false ) then
		local now = GetTime();
		local delta = now - g_LastOnUpdateTime;
		if (delta > CensusPlus_UPDATEDELAY) then
			g_LastOnUpdateTime = now;
			if (g_WaitingForWhoUpdate == true) then
				--
				-- Resend /who command
				--
				g_WhoAttempts = g_WhoAttempts + 1;
				local whoText = CensusPlus_CreateWhoText(g_CurrentJob);
				if( CensusPlus_Database["Info"]["Verbose"] == true ) then
				    CensusKr_Print(CENSUSPlus_WAITING);
				end
				if( g_WhoAttempts < 3 ) then
					if( g_WhoAttempts == 2 ) then
						g_CurrentJob.m_MinLevel = g_CurrentJob.m_MinLevel - 2;
						whoText = CensusPlus_CreateWhoText(g_CurrentJob);
						SendWho(whoText);
					else
						SendWho(whoText);
					end
				else
				    g_WaitingForWhoUpdate = false;
				end
			else
				--
				-- Determine if there is any more work to do
				--
				local numJobs = #g_JobQueue;
				if (numJobs > 0) then
					--
					-- Remove the top job from the queue and send it
					--
					local job = g_JobQueue[numJobs];
					table.remove(g_JobQueue);
					local whoText = CensusPlus_CreateWhoText(job);
					g_CurrentJob = job;
					g_WaitingForWhoUpdate = true;
                                        -- 진행율
                                        --[[
                                        if (g_ProcessedZone[g_CurrentJob.m_zoneLetter] == nil) then
                                            g_ProcessedZone[g_CurrentJob.m_zoneLetter] = g_CurrentJob.m_zoneLetter;
                                        end
                                        local pc = CensusKr_getProcess();
                                        CensusKr_SetProgressBar(whoText, pc);
                                        --]]
                                        if( CensusPlus_Database["Info"]["Verbose"] == true ) then
					    --CensusKr_Print(format(CENSUSPlus_SENDING2, whoText, pc));
                                            CensusKr_Print(format(CENSUSPlus_SENDING, whoText));
					end
					SendWho(whoText);
				    g_WhoAttempts = 0;
				else
					--
					-- We are all done, hide the friends frame and report our results
					--
					CensusPlus_DoTimeCounts();					
					CensusPlus_DisplayResults();
				end
			end
		end
	end
end

function CensusKr_SetProgressBar(t, p)
    local CensusPlusProgressBar_Size = 145; -- 진행바 x값
    local pc = string.gsub(p, "%%", "");
    local sp = pc / 100 * CensusPlusProgressBar_Size 
    CensusPlusProgressText:SetText("인구조사 중(" .. p .. ")");
    CensusPlusProgressBar:SetValue(pc);
    CensusPlusProgressSpark:SetPoint("CENTER", "CensusPlusProgressBar", "LEFT", sp, 0);
end

function CensusKr_InitProgressBar()
    CensusPlusProgressText:SetText("인구조사");
    CensusPlusProgressBar:SetValue(100);
    CensusPlusProgressSpark:SetPoint("CENTER", "CensusPlusProgressBar", "LEFT", 0, 0);
end

-----------------------------------------------------------------------------------
--
-- Take final tally
--
-----------------------------------------------------------------------------------
function CensusPlus_DoTimeCounts()

	if( g_CurrentlyInBG == true ) then
		return;
	end

	--  Zero out the times
	g_TimeDatabase[CENSUSPlus_DRUID]		= 0;
	g_TimeDatabase[CENSUSPlus_HUNTER]		= 0;
	g_TimeDatabase[CENSUSPlus_MAGE]			= 0;
	g_TimeDatabase[CENSUSPlus_PRIEST]		= 0;
	g_TimeDatabase[CENSUSPlus_ROGUE]		= 0;
	g_TimeDatabase[CENSUSPlus_WARLOCK]	    = 0;
	g_TimeDatabase[CENSUSPlus_WARRIOR]	    = 0;
	g_TimeDatabase[CENSUSPlus_SHAMAN]		= 0;
	g_TimeDatabase[CENSUSPlus_PALADIN]	    = 0;
 
        g_TimeDatabase[CENSUSPlus_DWARF]        = 0;
        g_TimeDatabase[CENSUSPlus_GNOME]        = 0;
        g_TimeDatabase[CENSUSPlus_HUMAN]        = 0;
        g_TimeDatabase[CENSUSPlus_NIGHTELF]     = 0;
        g_TimeDatabase[CENSUSPlus_ORC]          = 0;
        g_TimeDatabase[CENSUSPlus_TAUREN]       = 0;
        g_TimeDatabase[CENSUSPlus_TROLL]                = 0;
        g_TimeDatabase[CENSUSPlus_UNDEAD]       = 0;	
        g_TimeDatabase[CENSUSPlus_DRAENEI]       = 0;	
        g_TimeDatabase[CENSUSPlus_BLOODELF]       = 0;	

	local realmName = GetCVar("realmName");
	if( CensusPlus_Database["TimesPlus"][realmName] == nil ) then
		CensusPlus_Database["TimesPlus"][realmName]= {};
	end					

        local factionGroup = UnitFactionGroup("player");
	if( CensusPlus_Database["TimesPlus"][realmName][factionGroup] == nil ) then
            CensusPlus_Database["TimesPlus"][realmName][factionGroup] = {};
	end

        local realmDB = CensusPlus_Database["Servers"][realmName];
        if (realmDB == nil) then
            CensusKr_Print("DB Error");
            return;
        end

        for _, unitDB in pairs(realmDB) do
            if (unitDB.times[g_TimeStamp]) then
                g_TimeDatabase[unitDB.race] = g_TimeDatabase[unitDB.race] + 1;
                g_TimeDatabase[unitDB.class] = g_TimeDatabase[unitDB.class] + 1;
                g_NumUpdatedCharacters = g_NumUpdatedCharacters + 1;
            end
        end

	local numTimes = #CensusPlus_Database["TimesPlus"][realmName][UnitFactionGroup("player")];
	if (numTimes > CP_MAX_TIMES-1 ) then
		--
		-- Remove the top time from the queue 
		--
		table.remove( CensusPlus_Database["TimesPlus"][realmName][UnitFactionGroup("player")] );
	end

	local hour, minute = CensusKr_GetTime();
--					CensusPlus_Database["TimesPlus"][realmName][UnitFactionGroup("player")]["" .. hour .. ""] = g_TimeDatabase;
	--CensusPlus_Database["TimesPlus"][realmName][UnitFactionGroup("player")][CensusPlus_DetermineServerDate() .. "&" .. hour .. ":" .. minute .. ":00"] = 
        CensusPlus_Database["TimesPlus"][realmName][factionGroup][g_TimeStamp] = 
		g_TimeDatabase[CENSUSPlus_DRUID] .. "&" ..
		g_TimeDatabase[CENSUSPlus_HUNTER] .. "&" ..
		g_TimeDatabase[CENSUSPlus_MAGE] .. "&" ..
		g_TimeDatabase[CENSUSPlus_PRIEST] .. "&" ..
		g_TimeDatabase[CENSUSPlus_ROGUE] .. "&" ..
		g_TimeDatabase[CENSUSPlus_WARLOCK] .. "&" ..
		g_TimeDatabase[CENSUSPlus_WARRIOR] .. "&" ..
		g_TimeDatabase[CENSUSPlus_SHAMAN] .. "&" ..
		g_TimeDatabase[CENSUSPlus_PALADIN] .. "&"..
                0 .. "&" ..
                0 .. "&" ..
                0 .. "&" ..
                g_TimeDatabase[CENSUSPlus_DWARF] .. "&" ..
                g_TimeDatabase[CENSUSPlus_GNOME] .. "&" ..
                g_TimeDatabase[CENSUSPlus_HUMAN] .. "&" ..
                g_TimeDatabase[CENSUSPlus_NIGHTELF] .. "&" ..
                g_TimeDatabase[CENSUSPlus_ORC] .. "&" ..
                g_TimeDatabase[CENSUSPlus_TAUREN] .. "&" ..
                g_TimeDatabase[CENSUSPlus_TROLL] .. "&" ..
                g_TimeDatabase[CENSUSPlus_UNDEAD] .. "&" ..
                g_TimeDatabase[CENSUSPlus_DRAENEI] .. "&" ..
                g_TimeDatabase[CENSUSPlus_BLOODELF];                
end

function CensusKr_GetTime()
    local hour, minute = GetGameTime();
    if (hour < 10) then
        hour = "0" .. hour;
    end
    if (minute < 10) then
        minute = "0" .. minute;
    end
    return hour, minute;
end


function CensusKr_setTimeStamp()
    local hour, minute = CensusKr_GetTime();
    local ts = CensusPlus_DetermineServerDate() .. "&" .. hour .. ":" .. minute .. ":00";
    g_TimeStamp = ts;
    --return ts;
end

function CensusKr_getLastTimeStamp(realm, faction)
    local CensusDB = CensusPlus_Database["TimesPlus"];
    if (CensusDB[realm] == nil) then
        return;
    end
    if (CensusDB[realm][faction] == nil) then
        return;
    end
    local last = "";
    for ts, _ in pairs(CensusDB[realm][faction]) do
        if (ts > last) then 
            last = ts;
        end
    end
    return last;
end
-----------------------------------------------------------------------------------
--
-- Add the contents of the who results to the database
--
-----------------------------------------------------------------------------------
function CensusPlus_ProcessWhoResults()
    --
    --  If we are in a BG then stop a census
    --
    if( g_CurrentlyInBG and g_IsCensusPlusInProgress ) then
        g_LastCensusRun = time()-600;    
        CensusKr_Print(CENSUSPlus_ISINBG);
        CensusPlus_StopCensus( );
    end


    --
    -- Get the portion of the database for this server
    --
    local realmName = GetCVar("realmName");
    local realmDB = CensusPlus_Database["Servers"][realmName];
    if (realmDB == nil) then
        CensusPlus_Database["Servers"][realmName] = {};
        realmDB = CensusPlus_Database["Servers"][realmName];
    end

    if (g_TimeStamp == nil) then
        CensusKr_setTimeStamp();
    end
    local timeStamp = g_TimeStamp;

    local factionGroup = UnitFactionGroup("player");
    
    --
    -- Walk through all the who results
    --
    local numWhoResults = GetNumWhoResults();
    if( CensusPlus_Database["Info"]["Verbose"] == true ) then
        CensusKr_Print(format(CENSUSPlus_PROCESSING, numWhoResults));
    end
    for i = 1, numWhoResults, 1 do
        --
        -- Get who result entry
        --
        local name, guild, level, race, class, zone, group = GetWhoInfo(i);

        local unit = realmDB[name];
        if (unit == nil) then
            realmDB[name] = {};
            unit = realmDB[name];
            unit.faction = factionGroup;
            unit.race = race;
            unit.class = class;
            unit.guild = guild;
            unit.level = level;
            unit.sex = 1; -- 1 unknown, 2 male, 3 female (changed in 1.11, http://www.wowwiki.com/API_UnitSex)
            unit.times = {};
            unit.times[timeStamp] = {zone=zone, guild=guild, level=level};
        else
            -- 다음 조사에 바뀔 수 있는 값들, level, guild, ts, zone
            unit.level = level;
            unit.guild = guild;
            unit.times[timeStamp] = {zone=zone, guild=guild, level=level};
        end
    end
    --CensusPlus_UpdateView();
end

----------------------------------------------------------------------------------
--
-- Find a guild in the g_Guilds array by name
-- 
---------------------------------------------------------------------------------
local function FindGuildByName(name)
	local i;
	local size = #g_Guilds;
	for i = 1, size, 1 do
		local entry = g_Guilds[i];
		if (entry.m_Name == name) then
			return i;
		end
	end
	return nil;
end

----------------------------------------------------------------------------------
--
-- Add up the total character XP and count
-- 
---------------------------------------------------------------------------------
local g_AccumulateGuildTotals = true;
local function TotalsAccumulator(name, level, guild)
	g_TotalCount = g_TotalCount + 1;
	if (g_AccumulateGuildTotals and (guild ~= nil)) then
		local index = FindGuildByName(guild);
		if (index == nil) then
			local size = #g_Guilds;
			index = size + 1;
			g_Guilds[index] = {m_Name = guild, m_TotalCharacterXP = 0, m_Count = 0};
		end
		local entry = g_Guilds[index];
                entry.m_TotalCharacterXP = entry.m_TotalCharacterXP + level;
		entry.m_Count = entry.m_Count + 1;
	end
end

----------------------------------------------------------------------------------
--
-- Predicate function which can be used to compare two guilds for sorting
-- 
---------------------------------------------------------------------------------
local function GuildPredicate(lhs, rhs)
	--
	-- nil references are always less than
	--
	if (lhs == nil) then
		if (rhs == nil) then
			return false;
		else
			return true;
		end
	elseif (rhs == nil) then
		return false;	
	end
	--
        --인원 * 레벨 (경험치 대신 산정) 
	--
	if (rhs.m_TotalCharacterXP < lhs.m_TotalCharacterXP) then
		return true;
	elseif (lhs.m_TotalCharacterXP < rhs.m_TotalCharacterXP) then
		return false;
	end
	--
	-- Sort by name
	--
	if (lhs.m_Name < rhs.m_Name) then
		return true;
	elseif (rhs.m_Name < lhs.m_Name) then
		return false;
	end
	
	--
	-- identical
	--
	return false;	
end


----------------------------------------------------------------------------------
--
-- Another accumulator for adding up XP and counts
-- name: 길드 정보처리 위해 보내는 것일 뿐, 전체 데이터 처리에선 상관없음. 
---------------------------------------------------------------------------------
local g_AccumulatorCount = 0;
local g_AccumulatorXPTotal = 0;
local function CensusPlus_Accumulator(name, level, guild)
	g_AccumulatorCount = g_AccumulatorCount + 1;
end

----------------------------------------------------------------------------------
--
-- Reset the above accumulator
-- 
---------------------------------------------------------------------------------
function CensusPlus_ResetAccumulator()
	g_AccumulatorCount = 0;
	g_AccumulatorXPTotal = 0;
end


----------------------------------------------------------------------------------
--
-- Search the character database using the search criteria and update display
-- 
---------------------------------------------------------------------------------
function CensusPlus_UpdateView()
	--
	-- Get realm and faction
	--
	local realmName = GetCVar("realmName");
	if( realmName == nil ) then
		return;
	end
	CensusPlusRealmName:SetText(format(CENSUSPlus_REALMNAME, realmName));
	
	local factionGroup = UnitFactionGroup("player");
	if( factionGroup == nil ) then
		return;
	end

	CensusPlusFactionName:SetText(format(CENSUSPlus_FACTION, factionGroup));

	if( CensusPlus_Database["Info"]["Locale"] ~= nil ) then
		CensusPlusLocaleName:SetText(format(CENSUSPlus_LOCALE, CensusPlus_Database["Info"]["Locale"]));
	end

        local timeKey = g_TimeKey;

	local guildKey = nil;
	local raceKey = nil;
	local classKey = nil;
	local levelKey = nil;
	g_TotalCharacterXP = 0;
	g_TotalCount = 0;
	
	--
	-- Has the user selected a guild?
	--
	if (g_GuildSelected > 0) then
		guildKey = g_Guilds[g_GuildSelected].m_Name;
	end
	if (g_RaceSelected > 0) then
		local thisFactionRaces = CensusPlus_GetFactionRaces(factionGroup);
		raceKey = thisFactionRaces[g_RaceSelected];
	end
	if (g_ClassSelected > 0) then
		local thisFactionClasses = CensusPlus_GetFactionClasses(factionGroup);
		classKey = thisFactionClasses[g_ClassSelected];
	end
	if (g_LevelSelected > 0 or g_LevelSelected < 0) then
		levelKey = g_LevelSelected;
	end
	
	--
	-- Has the user added any search criteria?
	--
	if ((guildKey ~= nil) or (raceKey ~= nil) or (classKey ~= nil) or (levelKey ~= nil)) then
		--
		-- Get totals for this criteria
		--
		g_AccumulateGuildTotals = false;
		CensusPlus_ForAllCharacters(realmName, factionGroup, timeKey, raceKey, classKey, guildKey, levelKey, TotalsAccumulator);
	else
		--
		-- Get the overall totals and find guild information
		--
		g_Guilds = {};
		g_AccumulateGuildTotals = true;
		CensusPlus_ForAllCharacters(realmName, factionGroup, timeKey, nil, nil, nil, nil, TotalsAccumulator);
		local size = #g_Guilds;
		if (size) then
			table.sort(g_Guilds, GuildPredicate);
		end
	end
	local levelSearch = nil;
	if (levelKey ~= nil) then
		levelSearch = "  ("..CENSUSPlus_LEVEL..": ";
		local level = levelKey;
		if (levelKey < 0) then
			levelSearch = levelSearch.."!";
			level = 0 - levelKey;
		end
		levelSearch = levelSearch..level..")";
	end

	local totalCharactersText = nil;
	if (levelSearch ~= nil) then
		totalCharactersText = format(CENSUSPlus_TOTALCHAR, g_TotalCount)..levelSearch;
	else
		totalCharactersText = format(CENSUSPlus_TOTALCHAR, g_TotalCount);
	end
	CensusPlusTotalCharacters:SetText(totalCharactersText);
	CensusPlus_UpdateGuildButtons();
	
	--
	-- Accumulate totals for each race
	--
	local maxCount = 0;
	local thisFactionRaces = CensusPlus_GetFactionRaces(factionGroup);
	local numRaces = #thisFactionRaces;
	for i = 1, numRaces, 1 do
		local race = thisFactionRaces[i];
		CensusPlus_ResetAccumulator();
		if ((raceKey == nil) or (raceKey == race)) then
			CensusPlus_ForAllCharacters(realmName, factionGroup, timeKey, race, classKey, guildKey, levelKey, CensusPlus_Accumulator);
		end
		if (g_AccumulatorCount > maxCount) then
			maxCount = g_AccumulatorCount;
		end
		g_RaceCount[i] = g_AccumulatorCount;
	end

	--
	-- Update race bars
	--
	for i = 1, numRaces, 1 do
		local race = thisFactionRaces[i];
		local buttonName = "CensusPlusRaceBar"..i;
		local button = getglobal(buttonName);
		local thisCount = g_RaceCount[i];
		if ((thisCount ~= nil) and (thisCount > 0) and (maxCount > 0)) then
			local height = floor((thisCount / maxCount) * CensusPlus_MAXBARHEIGHT);
			if (height < 1 or height == nil ) then height = 1; end
			button:SetHeight(height);
			button:Show();
		else
			button:Hide();
		end
		local normalTextureName="Interface\\AddOns\\CensusPlus\\Skin\\CensusPlus_"..g_RaceClassList[race];
		local legendName = "CensusPlusRaceLegend"..i;
		local legend = getglobal(legendName);
		legend:SetNormalTexture(normalTextureName);
		if (g_RaceSelected == i) then
			legend:LockHighlight();
		else
			legend:UnlockHighlight();
		end
	end	

	--
	-- Accumulate totals for each class
	--
	local maxCount = 0;
	local thisFactionClasss = CensusPlus_GetFactionClasses(factionGroup);
	local numClasses = #thisFactionClasss;
	for i = 1, numClasses, 1 do
		local class = thisFactionClasss[i];
		CensusPlus_ResetAccumulator();
		if ((classKey == nil) or (classKey == class)) then
			CensusPlus_ForAllCharacters(realmName, factionGroup, timeKey, raceKey, class, guildKey, levelKey, CensusPlus_Accumulator);
		end
		if (g_AccumulatorCount > maxCount) then
			maxCount = g_AccumulatorCount;
		end
		g_ClassCount[i] = g_AccumulatorCount;
	end

	--
	-- Update class bars
	--
	for i = 1, numClasses, 1 do
		local class = thisFactionClasss[i];
			
		local buttonName = "CensusPlusClassBar"..i;
		local button = getglobal(buttonName);
		local thisCount = g_ClassCount[i];
		if ((thisCount ~= nil) and (thisCount > 0) and (maxCount > 0)) then
			local height = floor((thisCount / maxCount) * CensusPlus_MAXBARHEIGHT);
			if (height < 1 or height == nil ) then height = 1; end
			button:SetHeight(height);
			button:Show();
		else
			button:Hide();
		end
		
		local normalTextureName="Interface\\AddOns\\CensusPlus\\Skin\\CensusPlus_"..g_RaceClassList[class];
		local legendName = "CensusPlusClassLegend"..i;
		local legend = getglobal(legendName);
		legend:SetNormalTexture(normalTextureName);
		if (g_ClassSelected == i) then
			legend:LockHighlight();
		else
			legend:UnlockHighlight();
		end
	end	
	
	--
	-- Accumulate totals for each level
	--
	local maxCount = 0;
	for i = 1, MAX_CHARACTER_LEVEL, 1 do
	    if ((levelKey == nil) or (levelKey == i) or (levelKey < 0 and levelKey + i ~= 0)) then
			CensusPlus_ResetAccumulator();
			CensusPlus_ForAllCharacters(realmName, factionGroup, timeKey, raceKey, classKey, guildKey, i, CensusPlus_Accumulator);
			if (g_AccumulatorCount > maxCount) then
				maxCount = g_AccumulatorCount;
			end
			g_LevelCount[i] = g_AccumulatorCount;
		else
			g_LevelCount[i] = 0;
		end
	end

	--
	-- Update level bars
	--
	for i = 1, MAX_CHARACTER_LEVEL, 1 do
		local buttonName = "CensusPlusLevelBar"..i;
		local buttonEmptyName = "CensusPlusLevelBarEmpty"..i;
		local button = getglobal(buttonName);
		local emptyButton = getglobal(buttonEmptyName);
		local thisCount = g_LevelCount[i];
		if ((thisCount ~= nil) and (thisCount > 0) and (maxCount > 0)) then
			local height = floor((thisCount / maxCount) * CensusPlus_MAXBARHEIGHT);
			if (height < 1 or height == nil ) then height = 1; end
			button:SetHeight(height);
			button:Show();
			if (emptyButton ~= nil) then
				emptyButton:Hide();
			end
		else
			button:Hide();
			if (emptyButton ~= nil) then
				emptyButton:SetHeight(CensusPlus_MAXBARHEIGHT);
				emptyButton:Show();
			end
		end
	end	
end

----------------------------------------------------------------------------------
--
-- Walk the character database and call the callback function for every entry that matches the search criteria
-- 
---------------------------------------------------------------------------------
function CensusPlus_ForAllCharacters(realmKey, factionKey, timeKey, raceKey, classKey, guildKey, levelKey, callback)
    for realmName, realmDB in pairs(CensusPlus_Database["Servers"]) do
        if ((realmKey == nil) or (realmKey == realmName)) then
            for name, unit in pairs(realmDB) do
                if ((factionKey == nil) or (factionKey == unit.faction)) then
                    if ((raceKey == nil) or (raceKey == unit.race)) then
                        if ((classKey == nil) or (classKey == unit.class)) then
                            if (timeKey == nil) then
                                if ((guildKey == nil) or (guildKey == unit.guild)) then
                                    if ((levelKey == nil) or (levelKey == unit.level) or (levelKey < 0 and levelKey + unit.level ~= 0)) then
                                        callback(name, unit.level, unit.guild);
                                    end
                                end
                            else
                                if (unit.times[timeKey] ~= nil) then
                                    if ((guildKey == nil) or (guildKey == unit.times[timeKey].guild)) then
                                        if ((levelKey == nil) or 
                                        (levelKey == unit.times[timeKey].level) or 
                                        (levelKey < 0 and levelKey + unit.times[timeKey].level ~= 0)) then
                                            callback(name, unit.times[timeKey].level, unit.times[timeKey].guild);
                                        end
                                    end
                                end
                            end
                        end -- class
                    end -- race
                end -- faction                    
            end -- for unit
        end -- if realm 
    end -- for realm
end -- end func

----------------------------------------------------------------------------------
--
-- Race legend clicked
-- 
---------------------------------------------------------------------------------
function CensusPlus_OnClickRace()
	local id = this:GetID();
	if (id == g_RaceSelected) then
		g_RaceSelected = 0;
	else
		g_RaceSelected = id;
	end
	CensusPlus_UpdateView();
end

----------------------------------------------------------------------------------
--
-- Class legend clicked
-- 
---------------------------------------------------------------------------------
function CensusPlus_OnClickClass()
	local id = this:GetID();
	if (id == g_ClassSelected) then
		g_ClassSelected = 0;
	else
		g_ClassSelected = id;
	end
	CensusPlus_UpdateView();
end


----------------------------------------------------------------------------------
--
-- Level bar loaded
-- 
---------------------------------------------------------------------------------
function CensusPlus_OnLoadLevel()
	this:RegisterForClicks("LeftButtonUp","RightButtonUp");
end

----------------------------------------------------------------------------------
--
-- Level bar clicked
-- 
---------------------------------------------------------------------------------
function CensusPlus_OnClickLevel(button)
	local id = this:GetID();
	if (((button == "LeftButton") and (id == g_LevelSelected)) or ((button == "RightButton") and (id + g_LevelSelected == 0))) then
		g_LevelSelected = 0;
	elseif (button == "RightButton") then
		g_LevelSelected = 0 - id;
	else
		g_LevelSelected = id;
	end
	CensusPlus_UpdateView();
end

----------------------------------------------------------------------------------
--
-- Race tooltip
-- 
---------------------------------------------------------------------------------
function CensusPlus_OnEnterRace()
	local factionGroup = UnitFactionGroup("player");
	local thisFactionRaces = CensusPlus_GetFactionRaces(factionGroup);
	local id = this:GetID();
	local raceName = thisFactionRaces[id];
	local count = g_RaceCount[id];
	if (count ~= nil) then
	    local percent = floor((count / g_TotalCount) * 100);
	    GameTooltip:SetOwner(this, "ANCHOR_RIGHT");
	    GameTooltip:SetText(raceName.."\n"..count.."\n"..percent.."%", 1.0, 1.0, 1.0);
	    GameTooltip:Show();
	end
end

----------------------------------------------------------------------------------
--
-- Class tooltip
-- 
---------------------------------------------------------------------------------
function CensusPlus_OnEnterClass()
	local factionGroup = UnitFactionGroup("player");
	local thisFactionClasses = CensusPlus_GetFactionClasses(factionGroup);
	local id = this:GetID();
	local className = thisFactionClasses[id];
	local count = g_ClassCount[id];
	if (count ~= nil) then
	    local percent = floor((count / g_TotalCount) * 100);
	    GameTooltip:SetOwner(this, "ANCHOR_RIGHT");
	    GameTooltip:SetText(className.."\n"..count.."\n"..percent.."%", 1.0, 1.0, 1.0);
	    GameTooltip:Show();
	end
end

----------------------------------------------------------------------------------
--
-- Level tooltip
-- 
---------------------------------------------------------------------------------
function CensusPlus_OnEnterLevel()
	local id = this:GetID();
	local count = g_LevelCount[id];
	if (count ~= nil) then
		local percent = floor((count / g_TotalCount) * 100);
		GameTooltip:SetOwner(this, "ANCHOR_RIGHT");
		GameTooltip:SetText("Level "..id.."\n"..count.."\n"..percent.."%", 1.0, 1.0, 1.0);
		GameTooltip:Show();
	end
end

----------------------------------------------------------------------------------
--
-- Clicked a guild button
-- 
---------------------------------------------------------------------------------
function CensusPlus_GuildButton_OnClick()
	local id = this:GetID();
	local offset = FauxScrollFrame_GetOffset(CensusPlusGuildScrollFrame);
	local newSelection = id + offset;
	if (g_GuildSelected ~= newSelection) then
		g_GuildSelected = newSelection;
	else
		g_GuildSelected = 0;
	end
	CensusPlus_UpdateView();
end

----------------------------------------------------------------------------------
--
-- Update the guild button contents
-- 
---------------------------------------------------------------------------------
function CensusPlus_UpdateGuildButtons()
	--
	-- Determine where the scroll bar is
	--
	local offset = FauxScrollFrame_GetOffset(CensusPlusGuildScrollFrame);
	--
	-- Walk through all the rows in the frame
	--
	local size = #g_Guilds;
	local i = 1;
	while (i <= CensusPlus_NUMGUILDBUTTONS) do
		--
		-- Get the index to the ad displayed in this row
		--
		local iGuild = i + offset;
		--
		-- Get the button on this row
		--
		local button = getglobal("CensusPlusGuildButton"..i);
		--
		-- Is there a valid guild on this row?
		--
		if (iGuild <= size) then
			local guild = g_Guilds[iGuild];
			--
			-- Update the button text
			--
			button:Show();
			local textField = "CensusPlusGuildButton"..i.."Text";
			if (guild.m_Name == "") then
				getglobal(textField):SetText(CENSUSPlus_UNGUILDED);
			else
				getglobal(textField):SetText(guild.m_Name);
			end
			--
			-- If this is the guild, highlight it
			--
			if (g_GuildSelected == iGuild) then
				button:LockHighlight();
			else
				button:UnlockHighlight();
			end
		else
			--
			-- Hide the button
			--
			button:Hide();
		end
		--
		-- Next row
		--
		i = i + 1;
	end
	--
	-- Update the scroll bar
	--
	FauxScrollFrame_Update(CensusPlusGuildScrollFrame, size, CensusPlus_NUMGUILDBUTTONS, CensusPlus_GUILDBUTTONSIZEY);
end

function CensusPlus_CheckForBattleground()
	local battlefieldTime = GetBattlefieldInstanceRunTime();
	if( battlefieldTime > 0 ) then
		--
		--  We are in a battleground so cancel the current take
		--
		g_CurrentlyInBG = true;
	else
		if( GetBattlefieldStatInfo(1) ~= nil ) then
			g_CurrentlyInBG = true;
		else
			g_CurrentlyInBG = false;
		end			
	end

end

-----------------------------------------------------------------------------------
--
-- CensusPlus_DetermineServerDate 
--
-----------------------------------------------------------------------------------
function CensusPlus_DetermineServerDate()

    -- 한국 서버만 대상이므로 시간대 체크 필요없음. 그냥 리턴. 관련 루틴 삭제
    -- UTC
    local utcDate = date("!%Y-%m-%d", time()); 
    -- Local
    local localDate = date( "%Y-%m-%d", time());
    -- tz command
    local TZOffset = CensusPlus_CheckTZ();

    --CensusKr_Print("UTC date = " .. utcDate .. " for TZOffset : " .. TZOffset .. " curr local: " .. localDate );

    return localDate;

        --[[
	local strDate;
	--
	--  Timezone offsets should fall into distinct numbers for now
	--		And now that we know if they are playing on US or EU servers
	--		we can be even better estimates
	--

	--
	--	For US servers, the offset should be either -9 to -5 or 16/19 depending on DST for NA times
	--		and for oceana it is +11/-13
	--	EU servers are either +1 or 0 or -23 depending on DST
	--

	if( CensusPlus_Database["Info"]["Locale"] == "US" ) then
		if( TZOffset > 12 ) then
			-- NA server times but wrong day
			TZOffset = TZOffset - 24;
		elseif( TZOffset < -11 ) then
			--  Oceana times but wrong day
			TZOffset = 24 - TZOffset;
		end
	else
		if( TZOffset == -23 ) then
			TZOffset = 1;
		end
	end

	--  Now, take the TZOffset and modify our time to give us server date
	strDate = date( "!%Y-%m-%d", time() + (TZOffset * 3600 ) );

	local strDate2 = date( "%Y-%m-%d : %H:%M", time() );
	CensusKr_Print("Server date = " .. strDate .. " for TZOffset : " .. TZOffset .. " curr local: " .. strDate2 );

	return strDate;
        ]]
end

function CensusPlus_CheckTZ()

    local UTCTimeHour = date( "!%H", time() );
    local LocTimeHour = date( "%H", time() );
	local hour, minute = GetGameTime();

	local locDiff  = LocTimeHour - UTCTimeHour;
	local servDiff = hour - UTCTimeHour;
        return servDiff;
	--g_CensusPlusTZOffset = servDiff;
end

-----------------------------------------------------------------------------------
--
-- 조사시간 DropDown menu
--
-----------------------------------------------------------------------------------
local function CensusKr_rsort(a, b)
    if (a > b) then
        return true;
    else
        return false;
    end
end

local g_TsOptions = {};
local g_MaxTsOption = 20;
function CensusKr_SetDropDownOptions()
    g_TsOptions = {};
    local CensusDB = CensusPlus_Database["TimesPlus"];
    local realm = GetRealmName();
    local faction = UnitFactionGroup("player");
    if (CensusDB[realm] ~= nil and CensusDB[realm][faction] ~= nil) then
        local i = 1;
        for ts, _ in pairs(CensusDB[realm][faction]) do
            if (i > g_MaxTsOption) then
                break;
            end
            table.insert(g_TsOptions, ts);
            i = i + 1;
        end
        table.sort(g_TsOptions, CensusKr_rsort);
    end
end

function CensusKr_SetTsDropDown()
    local i = 1;
    for _, ts in pairs(g_TsOptions) do
        i = i + 1;
        if (g_TimeKey == ts) then
            UIDropDownMenu_SetSelectedID(CensusKrTsDropDown, i);
            break;
        end
    end
end

function CensusKr_TsDropDown_Add(t)
    local info;
    info = {};
    info.text = t;
    info.func = CensusKr_TsDropDown_OnClick;
    UIDropDownMenu_AddButton(info);
end

function CensusKr_TsDropDown_OnShow()
    CensusKr_SetDropDownOptions();
    UIDropDownMenu_Initialize(this, CensusKr_TsDropDown_Initialize);
    UIDropDownMenu_SetWidth(170);
    if (g_TimeKey == nil) then
        UIDropDownMenu_SetSelectedID(CensusKrTsDropDown, 1);
    else
        CensusKr_SetTsDropDown();
    end
end

function CensusKr_TsDropDown_Initialize()
    CensusKr_TsDropDown_Add("모든 조사시간 데이터");
    if (#g_TsOptions < 1) then 
        return;
    end
    for _, ts in pairs(g_TsOptions) do
        CensusKr_TsDropDown_Add(ts);
    end
end

function CensusKr_TsDropDown_OnClick()
    UIDropDownMenu_SetSelectedID(CensusKrTsDropDown, this:GetID());
    if (this:GetID() == 1) then
        g_TimeKey = nil;
    else
        g_TimeKey = this:GetText();
    end
    CensusPlus_UpdateView();
end
