/*
    sayclubcontact.cpp - Kopete Sayclub Protocol

    Copyright (c) 2006      by Park J. K.		 <nemesis@planetmono.org>
    Kopete    (c) 2002-2003 by the Kopete developers <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This library is free software; you can redistribute it and/or         *
    * modify it under the terms of the GNU General Public                   *
    * License as published by the Free Software Foundation; either          *
    * version 2 of the License, or (at your option) any later version.      *
    *                                                                       *
    *************************************************************************
*/

#include "sayclubcontact.h"

#include <qptrlist.h>
#include <qtextcodec.h>
#include <qvariant.h>

#include <kaction.h>
#include <kdebug.h>
#include <klocale.h>

#include <kopeteaccount.h>
#include <kopetecontactlist.h>
#include <kopetechatsessionmanager.h>
#include <kopetemetacontact.h>
#include <kopetecontact.h>

#include "sayclubaccount.h"
#include "sayclubserver.h"
#include "sayclubprotocol.h"
#include "gaea_phpobject.h"

SayclubContact::SayclubContact( Kopete::Account* account, const QString &uniqueName, Kopete::MetaContact *parent )
	: Kopete::Contact( account, uniqueName, parent )
{
	kdDebug( 14210 ) << k_funcinfo << " uniqueName: " << uniqueName << endl;
	// FIXME: ? setDisplayName( displayName );
	m_session = 0L;
	m_account = static_cast<SayclubAccount *>( account );
	m_deleted = false;
	
	setOnlineStatus( SayclubProtocol::protocol()->sayclubOffline );
}

SayclubContact::~SayclubContact()
{
}

bool SayclubContact::isDeleted() const
{
	return m_deleted;
}

void SayclubContact::setDeleted( bool deleted )
{
	m_deleted = deleted;
}


bool SayclubContact::isReachable()
{
	/*if( onlineStatus().status() == Kopete::OnlineStatus::Offline )
		return false;
	else*/
		return true;
}

void SayclubContact::serialize( QMap<QString, QString> &/*serializedData*/, QMap<QString, QString> &/*addressBookData*/ )
{
}

Kopete::ChatSession* SayclubContact::manager( CanCreateFlags canCreate )
{
	kdDebug( 14210 ) << k_funcinfo << endl;
	
	QPtrList<Kopete::Contact> contacts;
	contacts.append( this );
	
	if( canCreate == Kopete::Contact::CanCreate && !m_session ) {
		QVariant tmpv = property( "mydesc" ).value();
		m_session = Kopete::ChatSessionManager::self()->create( account()->myself(), contacts, protocol() );
		m_session->setDisplayName( QString( "%1 | %2 (%3)" ).arg( nickName() ).arg( tmpv.asString() ).arg( onlineStatus().description() ) );
		connect( m_session, SIGNAL( messageSent( Kopete::Message&, Kopete::ChatSession* ) ), this, SLOT( sendMessage( Kopete::Message&, Kopete::ChatSession* ) ) );
		connect( m_session, SIGNAL( destroyed() ), this, SLOT( slotChatSessionDestroyed() ) );
	}
	
	return m_session;
}

QPtrList<KAction> *SayclubContact::customContextMenuActions() //OBSOLETE
{
	//FIXME!!!  this function is obsolete, we should use XMLGUI instead
	/*m_actionCollection = new KActionCollection( this, "userColl" );
	m_actionPrefs = new KAction(i18n( "&Contact Settings" ), 0, this,
			SLOT( showContactSettings( )), m_actionCollection, "contactSettings" );

	return m_actionCollection;*/
	return 0L;
}

void SayclubContact::showContactSettings()
{
	//SayclubContactSettings* p = new SayclubContactSettings( this );
	//p->show();
}

void SayclubContact::sendMessage( Kopete::Message &message, Kopete::ChatSession *session )
{
	kdDebug( 14210 ) << k_funcinfo << endl;
	
	QCString messageBody = m_account->getCodec()->fromUnicode( message.plainBody() );
	messageBody.truncate( 200 );
	PHPObject o = PHPMapObject();
	PHPMapObject &m = o.asMap();
	m["method"] = string( "request_memoplus_send" );
	m["hwnd"] = string( "300000" ); // FIXME What the hell is this?
	m["content"] = string( (const char *)messageBody );
	m["flag"] = string( "1" );
	m["arrMsrl"] = PHPArrayObject();
	m["arrUserid"] = PHPArrayObject();
	QPtrList<Kopete::Contact> toList = message.to();
	QPtrListIterator<Kopete::Contact> it( toList );
	while( it.current() != 0 ) {
		if( it.current()->hasProperty( "msrl" ) ) {
			QVariant tmp = it.current()->property( "msrl" ).value();
			m["arrMsrl"].asArray().push_back( qstr2std( tmp.asString() ) );
			m["arrUserid"].asArray().push_back( qstr2std( it.current()->contactId() ) );
		}
		++it;
	}
	
	cout << "--------------------------------------------------" << endl;
	
	if( m["arrUserid"].asArray().size() == 0 )
		return;
	
	cout << "--------------------------------------------------" << endl;
	
	Kopete::Message *newMsg = new Kopete::Message( message );
	int rqid = m_account->server()->sendCmd( "request_memoplus_send", o, m_account, SLOT( slotSendMessage( int ) ) );
	// FIXME Is this thread-safe?
	m_account->server()->m_contactList.replace( rqid, this );
	m_account->server()->m_messageList.replace( rqid, newMsg );
	
	cout << "--------------------------------------------------" << endl;
}

void SayclubContact::slotChatSessionDestroyed()
{
	kdDebug( 14210 ) << k_funcinfo << endl;
	
	m_session = 0L;
}

#include "sayclubcontact.moc"

