/*
    sayclubcontact.cpp - Kopete Sayclub Protocol

    Copyright (c) 2006      by Park J. K.		 <nemesis@planetmono.org>
    Kopete    (c) 2002-2003 by the Kopete developers <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This library is free software; you can redistribute it and/or         *
    * modify it under the terms of the GNU General Public                   *
    * License as published by the Free Software Foundation; either          *
    * version 2 of the License, or (at your option) any later version.      *
    *                                                                       *
    *************************************************************************
*/

#include "sayclubcontact.h"

#include <qlineedit.h>
#include <qcheckbox.h>
#include <qptrlist.h>
#include <qtextcodec.h>
#include <qvariant.h>
#include <qlabel.h>
#include <qsize.h>

#include <kaction.h>
#include <kdebug.h>
#include <klocale.h>
#include <kdialogbase.h>

#include <kopeteaccount.h>
#include <kopetecontactlist.h>
#include <kopetechatsessionmanager.h>
#include <kopetemetacontact.h>
#include <kopetecontact.h>

#include "sayclubinfo.h"
#include "sayclubaccount.h"
#include "sayclubserver.h"
#include "sayclubprotocol.h"
#include "gaea_phpobject.h"

SayclubContact::SayclubContact( Kopete::Account* account, const QString &uniqueName, Kopete::MetaContact *parent )
	: Kopete::Contact( account, uniqueName, parent )
{
	kdDebug( 14210 ) << k_funcinfo << " uniqueName: " << uniqueName << endl;
	// FIXME: ? setDisplayName( displayName );
	m_account = static_cast<SayclubAccount *>( account );
	m_deleted = false;
	
	QObject::connect( this, SIGNAL( errorMessage( int, const QString & ) ), m_account, SLOT( slotErrorMessageReceived( int, const QString & ) ) );
	
	setOnlineStatus( SayclubProtocol::protocol()->sayclubOffline );
}

SayclubContact::~SayclubContact()
{
}

bool SayclubContact::isDeleted() const
{
	return m_deleted;
}

void SayclubContact::setDeleted( bool deleted )
{
	m_deleted = deleted;
}


bool SayclubContact::isReachable()
{
	/*if( onlineStatus().status() == Kopete::OnlineStatus::Offline )
		return false;
	else*/
		return true;
}

void SayclubContact::serialize( QMap<QString, QString> &/*serializedData*/, QMap<QString, QString> &/*addressBookData*/ )
{
}

Kopete::ChatSession* SayclubContact::manager( CanCreateFlags canCreate )
{
	kdDebug( 14210 ) << k_funcinfo << endl;
	
	QPtrList<Kopete::Contact> contacts;
	contacts.append( this );
	
	Kopete::ChatSession *manager = Kopete::ChatSessionManager::self()->findChatSession( m_account->myself(), contacts, protocol() );
	if( canCreate == Kopete::Contact::CanCreate && !manager ) {
		QVariant tmpv = property( "mydesc" ).value();
		manager = Kopete::ChatSessionManager::self()->create( m_account->myself(), contacts, protocol() );
		manager->setDisplayName( QString( "%1 | %2 (%3)" ).arg( nickName() ).arg( tmpv.asString() ).arg( onlineStatus().description() ) );
		connect( manager, SIGNAL( messageSent( Kopete::Message&, Kopete::ChatSession* ) ), this, SLOT( sendMessage( Kopete::Message&, Kopete::ChatSession* ) ) );
	}
	
	return manager;
}

QPtrList<KAction> *SayclubContact::customContextMenuActions() //OBSOLETE
{
	//FIXME!!!  this function is obsolete, we should use XMLGUI instead
	/*m_actionCollection = new KActionCollection( this, "userColl" );
	m_actionPrefs = new KAction(i18n( "&Contact Settings" ), 0, this,
			SLOT( showContactSettings( )), m_actionCollection, "contactSettings" );

	return m_actionCollection;*/
	return 0L;
}

void SayclubContact::showContactSettings()
{
	//SayclubContactSettings* p = new SayclubContactSettings( this );
	//p->show();
}

void SayclubContact::sendMessage( Kopete::Message &message, Kopete::ChatSession */*session*/ )
{
	kdDebug( 14210 ) << k_funcinfo << endl;
	
	QCString messageBody = m_account->getCodec()->fromUnicode( message.plainBody() );
	messageBody.truncate( 500 );
	PHPObject o = PHPMapObject();
	PHPMapObject &m = o.asMap();
	m["method"] = string( "request_memoplus_send" );
	m["hwnd"] = string( "300000" ); // FIXME What the hell is this?
	m["content"] = string( (const char *)messageBody );
	m["flag"] = string( "1" );
	m["arrMsrl"] = PHPArrayObject();
	m["arrUserid"] = PHPArrayObject();
	QPtrList<Kopete::Contact> toList = message.to();
	QPtrListIterator<Kopete::Contact> it( toList );
	while( it.current() != 0 ) {
		if( it.current()->hasProperty( "msrl" ) ) {
			QVariant tmp = it.current()->property( "msrl" ).value();
			m["arrMsrl"].asArray().push_back( qstr2std( tmp.asString() ) );
			m["arrUserid"].asArray().push_back( qstr2std( it.current()->contactId() ) );
		}
		++it;
	}
	
	if( m["arrUserid"].asArray().size() == 0 )
		return;
	
	Kopete::Message *newMsg = new Kopete::Message( message );
	int rqid = m_account->server()->sendCmd( "request_memoplus_send", o, m_account, SLOT( slotSendMessage( int ) ) );
	// FIXME Is this thread-safe?
	m_account->server()->m_contactList.replace( rqid, this );
	m_account->server()->m_messageList.replace( rqid, newMsg );
}

// Show user info
void SayclubContact::slotUserInfo()
{
	if( !m_account->isConnected() )
		return;
	
	QVariant msrl = property( SayclubProtocol::protocol()->propMsrl ).value();
	PHPObject o = PHPMapObject();
		
	o.asMap()["methozd"] = string( "request_profile_detail" );
	o.asMap()["targetmsrl"] = qstr2std( msrl.asString() );
	
	m_account->server()->sendCmd( "request_profile_detail", o, this, SLOT( slotUserInfoRes( int ) ) );
}

// userinfo response
void SayclubContact::slotUserInfoRes( int rq )
{
	PHPObject &o = *m_account->server()->m_objectList[(long)rq];
	PHPMapObject &m = o.asMap();
	
	if( m_account->getErrorCode( o ) != -1 ) {
		emit errorMessage( SayclubServer::ErrorNormal, std2qstrenc( o.asMap()["errstr"].asString(), m_account->getCodec() ) );
		C_REMOVEREQ( rq );
		return;
	}	
	
	KDialogBase *infoDialog = new KDialogBase( NULL, "infoDialog", false, QString::null, KDialogBase::Close, KDialogBase::Close, false );
	SayclubInfo *info = new SayclubInfo( infoDialog, "info" );
	
	QVariant nickName = property( Kopete::Global::Properties::self()->nickName() ).value();
	QVariant isReversed = property( SayclubProtocol::protocol()->propReversed ).value();
	
	m_reverse = isReversed.asBool();
	info->m_intro->setText( std2qstrenc( m["self_intro"].asString(), m_account->getCodec() ) );
	info->m_nickname->setText( nickName.asString() );
	info->m_id->setText( contactId() );
	info->m_realName->setText( QString( "%1 (%2, %3)" ).arg( std2qstrenc( m["username"].asString(), m_account->getCodec() ) ).arg( std2qstrenc( m["sexstr"].asString(), m_account->getCodec() ) ).arg( std2qstrenc( m["agestr"].asString(), m_account->getCodec() ) ) );
	info->m_occupation->setText( std2qstrenc( m["jobstr"].asString(), m_account->getCodec() ) );
	info->m_birthday->setText( std2qstrenc( m["birthstr"].asString(), m_account->getCodec() ) );
	info->m_interest->setText( m["keyword"].isNull() ? QString( "" ):std2qstrenc( m["keyword"].asString(), m_account->getCodec() ) );
	info->m_region->setText( std2qstrenc( m["regionstr"].asString(), m_account->getCodec() ) );
	info->m_location->setText( std2qstrenc( m["present_location"].asString(), m_account->getCodec() ) );
	info->m_reverse->setChecked( m_reverse );
	
	connect( info->m_reverse, SIGNAL( toggled(bool) ), this, SLOT( slotCheckBoxReadOnly() ) );
	
	infoDialog->setMainWidget( info );
	infoDialog->setBaseSize( QSize( 560, 400 ) );
	infoDialog->setCaption( QString::fromUtf8( "%1 님의 사용자 정보 - 세이클럽 플러그인" ).arg( contactId() ) );
	infoDialog->show();
	
	C_REMOVEREQ( rq );
}

// workaround to make checkbox read-only
void SayclubContact::slotCheckBoxReadOnly()
{
	const QCheckBox *cb = dynamic_cast<const QCheckBox *>( sender() );
	if( cb && cb->isChecked() != m_reverse )
		const_cast<QCheckBox *>( cb )->setChecked( m_reverse );
}

#include "sayclubcontact.moc"

