/*
    sayclubaccount.h - Kopete Sayclub Protocol

    Copyright (c) 2006      by Park J. K.		 <nemesis@planetmono.org>
    Kopete    (c) 2002-2003 by the Kopete developers <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This library is free software; you can redistribute it and/or         *
    * modify it under the terms of the GNU General Public                   *
    * License as published by the Free Software Foundation; either          *
    * version 2 of the License, or (at your option) any later version.      *
    *                                                                       *
    *************************************************************************
*/

#ifndef SAYCLUBUTILITIES_H
#define SAYCLUBUTILITIES_H

class QCString;

#include <qstring.h>

class SayclubUtilities
{
public:
	// base64 functions
	static QCString base64Encode(const QCString in);
	static int base64Decode(QCString &out, const QCString &in);
	static QCString pseudoUUID();
	static QCString urlQuote(QCString in);
	static QCString urlUnquote(QCString oin);
	
	class ifInterf
	{
	public:
		ifInterf();
		~ifInterf() {}
		QString getIPAddr() { return m_ip; }
		QString getMacAddr() { return m_mac; }
		bool isSane() { return m_done; }
		
	private:
		QString m_ip;
		QString m_mac;
		bool m_done;
	};
	
private:
	static char getHex(char c);
	static bool isHex(char c);
};

#endif
