{
   This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}
unit Ufrmgetmosaic;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, httpsend2, StdCtrls, skinzip, Buttons;

type
  Tfrmgetmosaic = class(TForm)
    Label1: TLabel;
    Memo1: TMemo;
    Button1: TBitBtn;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
    fstream:Tfilestream;
    procedure SockOnWriteBuffer(Sender:TObject; var buffer:Pointer; len:integer);
  public
    { Public declarations }
  end;

var
  frmgetmosaic: Tfrmgetmosaic;

implementation
uses Ufunction;
{$R *.dfm}

function Getsite(s:string):string;
var
 s2:string;
 p1:integer;
begin
  s:=lowercase(s);
  p1:=pos('://',s);
  if p1<=0 then exit;
  s:=copy(s,p1+3,length(s));
  p1:=pos('/',s);
  if p1 > 0 then begin
    s2:=copy(s,1,p1-1);
  end else
    s2:=s;
  result:=s2;
end;

procedure Tfrmgetmosaic.Button1Click(Sender: TObject);
var
  http:thttpsend2;
  strlist,strlist2:tstringlist;
  s,folder,msg,url,size,filename:string;
  i:integer;
  UnZip:TSkinZip;
begin
  filename:=GetAppDirectory+'mosaictmp.zip';

  http:=thttpsend2.Create;
  strlist:=tstringlist.Create;
  strlist2:=tstringlist.Create;
  try
    s:=format('http://iblogbox.com/nview/update/update.php?v=%s&kind=getmosaic',[GetVersion(paramstr(0))]);
    http.HTTPMethod('get',s);
    strlist.LoadFromStream(HTTP.Document);
    s:=trim(strlist.Text);
    if s='' then begin
      MessageDlg('ٿ  Ȯ  ϴ.', mterror, [mbok], 0);
      exit;
    end;
    for i:=0 to strlist.Count-1 do begin
      s:=trim(strlist.Strings[i]);
      if s='' then continue;

      strlist2.Clear;
      SplitString(s,strlist2,'|');
      if strlist2.Count<>4 then begin
        MessageDlg('Դϴ.', mterror, [mbok], 0);
        exit;
      end;
      folder:=strlist2.Strings[0];
      msg:=strlist2.Strings[1];
      url:=strlist2.Strings[2];
      size:=strlist2.Strings[3];

      if sysutils.DirectoryExists(GetAppDirectory+'mosaic_images\'+folder) then begin
        if MessageDlg(format('"%s"  ̹ մϴ. ϵ ϴ.'+#13#10+' Ͻðڽϱ?',[folder]),
               mtConfirmation, [mbYes, mbNo], 0)=mrno then
          continue;
      end;

      Button1.Enabled:=false;      
      fstream:=Tfilestream.Create(filename,fmcreate or fmopenwrite);
      try
        http.Clear;
        http.Clear2;
        http.Fwritemanual:=true;
        http.Sock.OnWriteBuffer:=SockOnWriteBuffer;
        http.Headers.Add('Referer: http://'+Getsite(url));
        HTTP.HTTPMethod('get', url);
        if fstream.Size<>strtointdef(size,-1) then begin
          MessageDlg('Ϲޱ Դϴ.', mterror, [mbok], 0);
          exit;
        end;
      finally
        freeandnil(fstream);
      end;

      label1.Caption:='  Ǯ ֽϴ.  ٷ ּ...';
      application.ProcessMessages;

      try
       UnZip:=TSkinZip.Create(nil);
       UnZip.UzWithoutPath:=false;
       UnZip.UnZipfile:=filename;
       if UnZip.UnzipAllTo(GetAppDirectory+'mosaic_images') then
       else begin
         MessageDlg('Ǯ Դϴ.', mterror, [mbok], 0);
         exit;
       end;
      finally
        UnZip.Free;
      end;

{      sevenzip1.SZFileName := filename;
      sevenzip1.ExtrBaseDir := GetAppDirectory+'mosaic_images';
      sevenzip1.ExtractOptions := sevenzip1.ExtractOptions + [ExtractOverwrite];
      sevenzip1.Files.clear;
      sevenzip1.Extract;
}
      label1.Caption:=' Ǯϴ.';
      memo1.Lines.Add(msg);
      application.ProcessMessages;
//      MessageDlg(msg, mtinformation, [mbok], 0);
    end;

  finally
    strlist.Free;
    strlist2.Free;
    http.Free;
  end;
  sysutils.DeleteFile(filename);
end;

procedure Tfrmgetmosaic.SockOnWriteBuffer(Sender:TObject; var buffer:Pointer; len:integer);
begin
  if fstream=nil then exit;
  fstream.Write(buffer^, len);
  label1.Caption:=format('ũ: %s',[FormatFloat('#,###,###',fstream.Position)]);
  application.ProcessMessages;
end;

end.
