{
   This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}

Unit DLLSynchronizer;

Interface

Implementation
Uses Windows, Messages, classes;

Type
  TSyncHelper = Class
  Private
    wnd: HWND;
    Procedure MsgProc( Var msg: TMessage );
    Procedure Wakeup( sender: TObject );
  Public
    Constructor Create;
    Destructor Destroy; override;
  End;

Var
  helper: TSyncHelper = nil;

{ TSyncHelper }

Constructor TSyncHelper.Create;
Begin
  inherited;
  wnd:= AllocateHWnd( msgproc );
  WakeMainThread := Wakeup;
End;

Destructor TSyncHelper.Destroy;
Begin
  WakeMainThread := nil;
  DeallocateHWnd( wnd );
  inherited;
End;

Procedure TSyncHelper.MsgProc(Var msg: TMessage);
Begin
  If msg.Msg = WM_USER Then
    CheckSynchronize
  Else
    msg.result := DefWindowProc( wnd, msg.msg, msg.WParam, msg.LParam );
End;

Procedure TSyncHelper.Wakeup(sender: TObject);
Begin
  PostMessage( wnd, WM_USER, 0, 0 );
End;

Initialization
  helper:= TSyncHelper.Create;
Finalization
  helper.free;
End.
